/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import java.io.IOException;

public final class BinaryPropertyListUtil {
    public static boolean isBinaryPropertyList(ByteProvider provider) throws IOException {
        byte[] bytes = provider.readBytes(0L, (long)"bplist".length());
        String magic = new String(bytes);
        return "bplist".equals(magic);
    }

    public static boolean isBinaryPropertyList(Memory memory, Address address) {
        byte[] bytes = new byte["bplist".length()];
        try {
            memory.getBytes(address, bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String magic = new String(bytes);
        return "bplist".equals(magic);
    }

    public static String generateName(int index) {
        return BinaryPropertyListUtil.generateName((long)index & 0xFFFFFFFFL);
    }

    public static String generateName(long index) {
        return "BPLIST_Index_" + Long.toHexString(index);
    }
}

