/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import generic.jar.ResourceFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClassModuleTree {
    private FileNode root = new FileNode(null, "");

    public ClassModuleTree() {
    }

    public ClassModuleTree(ResourceFile treeFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(treeFile.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                String path = split[0];
                String module = split[1].equals("null") ? null : split[1];
                this.addNode(path, module);
            }
        }
    }

    public void addNode(String path, String moduleName) {
        String[] split = path.split("/");
        FileNode file = this.root;
        for (String string : split) {
            file = file.createNode(string);
        }
        file.setModule(moduleName);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClassModuleTree other = (ClassModuleTree)obj;
        return this.root.equals(other.root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public void trim() {
        this.root.trim();
    }

    public void printRecursively() {
        this.printRecursively(this.root);
    }

    public void saveFile(File outputFile) throws IOException {
        try (FileWriter writer = new FileWriter(outputFile);){
            List<FileNode> children = this.root.getChildren();
            for (FileNode child : children) {
                this.writeRecursively(writer, child);
            }
        }
    }

    private void writeRecursively(FileWriter writer, FileNode node) throws IOException {
        writer.write(node.getPath());
        writer.write(" ");
        writer.write(node.module == null ? "null" : node.module);
        writer.write("\n");
        List<FileNode> children = node.getChildren();
        for (FileNode child : children) {
            this.writeRecursively(writer, child);
        }
    }

    private void printRecursively(FileNode node) {
        System.out.println(node.getPath() + "  :   " + node.module);
        List<FileNode> children = node.getChildren();
        for (FileNode child : children) {
            this.printRecursively(child);
        }
    }

    public int getNodeCount() {
        return this.root.getCount();
    }

    public String getModuleName(String className) {
        String[] split = className.split("/");
        FileNode node = this.root;
        for (String name : split) {
            if ((node = node.getChild(name)) == null) {
                return null;
            }
            if (node.module == null) continue;
            return node.module;
        }
        return null;
    }

    public static void main(String[] args) {
        ClassModuleTree tree = new ClassModuleTree();
        tree.addNode("a/b/c", "module1");
        tree.addNode("a/b/d", "module1");
        tree.addNode("a/b/e", "module1");
        tree.addNode("a/x/a", "module2");
        tree.addNode("a/x/b", "module3");
        tree.printRecursively();
        System.out.println("------");
        tree.trim();
        tree.printRecursively();
    }

    static class FileNode
    implements Comparable<FileNode> {
        private FileNode parent;
        private Map<String, FileNode> children;
        private String module;
        private String name;

        public FileNode(FileNode parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int getCount() {
            int count = 1;
            if (this.children != null) {
                List<FileNode> childList = this.getChildren();
                for (FileNode child : childList) {
                    count += child.getCount();
                }
            }
            return count;
        }

        public String trim() {
            if (this.module != null) {
                return this.module;
            }
            if (this.children == null) {
                return null;
            }
            HashSet<String> set = new HashSet<String>();
            for (FileNode node : this.children.values()) {
                set.add(node.trim());
            }
            if (set.size() == 1) {
                this.module = (String)set.iterator().next();
                if (this.module != null) {
                    this.children = null;
                }
            }
            return this.module;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileNode other = (FileNode)obj;
            if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
                return false;
            }
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public void setModule(String moduleName) {
            this.module = moduleName;
        }

        public String getPath() {
            if (this.parent == null) {
                return "";
            }
            String parentPath = this.parent.getPath();
            if (parentPath.length() == 0) {
                return this.name;
            }
            return parentPath + "/" + this.name;
        }

        public FileNode createNode(String nodeName) {
            FileNode child;
            if (this.children == null) {
                this.children = new HashMap<String, FileNode>();
            }
            if ((child = this.children.get(nodeName)) == null) {
                child = new FileNode(this, nodeName);
                this.children.put(nodeName, child);
            }
            return child;
        }

        public List<FileNode> getChildren() {
            if (this.children == null) {
                return new ArrayList<FileNode>();
            }
            return new ArrayList<FileNode>(this.children.values());
        }

        @Override
        public int compareTo(FileNode o) {
            return this.name.compareTo(o.name);
        }

        public FileNode getChild(String childName) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(childName);
        }
    }
}

