/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.jung.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CompositeVertex<V, E> {
    private Collection<V> vertices;
    private Collection<E> internalEdges;
    private Collection<CompositeVertex<V, E>> nestedComposites;
    boolean doHashCode = true;
    int hashCode;

    public int hashCode() {
        if (this.doHashCode) {
            int sa = 0;
            for (V v : this.collectSimpleVertices()) {
                int hc = v.hashCode();
                int rearranged = hc >> 32 - sa | hc << sa;
                this.hashCode ^= rearranged;
                sa += 11;
                while (sa > 31) {
                    sa -= 32;
                }
            }
            this.doHashCode = false;
        }
        return this.hashCode;
    }

    public CompositeVertex(V vertex) {
        this(Arrays.asList(vertex), new ArrayList<CompositeVertex<V, E>>(0));
    }

    public CompositeVertex(Collection<CompositeVertex<V, E>> nestedComposites) {
        this(new ArrayList(0), nestedComposites);
    }

    public CompositeVertex(Collection<V> vertices, Collection<CompositeVertex<V, E>> nestedComposites) {
        this.vertices = Collections.unmodifiableCollection(vertices);
        this.internalEdges = new ArrayList();
        this.nestedComposites = Collections.unmodifiableCollection(nestedComposites);
    }

    public void addInternalEdge(E edge) {
        this.internalEdges.add(edge);
    }

    public Set<V> collectSimpleVertices() {
        HashSet<V> result = new HashSet<V>();
        result.addAll(this.vertices);
        for (CompositeVertex<V, E> composite : this.nestedComposites) {
            Set<V> simpleVertices = composite.collectSimpleVertices();
            result.addAll(simpleVertices);
        }
        return result;
    }

    public Set<E> collectInternalEdges() {
        HashSet<E> result = new HashSet<E>();
        result.addAll(this.internalEdges);
        for (CompositeVertex<V, E> composite : this.nestedComposites) {
            Set<E> edges = composite.collectInternalEdges();
            result.addAll(edges);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("V: ");
        sb.append(this.collectSimpleVertices());
        sb.append(" E: ");
        sb.append(this.collectInternalEdges());
        return sb.toString();
    }
}

