/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.plugin.VTSubToolManager;
import ghidra.framework.model.DomainFile;
import ghidra.util.HelpLocation;
import java.awt.Component;

public class ResetToolAction
extends DockingAction {
    private VTController controller;
    private final VTSubToolManager toolManager;

    public ResetToolAction(VTController controller, VTSubToolManager toolManager) {
        super("Reset Sub Tools", VTPlugin.OWNER);
        this.controller = controller;
        this.toolManager = toolManager;
        String[] menuPath = new String[]{"&Edit", "Reset Source and Destination Tools"};
        this.setMenuBarData(new MenuData(menuPath));
        this.setDescription("Resets source and destination program tools back to default configurations.");
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Reset_Tools"));
    }

    public void actionPerformed(ActionContext context) {
        DomainFile vtSessionFile = null;
        VTSession session = this.controller.getSession();
        if (session != null) {
            int result = OptionDialog.showYesNoDialog((Component)this.controller.getTool().getToolFrame(), (String)"Restart Session?", (String)"This action needs to close and reopen the session to reset the tools.\nDo you want to continue?");
            if (result == 2) {
                return;
            }
            if (session instanceof VTSessionDB) {
                vtSessionFile = ((VTSessionDB)session).getDomainFile();
            }
            if (!this.controller.closeVersionTrackingSession()) {
                return;
            }
        }
        this.toolManager.resetTools();
        if (vtSessionFile != null) {
            this.controller.openVersionTrackingSession(vtSessionFile);
        }
    }
}

