/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.util;

import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class VTMatchUtil {
    public static AddressSetView getMatchAddresses(VTMatch vtMatch, boolean forSource) {
        Listing listing;
        Data data;
        VTMatchSet matchSet = vtMatch.getMatchSet();
        VTSession session = matchSet.getSession();
        Program program = forSource ? session.getSourceProgram() : session.getDestinationProgram();
        AddressFactory factory = program.getAddressFactory();
        Address address = forSource ? vtMatch.getAssociation().getSourceAddress() : vtMatch.getAssociation().getDestinationAddress();
        VTAssociation association = vtMatch.getAssociation();
        VTAssociationType associationType = association.getType();
        AddressSetView matchAddresses = null;
        if (associationType == VTAssociationType.FUNCTION) {
            Function function = program.getFunctionManager().getFunctionAt(address);
            if (function != null) {
                matchAddresses = function.getBody();
            }
        } else if (associationType == VTAssociationType.DATA && (data = (listing = program.getListing()).getDataAt(address)) != null) {
            matchAddresses = new AddressSet(data.getMinAddress(), data.getMaxAddress());
        }
        if (matchAddresses == null) {
            matchAddresses = new AddressSet(address, address);
        }
        return matchAddresses;
    }
}

