/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.LocalVariableJava;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class LocalVariableTableAttribute
extends AbstractAttributeInfo {
    private short localVariableTableLength;
    private LocalVariableJava[] localVariableTable;

    public LocalVariableTableAttribute(BinaryReader reader, AbstractConstantPoolInfoJava[] constantPool) throws IOException {
        super(reader);
        this.localVariableTableLength = reader.readNextShort();
        this.localVariableTable = new LocalVariableJava[this.localVariableTableLength & 0xFFFF];
        for (int i = 0; i < (this.localVariableTableLength & 0xFFFF); ++i) {
            this.localVariableTable[i] = new LocalVariableJava(reader);
        }
    }

    public LocalVariableJava[] getLocalVariables() {
        return this.localVariableTable;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("LocalVariableTable_attribute");
        structure.add(WORD, "local_variable_table_length", null);
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            structure.add(this.localVariableTable[i].toDataType(), "local_variable_" + i, null);
        }
        return structure;
    }
}

