/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import org.apache.logging.log4j.Level;

public class FVTableModel
extends AbstractTableModel {
    public static final int DATE_COL = 0;
    public static final int TIME_COL = 1;
    public static final int LEVEL_COL = 2;
    public static final int MESSAGE_COL = 3;
    private static final Pattern dateRegex = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private static final String spaceRegex = "\\s+";
    private static final Pattern timeRegex = Pattern.compile("(?:[01]\\d|2[0123]):(?:[012345]\\d):(?:[012345]\\d(,\\d\\d\\d)?)");
    private static final Pattern levelRegex = Pattern.compile("\\s+" + Level.OFF + "\\s+|\\s+" + Level.DEBUG.toString() + "\\s+|\\s+" + Level.TRACE.toString() + "\\s+|\\s+" + Level.WARN.toString() + "\\s+|\\s+" + Level.INFO.toString() + "\\s+|\\s+" + Level.ERROR.toString() + "\\s+|\\s+" + Level.FATAL.toString() + "\\s+");
    private List<String> dates = new ArrayList<String>();
    private List<String> times = new ArrayList<String>();
    private List<String> levels = new ArrayList<String>();
    private List<String> messages = new ArrayList<String>();

    @Override
    public int getRowCount() {
        return this.messages.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Date";
            }
            case 1: {
                return "Time";
            }
            case 2: {
                return "Level";
            }
            case 3: {
                return "Message";
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.messages.size()) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.dates.get(rowIndex);
            }
            case 1: {
                return this.times.get(rowIndex);
            }
            case 2: {
                return this.levels.get(rowIndex);
            }
            case 3: {
                return this.messages.get(rowIndex);
            }
        }
        return null;
    }

    public void addRow(String row, boolean notify) {
        this.addRow(row, this.messages.size(), notify);
    }

    public void addRow(String row, int index, boolean notify) {
        String date = this.getDate(row);
        this.dates.add(index, date);
        row = row.replaceFirst(date, "");
        String time = this.getTime(row);
        this.times.add(index, time);
        row = row.replaceFirst(time, "");
        String level = this.getLevel(row);
        this.levels.add(index, level);
        row = row.replaceFirst(level, "");
        this.messages.add(index, row.trim());
        if (notify) {
            this.fireTableRowsInserted(this.messages.size() - 1, this.messages.size() - 1);
        }
    }

    public void addRowsToTop(List<String> rows) {
        for (int i = 0; i < rows.size(); ++i) {
            this.addRow(rows.get(i), i, false);
        }
        this.fireTableDataChanged();
    }

    public void addRowsToBottom(List<String> rows) {
        for (String row : rows) {
            this.addRow(row, false);
        }
        this.fireTableDataChanged();
    }

    public void removeRowsFromBottom(int count) {
        for (int i = 0; i < count; ++i) {
            this.levels.remove(this.levels.size() - 1);
            this.dates.remove(this.dates.size() - 1);
            this.messages.remove(this.messages.size() - 1);
            this.times.remove(this.times.size() - 1);
        }
        this.fireTableDataChanged();
    }

    public void removeRowsFromTop(int count) {
        for (int i = 0; i < count; ++i) {
            if (this.messages.isEmpty()) continue;
            this.messages.remove(0);
            this.dates.remove(0);
            this.levels.remove(0);
            this.times.remove(0);
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        this.dates.clear();
        this.levels.clear();
        this.messages.clear();
        this.times.clear();
        this.fireTableDataChanged();
    }

    private String getDate(String row) {
        Matcher m = dateRegex.matcher(row);
        return m.find() ? m.group() : "";
    }

    private String getLevel(String row) {
        Matcher m = levelRegex.matcher(row);
        return m.find() ? m.group().trim() : "";
    }

    private String getTime(String row) {
        Matcher m = timeRegex.matcher(row);
        return m.find() ? m.group() : "";
    }
}

