/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.AbstractTransactionManager;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectTransactionManager;
import ghidra.framework.data.SynchronizedTransaction;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.store.LockException;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.LinkedList;

class SynchronizedTransactionManager
extends AbstractTransactionManager {
    private LinkedList<SynchronizedTransaction> undoList = new LinkedList();
    private LinkedList<SynchronizedTransaction> redoList = new LinkedList();
    private DomainObjectAdapterDB[] domainObjects = new DomainObjectAdapterDB[0];
    private DomainObjectTransactionManager[] domainObjectTransactionManagers = new DomainObjectTransactionManager[0];
    private SynchronizedTransaction transaction;

    SynchronizedTransactionManager() {
    }

    @Override
    DomainObjectAdapterDB[] getDomainObjects() {
        return this.domainObjects;
    }

    @Override
    synchronized void clearTransactions() {
        for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
            mgr.clearTransactions();
        }
        this.undoList.clear();
        this.redoList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDomainObject(DomainObjectAdapterDB domainObj) throws LockException {
        SynchronizedTransactionManager synchronizedTransactionManager = this;
        synchronized (synchronizedTransactionManager) {
            AbstractTransactionManager mgr = domainObj.getTransactionManager();
            if (!(mgr instanceof DomainObjectTransactionManager)) {
                throw new IllegalArgumentException("domain object has invalid transaction manager");
            }
            if (this.isLocked() || mgr.isLocked() || this.getCurrentTransaction() != null || mgr.getCurrentTransaction() != null) {
                throw new LockException("domain object(s) are busy/locked");
            }
            if (!mgr.lock("Transaction manager join")) {
                throw new LockException("domain object is busy");
            }
            this.clearTransactions();
            int count = this.domainObjects.length + 1;
            DomainObjectAdapterDB[] updatedDomainObjects = new DomainObjectAdapterDB[count];
            DomainObjectTransactionManager[] updatedManagers = new DomainObjectTransactionManager[count];
            System.arraycopy(this.domainObjects, 0, updatedDomainObjects, 0, this.domainObjects.length);
            updatedDomainObjects[count - 1] = domainObj;
            System.arraycopy(this.domainObjectTransactionManagers, 0, updatedManagers, 0, this.domainObjectTransactionManagers.length);
            updatedManagers[count - 1] = (DomainObjectTransactionManager)domainObj.getTransactionManager();
            this.domainObjects = updatedDomainObjects;
            this.domainObjectTransactionManagers = updatedManagers;
            domainObj.setTransactionManager(this);
            updatedManagers[count - 1].lockCount = 0;
        }
        this.notifyUndoableListeners();
    }

    synchronized void removeDomainObject(DomainObjectAdapterDB domainObj) throws LockException {
        if (this.getCurrentTransaction() != null) {
            throw new LockException("domain object has open transaction: " + this.getCurrentTransaction().getDescription());
        }
        if (this.isLocked()) {
            throw new LockException("domain object is locked!");
        }
        if (domainObj.getTransactionManager() != this) {
            throw new IllegalArgumentException("domain object has different transaction manager");
        }
        int index = -1;
        for (int i = 0; i < this.domainObjects.length; ++i) {
            if (this.domainObjects[i] != domainObj) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new IllegalArgumentException("invalid domain object");
        }
        this.clearTransactions();
        DomainObjectTransactionManager restoredMgr = this.domainObjectTransactionManagers[index];
        int count = this.domainObjects.length - 1;
        DomainObjectAdapterDB[] updatedDomainObjects = new DomainObjectAdapterDB[count];
        DomainObjectTransactionManager[] updatedManagers = new DomainObjectTransactionManager[count];
        System.arraycopy(this.domainObjects, 0, updatedDomainObjects, 0, index);
        System.arraycopy(this.domainObjectTransactionManagers, 0, updatedManagers, 0, index);
        if (index < count) {
            System.arraycopy(this.domainObjects, index + 1, updatedDomainObjects, index, count - index);
            System.arraycopy(this.domainObjectTransactionManagers, index + 1, updatedManagers, index, count - index);
        }
        this.domainObjects = updatedDomainObjects;
        this.domainObjectTransactionManagers = updatedManagers;
        domainObj.setTransactionManager(restoredMgr);
        restoredMgr.notifyUndoStackChanged();
        if (count == 1) {
            this.removeDomainObject(this.domainObjects[0]);
        } else {
            this.notifyUndoableListeners();
        }
    }

    @Override
    void terminateTransaction(boolean rollback, boolean notify) {
        if (this.transaction == null || this.transactionTerminated) {
            return;
        }
        for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
            ((AbstractTransactionManager)mgr).terminateTransaction(rollback, false);
        }
        this.transactionTerminated = true;
        if (notify) {
            this.notifyEndTransaction();
        }
    }

    @Override
    synchronized int startTransaction(DomainObjectAdapterDB object, String description, AbortedTransactionListener listener, boolean force, boolean notify) {
        if (!force) {
            this.verifyNoLock();
        }
        if (this.transaction == null) {
            this.transactionTerminated = false;
            this.transaction = new SynchronizedTransaction(this.domainObjectTransactionManagers);
            int txId = this.transaction.addEntry(object, description, listener);
            if (notify) {
                this.notifyStartTransaction();
            }
            return txId;
        }
        if (this.transactionTerminated) {
            Msg.warn((Object)this, (Object)("Aborted transaction still pending, new transaction will also be aborted: " + description));
        }
        int txId = this.transaction.addEntry(object, description, listener);
        if (notify) {
            this.notifyStartTransaction();
        }
        return txId;
    }

    @Override
    synchronized Transaction endTransaction(DomainObjectAdapterDB object, int transactionID, boolean commit, boolean notify) {
        if (this.transaction == null) {
            throw new IllegalStateException("No transaction is open");
        }
        SynchronizedTransaction returnedTransaction = this.transaction;
        this.transaction.endEntry(object, transactionID, commit && !this.transactionTerminated);
        int status = this.transaction.getStatus();
        if (status == 1) {
            boolean committed = this.transaction.endAll(true);
            if (committed) {
                this.redoList.clear();
                this.undoList.addLast(this.transaction);
                if (this.undoList.size() > 50) {
                    this.undoList.removeFirst();
                }
            }
            this.transaction = null;
            if (notify) {
                this.notifyEndTransaction();
            }
        } else if (status == 2) {
            if (!this.transactionTerminated) {
                this.transaction.endAll(false);
            }
            this.transaction = null;
            if (notify) {
                this.notifyEndTransaction();
            }
        }
        return returnedTransaction;
    }

    @Override
    int getUndoStackDepth() {
        return this.undoList.size();
    }

    @Override
    synchronized boolean canRedo() {
        if (this.redoList.size() > 0) {
            for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
                if (!mgr.canRedo()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    synchronized boolean canUndo() {
        if (this.undoList.size() > 0) {
            for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
                if (!mgr.canUndo()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    synchronized String getRedoName() {
        if (this.redoList.size() > 0) {
            Transaction t = this.redoList.getLast();
            return t.getDescription();
        }
        return "";
    }

    @Override
    synchronized String getUndoName() {
        if (this.undoList.size() > 0) {
            Transaction t = this.undoList.getLast();
            return t.getDescription();
        }
        return "";
    }

    @Override
    Transaction getCurrentTransaction() {
        return this.transaction;
    }

    @Override
    void doRedo(boolean notify) throws IOException {
        if (this.canRedo()) {
            SynchronizedTransaction t = this.redoList.removeLast();
            this.undoList.addLast(t);
            t.redo();
            if (notify) {
                this.notifyUndoableListeners();
            }
        }
    }

    @Override
    void doUndo(boolean notify) throws IOException {
        if (this.canUndo()) {
            SynchronizedTransaction t = this.undoList.removeLast();
            this.redoList.addLast(t);
            t.undo();
            if (notify) {
                this.notifyUndoableListeners();
            }
        }
    }

    @Override
    synchronized void clearUndo(boolean notifyListeners) {
        if (!this.undoList.isEmpty() || !this.redoList.isEmpty()) {
            this.undoList.clear();
            this.redoList.clear();
            for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
                mgr.clearUndo(false);
            }
            if (notifyListeners) {
                this.notifyUndoableListeners();
            }
        }
    }

    @Override
    void doClose(DomainObjectAdapterDB object) {
        try {
            this.removeDomainObject(object);
        }
        catch (LockException e) {
            throw new IllegalStateException(e);
        }
        object.getTransactionManager().close(object);
    }

    @Override
    synchronized void addTransactionListener(DomainObjectAdapterDB object, TransactionListener listener) {
        for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
            if (mgr.getDomainObject() != object) continue;
            mgr.addTransactionListener(object, listener);
            return;
        }
        throw new IllegalArgumentException("invalid domain object");
    }

    @Override
    synchronized void removeTransactionListener(DomainObjectAdapterDB object, TransactionListener listener) {
        for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
            if (mgr.getDomainObject() != object) continue;
            mgr.removeTransactionListener(object, listener);
            return;
        }
        throw new IllegalArgumentException("invalid domain object");
    }

    private void notifyUndoableListeners() {
        for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
            mgr.notifyUndoStackChanged();
        }
    }

    private void notifyStartTransaction() {
        for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
            mgr.notifyStartTransaction(this.transaction);
        }
    }

    private void notifyEndTransaction() {
        for (DomainObjectTransactionManager mgr : this.domainObjectTransactionManagers) {
            mgr.notifyEndTransaction();
        }
    }
}

