/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.Settings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsImpl
implements Settings,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> map = new HashMap<String, Object>();
    private Settings defaultSettings;
    private ChangeListener listener;
    private Object changeSourceObj;
    public static final Settings NO_SETTINGS = new SettingsImpl(){

        @Override
        public void setByteArray(String name, byte[] value) {
        }

        @Override
        public void setDefaultSettings(Settings settings) {
        }

        @Override
        public void setLong(String name, long value) {
        }

        @Override
        public void setString(String name, String value) {
        }

        @Override
        public void setValue(String name, Object value) {
        }
    };

    public SettingsImpl() {
    }

    public SettingsImpl(ChangeListener listener, Object changeSourceObj) {
        this();
        this.listener = listener;
        this.changeSourceObj = changeSourceObj;
    }

    public SettingsImpl(Settings settings) {
        this();
        String[] names = settings.getNames();
        for (int i = 0; i < names.length; ++i) {
            this.map.put(names[i], settings.getValue(names[i]));
        }
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Long getLong(String name) {
        Long value = (Long)this.map.get(name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getLong(name);
        }
        return value;
    }

    @Override
    public String getString(String name) {
        String value = (String)this.map.get(name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getString(name);
        }
        return value;
    }

    @Override
    public byte[] getByteArray(String name) {
        byte[] bytes = (byte[])this.map.get(name);
        if (bytes == null && this.defaultSettings != null) {
            bytes = this.defaultSettings.getByteArray(name);
        }
        return bytes;
    }

    @Override
    public void setLong(String name, long value) {
        this.map.put(name, new Long(value));
        this.changed();
    }

    @Override
    public void setString(String name, String value) {
        this.map.put(name, value);
        this.changed();
    }

    @Override
    public void setByteArray(String name, byte[] value) {
        this.map.put(name, value);
        this.changed();
    }

    @Override
    public void clearSetting(String name) {
        this.map.remove(name);
        this.changed();
    }

    @Override
    public String[] getNames() {
        String[] names = new String[this.map.size()];
        Iterator<String> it = this.map.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            names[i++] = it.next();
        }
        return names;
    }

    @Override
    public Object getValue(String name) {
        Object value = this.map.get(name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getValue(name);
        }
        return value;
    }

    @Override
    public void setValue(String name, Object value) {
        if (value instanceof Long || value instanceof String || value instanceof byte[]) {
            this.map.put(name, value);
            this.changed();
            return;
        }
        throw new IllegalArgumentException("Value is not a known settings type");
    }

    private void changed() {
        if (this.listener != null) {
            ChangeEvent evt = null;
            if (this.changeSourceObj != null) {
                evt = new ChangeEvent(this.changeSourceObj);
            }
            this.listener.stateChanged(evt);
        }
    }

    @Override
    public void clearAllSettings() {
        this.map.clear();
        this.changed();
    }

    public void setDefaultSettings(Settings settings) {
        this.defaultSettings = settings;
    }

    @Override
    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }
}

