/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.VerticalLayoutTextField;
import docking.widgets.fieldpanel.support.HighlightFactory;
import java.util.ArrayList;

public class FlowLayoutTextField
extends VerticalLayoutTextField {
    public FlowLayoutTextField(FieldElement[] textElements, int startX, int width, int maxLines, HighlightFactory hlFactory) {
        super(FlowLayoutTextField.createLineElements(textElements, width), startX, width, maxLines, hlFactory, "");
    }

    private static FieldElement[] createLineElements(FieldElement[] textElements, int width) {
        int numberPerLine;
        ArrayList<CompositeFieldElement> subFields = new ArrayList<CompositeFieldElement>();
        for (int currentIndex = 0; currentIndex < textElements.length; currentIndex += numberPerLine) {
            numberPerLine = FlowLayoutTextField.getNumberOfElementsPerLine(textElements, currentIndex, width);
            subFields.add(new CompositeFieldElement(textElements, currentIndex, numberPerLine));
        }
        return subFields.toArray(new FieldElement[subFields.size()]);
    }

    private static int getNumberOfElementsPerLine(FieldElement[] elements, int start, int width) {
        int currentWidth = 0;
        int count = 0;
        int n = elements.length;
        for (int i = start; i < n; ++i) {
            ++count;
            if ((currentWidth += elements[i].getStringWidth()) <= width) continue;
            return Math.max(count - 1, 1);
        }
        return elements.length - start;
    }
}

