/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

public class StringFormat {
    private StringFormat() {
    }

    public static String hexByteString(byte b) {
        String rep = Integer.toHexString(b & 0xFF).toUpperCase();
        if (rep.length() == 1) {
            return "0" + rep;
        }
        return rep;
    }

    public static String hexWordString(short s) {
        String rep = Integer.toHexString(s & 0xFFFF).toUpperCase();
        return StringFormat.padIt(rep, 4, '\u0000', true);
    }

    public static String padIt(String str, int padlen, char endchar, boolean padded) {
        int len;
        String pad = "0000000000000000000000000000000000000000000000000000000000000000";
        StringBuffer buffer = new StringBuffer();
        if (padded && (len = str.length()) < padlen) {
            buffer.append(pad.substring(0, padlen - len));
        }
        buffer.append(str);
        if (endchar != '\u0000') {
            buffer.append(endchar);
        }
        return buffer.toString();
    }
}

