/*
 * Decompiled with CFR 0.152.
 */
package ghidra.generic.util.datastruct;

import ghidra.util.ReversedListIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.apache.commons.collections4.comparators.ComparableComparator;

public class DynamicValueSortedTreeMap<K, V>
extends AbstractMap<K, V> {
    private final Comparator<V> comparator;
    private final Map<K, Node> nodeMap = new HashMap<K, Node>();
    private final transient ValueSortedTreeMapEntrySet entrySet = new ValueSortedTreeMapEntrySet();
    private final transient ValueSortedTreeMapKeySet keySet = new ValueSortedTreeMapKeySet();
    private final transient ValueSortedTreeMapValues values = new ValueSortedTreeMapValues();
    private Node root;
    private Node head;
    private Node tail;

    protected static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public DynamicValueSortedTreeMap() {
        this((Comparator<V>)new ComparableComparator());
    }

    public DynamicValueSortedTreeMap(Comparator<V> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void clear() {
        this.nodeMap.clear();
        this.head = null;
        this.tail = null;
        this.root = null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nodeMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            Object val = value;
            return this.root.searchValue(val, SearchMode.ANY) != null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public ValueSortedTreeMapEntrySet entrySet() {
        return this.entrySet;
    }

    @Override
    public V get(Object key) {
        Node n = this.nodeMap.get(key);
        if (n == null) {
            return null;
        }
        return n.val;
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    private boolean isOrdered(Node n) {
        if (n.prev != null && this.comparator.compare(n.prev.val, n.val) > 0) {
            return false;
        }
        return n.next == null || this.comparator.compare(n.next.val, n.val) >= 0;
    }

    public ValueSortedTreeMapKeySet keySet() {
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        Node n = this.nodeMap.get(key);
        if (n != null) {
            return n.setValue(value);
        }
        n = new Node(key, value);
        this.nodeMap.put(key, n);
        if (this.root == null) {
            this.root = n;
            this.head = n;
            this.tail = n;
        } else {
            this.root.insert(n);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> ent : m.entrySet()) {
            this.put(ent.getKey(), ent.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Node n = this.nodeMap.remove(key);
        if (n == null) {
            return null;
        }
        n.remove();
        return n.val;
    }

    @Override
    public int size() {
        return this.nodeMap.size();
    }

    public boolean update(K key) {
        Node n = this.nodeMap.get(key);
        if (n == null) {
            throw new NoSuchElementException();
        }
        return this.updateNode(n);
    }

    private boolean updateNode(Node n) {
        if (this.isOrdered(n)) {
            return false;
        }
        n.remove();
        this.root.insert(n);
        return true;
    }

    public ValueSortedTreeMapValues values() {
        return this.values;
    }

    public class ValueSortedTreeMapValues
    extends AbstractCollection<V>
    implements List<V>,
    Deque<V> {
        private ValueSortedTreeMapValues() {
        }

        @Override
        public void add(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirst(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            DynamicValueSortedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Object val = o;
                return DynamicValueSortedTreeMap.this.root.searchValue(val, SearchMode.ANY) != null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<V> descendingIterator() {
            return new ReversedListIterator(new ValueListIterator(DynamicValueSortedTreeMap.this.tail.next));
        }

        @Override
        public V element() {
            return this.getFirst();
        }

        @Override
        public V get(int index) {
            return DynamicValueSortedTreeMap.this.entrySet.get((int)index).val;
        }

        @Override
        public V getFirst() {
            return DynamicValueSortedTreeMap.this.entrySet.getFirst().val;
        }

        @Override
        public V getLast() {
            return DynamicValueSortedTreeMap.this.entrySet.getLast().val;
        }

        @Override
        public int indexOf(Object o) {
            try {
                Object val = o;
                Node n = DynamicValueSortedTreeMap.this.root.searchValue(val, SearchMode.FIRST);
                if (n == null) {
                    return -1;
                }
                return n.computeIndex();
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        @Override
        public boolean isEmpty() {
            return DynamicValueSortedTreeMap.this.root == null;
        }

        @Override
        public Iterator<V> iterator() {
            return this.listIterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            try {
                Object val = o;
                Node n = DynamicValueSortedTreeMap.this.root.searchValue(val, SearchMode.LAST);
                if (n == null) {
                    return -1;
                }
                return n.computeIndex();
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        @Override
        public ListIterator<V> listIterator() {
            return new ValueListIterator(DynamicValueSortedTreeMap.this.head);
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return new ValueListIterator(DynamicValueSortedTreeMap.this.root.getByIndex(index));
        }

        @Override
        public boolean offer(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerFirst(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerLast(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V peek() {
            return this.peekFirst();
        }

        @Override
        public V peekFirst() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.peekFirst();
            if (n == null) {
                return null;
            }
            return n.val;
        }

        @Override
        public V peekLast() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.peekLast();
            if (n == null) {
                return null;
            }
            return n.val;
        }

        @Override
        public V poll() {
            return this.pollFirst();
        }

        @Override
        public V pollFirst() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.pollFirst();
            if (n == null) {
                return null;
            }
            return n.val;
        }

        @Override
        public V pollLast() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.pollLast();
            if (n == null) {
                return null;
            }
            return n.val;
        }

        @Override
        public V pop() {
            return this.removeFirst();
        }

        @Override
        public void push(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove() {
            return this.removeFirst();
        }

        @Override
        public V remove(int index) {
            return DynamicValueSortedTreeMap.this.entrySet.remove((int)index).val;
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFirstOccurrence(o);
        }

        @Override
        public V removeFirst() {
            return DynamicValueSortedTreeMap.this.entrySet.removeFirst().val;
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            try {
                Object val = o;
                Node n = DynamicValueSortedTreeMap.this.root.searchValue(val, SearchMode.FIRST);
                if (n == null) {
                    return false;
                }
                n.remove();
                DynamicValueSortedTreeMap.this.nodeMap.remove(n.key);
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public V removeLast() {
            return DynamicValueSortedTreeMap.this.entrySet.removeLast().val;
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            try {
                Object val = o;
                Node n = DynamicValueSortedTreeMap.this.root.searchValue(val, SearchMode.LAST);
                if (n == null) {
                    return false;
                }
                n.remove();
                DynamicValueSortedTreeMap.this.nodeMap.remove(n.key);
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public V set(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return DynamicValueSortedTreeMap.this.nodeMap.size();
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    public class ValueSortedTreeMapKeySet
    extends AbstractSet<K>
    implements List<K>,
    Deque<K> {
        private ValueSortedTreeMapKeySet() {
        }

        @Override
        public void add(int index, K element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirst(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            DynamicValueSortedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return DynamicValueSortedTreeMap.this.nodeMap.containsKey(o);
        }

        @Override
        public Iterator<K> descendingIterator() {
            return new ReversedListIterator(new KeyListIterator(DynamicValueSortedTreeMap.this.tail.next));
        }

        @Override
        public K element() {
            return this.getFirst();
        }

        @Override
        public K get(int index) {
            return DynamicValueSortedTreeMap.this.entrySet.get((int)index).key;
        }

        @Override
        public K getFirst() {
            return DynamicValueSortedTreeMap.this.entrySet.getFirst().key;
        }

        @Override
        public K getLast() {
            return DynamicValueSortedTreeMap.this.entrySet.getLast().key;
        }

        @Override
        public int indexOf(Object o) {
            Node n = DynamicValueSortedTreeMap.this.nodeMap.get(o);
            if (n == null) {
                return -1;
            }
            return n.computeIndex();
        }

        @Override
        public boolean isEmpty() {
            return DynamicValueSortedTreeMap.this.root == null;
        }

        @Override
        public Iterator<K> iterator() {
            return this.listIterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<K> listIterator() {
            return new KeyListIterator(DynamicValueSortedTreeMap.this.head);
        }

        @Override
        public ListIterator<K> listIterator(int index) {
            return new KeyListIterator(DynamicValueSortedTreeMap.this.root.getByIndex(index));
        }

        @Override
        public boolean offer(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerFirst(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerLast(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K peek() {
            return this.peekFirst();
        }

        @Override
        public K peekFirst() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.peekFirst();
            if (n == null) {
                return null;
            }
            return n.key;
        }

        @Override
        public K peekLast() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.peekLast();
            if (n == null) {
                return null;
            }
            return n.key;
        }

        @Override
        public K poll() {
            return this.pollFirst();
        }

        @Override
        public K pollFirst() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.pollFirst();
            if (n == null) {
                return null;
            }
            return n.key;
        }

        @Override
        public K pollLast() {
            Node n = DynamicValueSortedTreeMap.this.entrySet.pollLast();
            if (n == null) {
                return null;
            }
            return n.key;
        }

        @Override
        public K pop() {
            return this.removeFirst();
        }

        @Override
        public void push(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K remove() {
            return this.removeFirst();
        }

        @Override
        public K remove(int index) {
            return DynamicValueSortedTreeMap.this.entrySet.remove((int)index).key;
        }

        @Override
        public boolean remove(Object o) {
            return DynamicValueSortedTreeMap.this.remove(o) != null;
        }

        @Override
        public K removeFirst() {
            return DynamicValueSortedTreeMap.this.entrySet.removeFirst().key;
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            return DynamicValueSortedTreeMap.this.remove(o) != null;
        }

        @Override
        public K removeLast() {
            return DynamicValueSortedTreeMap.this.entrySet.removeLast().key;
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            return DynamicValueSortedTreeMap.this.remove(o) != null;
        }

        @Override
        public K set(int index, K element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return DynamicValueSortedTreeMap.this.nodeMap.size();
        }

        @Override
        public Spliterator<K> spliterator() {
            return Spliterators.spliterator(this, 17);
        }

        @Override
        public List<K> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    public class ValueSortedTreeMapEntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements List<Map.Entry<K, V>>,
    Deque<Map.Entry<K, V>> {
        private ValueSortedTreeMapEntrySet() {
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            return DynamicValueSortedTreeMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public void add(int index, Map.Entry<K, V> element) {
            this.add(element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Map.Entry<K, V>> c) {
            return this.addAll(c);
        }

        @Override
        public void addFirst(Map.Entry<K, V> e) {
            DynamicValueSortedTreeMap.this.put(e.getKey(), e.getValue());
        }

        @Override
        public void addLast(Map.Entry<K, V> e) {
            DynamicValueSortedTreeMap.this.put(e.getKey(), e.getValue());
        }

        @Override
        public void clear() {
            DynamicValueSortedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            try {
                Node n = (Node)o;
                Node m = DynamicValueSortedTreeMap.this.nodeMap.get(n.key);
                return DynamicValueSortedTreeMap.eq(n.val, m.val);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingIterator() {
            return new ReversedListIterator(new EntryListIterator(DynamicValueSortedTreeMap.this.tail.next));
        }

        @Override
        public Node element() {
            return this.getFirst();
        }

        @Override
        public Node get(int index) {
            return DynamicValueSortedTreeMap.this.root.getByIndex(index);
        }

        @Override
        public Node getFirst() {
            Node ret = this.peekFirst();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public Node getLast() {
            Node ret = this.peekLast();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                return -1;
            }
            try {
                Node n = (Node)o;
                return n.computeIndex();
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        @Override
        public boolean isEmpty() {
            return DynamicValueSortedTreeMap.this.root == null;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.listIterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<Map.Entry<K, V>> listIterator() {
            return new EntryListIterator(DynamicValueSortedTreeMap.this.head);
        }

        @Override
        public ListIterator<Map.Entry<K, V>> listIterator(int index) {
            return new EntryListIterator(DynamicValueSortedTreeMap.this.root.getByIndex(index));
        }

        @Override
        public boolean offer(Map.Entry<K, V> e) {
            return DynamicValueSortedTreeMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public boolean offerFirst(Map.Entry<K, V> e) {
            return DynamicValueSortedTreeMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public boolean offerLast(Map.Entry<K, V> e) {
            return DynamicValueSortedTreeMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public Node peek() {
            return this.peekFirst();
        }

        @Override
        public Node peekFirst() {
            return DynamicValueSortedTreeMap.this.head;
        }

        @Override
        public Node peekLast() {
            return DynamicValueSortedTreeMap.this.tail;
        }

        @Override
        public Node poll() {
            return this.pollFirst();
        }

        @Override
        public Node pollFirst() {
            if (DynamicValueSortedTreeMap.this.head == null) {
                return null;
            }
            Node result = DynamicValueSortedTreeMap.this.head;
            DynamicValueSortedTreeMap.this.head.remove();
            DynamicValueSortedTreeMap.this.nodeMap.remove(result.key);
            return result;
        }

        @Override
        public Node pollLast() {
            if (DynamicValueSortedTreeMap.this.tail == null) {
                return DynamicValueSortedTreeMap.this.tail;
            }
            Node result = DynamicValueSortedTreeMap.this.tail;
            DynamicValueSortedTreeMap.this.tail.remove();
            DynamicValueSortedTreeMap.this.nodeMap.remove(result.key);
            return result;
        }

        @Override
        public Node pop() {
            return this.removeFirst();
        }

        @Override
        public void push(Map.Entry<K, V> e) {
            DynamicValueSortedTreeMap.this.put(e.getKey(), e.getValue());
        }

        @Override
        public Node remove() {
            return this.removeFirst();
        }

        @Override
        public Node remove(int index) {
            Node n = DynamicValueSortedTreeMap.this.root.getByIndex(index);
            n.remove();
            DynamicValueSortedTreeMap.this.nodeMap.remove(n.key);
            return n;
        }

        @Override
        public boolean remove(Object o) {
            try {
                Node n = (Node)o;
                Node rm = DynamicValueSortedTreeMap.this.nodeMap.get(n.key);
                if (rm == n) {
                    n.remove();
                    DynamicValueSortedTreeMap.this.nodeMap.remove(n.key);
                    return true;
                }
                if (DynamicValueSortedTreeMap.eq(n.val, rm.val)) {
                    DynamicValueSortedTreeMap.this.nodeMap.remove(rm.key);
                    rm.remove();
                    return true;
                }
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Node removeFirst() {
            Node ret = this.pollFirst();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            return this.remove(o);
        }

        @Override
        public Node removeLast() {
            Node ret = this.pollLast();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            return this.remove(o);
        }

        @Override
        public Node set(int index, Map.Entry<K, V> element) {
            Node result = this.remove(index);
            this.add(element);
            return result;
        }

        @Override
        public int size() {
            return DynamicValueSortedTreeMap.this.nodeMap.size();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 17);
        }

        @Override
        public List<Map.Entry<K, V>> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    protected class ValueListIterator
    implements ListIterator<V> {
        private EntryListIterator it;

        private ValueListIterator(Node start) {
            this.it = new EntryListIterator(start);
        }

        @Override
        public void add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public V next() {
            return this.it.next().val;
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public V previous() {
            return this.it.previous().val;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(V e) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum SearchMode {
        ANY,
        FIRST,
        LAST;

    }

    protected class Node
    implements Map.Entry<K, V> {
        private final K key;
        private V val;
        private Node parent;
        private Node lChild;
        private Node rChild;
        private int sizeLeft;
        private Node next;
        private Node prev;

        public String toString() {
            return this.key + "=" + this.val;
        }

        private Node(K key, V val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public boolean equals(Object obj) {
            try {
                Map.Entry that = (Map.Entry)obj;
                return DynamicValueSortedTreeMap.eq(this.key, that.getKey()) && DynamicValueSortedTreeMap.eq(this.val, that.getValue());
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int computeIndex() {
            Node cur = this;
            int index = this.sizeLeft;
            while (cur.parent != null) {
                if (cur.parent.rChild == cur) {
                    ++index;
                    index += cur.parent.sizeLeft;
                }
                cur = cur.parent;
            }
            return index;
        }

        private Node getByIndex(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            Node cur = this;
            int i = index;
            while (true) {
                if (i < 0) {
                    throw new AssertionError((Object)"INTERNAL: sizeLeft values inconsistent");
                }
                if (cur == null) {
                    throw new IndexOutOfBoundsException(Integer.toString(index));
                }
                if (i == cur.sizeLeft) {
                    return cur;
                }
                if (i > cur.sizeLeft) {
                    i -= cur.sizeLeft;
                    --i;
                    cur = cur.rChild;
                    continue;
                }
                cur = cur.lChild;
            }
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        void insert(Node item) {
            Node cur = this;
            while (true) {
                int c;
                if ((c = DynamicValueSortedTreeMap.this.comparator.compare(item.val, cur.val)) < 0) {
                    ++cur.sizeLeft;
                    if (cur.lChild == null) {
                        cur.lChild = item;
                        item.parent = cur;
                        cur.insertBefore(item);
                        break;
                    }
                    cur = cur.lChild;
                    continue;
                }
                if (cur.rChild == null) {
                    cur.rChild = item;
                    item.parent = cur;
                    cur.insertAfter(item);
                    break;
                }
                cur = cur.rChild;
            }
        }

        private void insertAfter(Node item) {
            item.prev = this;
            item.next = this.next;
            if (this.next == null) {
                DynamicValueSortedTreeMap.this.tail = item;
            } else {
                this.next.prev = item;
            }
            this.next = item;
        }

        private void insertBefore(Node item) {
            item.prev = this.prev;
            item.next = this;
            if (this.prev == null) {
                DynamicValueSortedTreeMap.this.head = item;
            } else {
                this.prev.next = item;
            }
            this.prev = item;
        }

        private void remove() {
            Node cur = this;
            while (cur.parent != null) {
                if (cur.parent.lChild == cur) {
                    --cur.parent.sizeLeft;
                }
                cur = cur.parent;
            }
            if (this.parent == null) {
                if (this.lChild != null) {
                    DynamicValueSortedTreeMap.this.root = this.lChild;
                    this.lChild.parent = null;
                } else if (this.rChild != null) {
                    DynamicValueSortedTreeMap.this.root = this.rChild;
                    this.rChild.parent = null;
                } else {
                    DynamicValueSortedTreeMap.this.root = null;
                }
            } else if (this.parent.lChild == this) {
                if (this.lChild != null) {
                    this.parent.lChild = this.lChild;
                    this.lChild.parent = this.parent;
                } else if (this.rChild != null) {
                    this.parent.lChild = this.rChild;
                    this.rChild.parent = this.parent;
                } else {
                    this.parent.lChild = null;
                }
            } else if (this.lChild != null) {
                this.parent.rChild = this.lChild;
                this.lChild.parent = this.parent;
            } else if (this.rChild != null) {
                this.parent.rChild = this.rChild;
                this.rChild.parent = this.parent;
            } else {
                this.parent.rChild = null;
            }
            if (this.lChild != null && this.rChild != null) {
                this.prev.rChild = this.rChild;
                this.rChild.parent = this.prev;
            }
            this.lChild = null;
            this.rChild = null;
            this.sizeLeft = 0;
            if (this.prev == null) {
                DynamicValueSortedTreeMap.this.head = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.next == null) {
                DynamicValueSortedTreeMap.this.tail = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }

        private Node searchValue(V val, SearchMode mode) {
            Node cur = this;
            Node eq = null;
            while (true) {
                int c;
                if ((c = DynamicValueSortedTreeMap.this.comparator.compare(val, cur.val)) == 0) {
                    eq = cur;
                }
                if (c < 0 || c == 0 && mode == SearchMode.FIRST) {
                    if (cur.lChild == null) {
                        return eq;
                    }
                    cur = cur.lChild;
                    continue;
                }
                if (c <= 0 && (c != 0 || mode != SearchMode.LAST)) break;
                if (cur.rChild == null) {
                    return eq;
                }
                cur = cur.rChild;
            }
            return eq;
        }

        @Override
        public V setValue(V value) {
            Object oldVal = this.val;
            this.val = value;
            DynamicValueSortedTreeMap.this.updateNode(this);
            return oldVal;
        }
    }

    protected class KeyListIterator
    implements ListIterator<K> {
        private EntryListIterator it;

        private KeyListIterator(Node start) {
            this.it = new EntryListIterator(start);
        }

        @Override
        public void add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public K next() {
            return this.it.next().key;
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public K previous() {
            return this.it.previous().key;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(K e) {
            throw new UnsupportedOperationException();
        }
    }

    protected class EntryListIterator
    implements ListIterator<Map.Entry<K, V>> {
        private boolean atEnd = false;
        private Node next;

        private EntryListIterator(Node start) {
            this.next = start;
            this.atEnd = start == null;
        }

        @Override
        public void add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return !this.atEnd;
        }

        @Override
        public boolean hasPrevious() {
            if (this.atEnd) {
                return true;
            }
            return this.next.prev != null;
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node cur = this.next;
            this.next = this.next.next;
            this.atEnd = this.next == null;
            return cur;
        }

        @Override
        public int nextIndex() {
            return this.next.computeIndex();
        }

        @Override
        public Node previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.atEnd) {
                this.next = DynamicValueSortedTreeMap.this.tail;
                this.atEnd = DynamicValueSortedTreeMap.this.tail == null;
            } else {
                this.next = this.next.prev;
            }
            return this.next;
        }

        @Override
        public int previousIndex() {
            if (this.atEnd) {
                return DynamicValueSortedTreeMap.this.size() - 1;
            }
            return this.next.computeIndex() - 1;
        }

        @Override
        public void remove() {
            DynamicValueSortedTreeMap.this.nodeMap.remove(this.next.key);
            this.next.remove();
        }

        @Override
        public void set(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }
    }
}

