(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/httpd/server#httpd::proto
    (let ((__tmp7304 (hash-copy std/actor/xdr#+xdr-default-type-registry+)))
      (declare (not safe))
      (##structure
       std/actor/proto#!protocol::t
       'std/net/httpd/server#httpd
       '()
       __tmp7304)))
  (define std/net/httpd/server#httpd.register::t
    (make-struct-type
     'std/net/httpd/server#httpd.register::t
     '#f
     '3
     'httpd.register
     '((final: . #t))
     '#f
     '(host path handler)))
  (define std/net/httpd/server#httpd.register?
    (make-struct-predicate std/net/httpd/server#httpd.register::t))
  (define std/net/httpd/server#make-httpd.register
    (lambda _$args1979_
      (apply make-struct-instance
             std/net/httpd/server#httpd.register::t
             _$args1979_)))
  (define std/net/httpd/server#httpd.register-host
    (make-struct-field-accessor std/net/httpd/server#httpd.register::t '0))
  (define std/net/httpd/server#httpd.register-path
    (make-struct-field-accessor std/net/httpd/server#httpd.register::t '1))
  (define std/net/httpd/server#httpd.register-handler
    (make-struct-field-accessor std/net/httpd/server#httpd.register::t '2))
  (define std/net/httpd/server#httpd.register-host-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.register::t '0))
  (define std/net/httpd/server#httpd.register-path-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.register::t '1))
  (define std/net/httpd/server#httpd.register-handler-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.register::t '2))
  (define std/net/httpd/server#xdr-httpd.register-read
    (lambda (_buffer1977_)
      (std/actor/xdr#xdr-read-struct
       std/net/httpd/server#httpd.register::t
       _buffer1977_)))
  (define std/net/httpd/server#xdr-httpd.register-write
    (lambda (_obj1974_ _buffer1975_)
      (std/actor/xdr#xdr-write-struct _obj1974_ _buffer1975_)))
  (define std/net/httpd/server#httpd.register::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/net/httpd/server#xdr-httpd.register-read
       std/net/httpd/server#xdr-httpd.register-write)))
  (table-set!
   (##direct-structure-ref
    std/net/httpd/server#httpd::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/net/httpd/server#httpd.register::t
   std/net/httpd/server#httpd.register::xdr)
  (define std/net/httpd/server#httpd.join::t
    (make-struct-type
     'std/net/httpd/server#httpd.join::t
     '#f
     '1
     'httpd.join
     '((final: . #t))
     '#f
     '(thread)))
  (define std/net/httpd/server#httpd.join?
    (make-struct-predicate std/net/httpd/server#httpd.join::t))
  (define std/net/httpd/server#make-httpd.join
    (lambda _$args1971_
      (apply make-struct-instance
             std/net/httpd/server#httpd.join::t
             _$args1971_)))
  (define std/net/httpd/server#httpd.join-thread
    (make-struct-field-accessor std/net/httpd/server#httpd.join::t '0))
  (define std/net/httpd/server#httpd.join-thread-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.join::t '0))
  (define std/net/httpd/server#xdr-httpd.join-read
    (lambda (_buffer1969_)
      (std/actor/xdr#xdr-read-struct
       std/net/httpd/server#httpd.join::t
       _buffer1969_)))
  (define std/net/httpd/server#xdr-httpd.join-write
    (lambda (_obj1966_ _buffer1967_)
      (std/actor/xdr#xdr-write-struct _obj1966_ _buffer1967_)))
  (define std/net/httpd/server#httpd.join::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/net/httpd/server#xdr-httpd.join-read
       std/net/httpd/server#xdr-httpd.join-write)))
  (table-set!
   (##direct-structure-ref
    std/net/httpd/server#httpd::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/net/httpd/server#httpd.join::t
   std/net/httpd/server#httpd.join::xdr)
  (define std/net/httpd/server#httpd.shutdown::t
    (make-struct-type
     'std/net/httpd/server#httpd.shutdown::t
     '#f
     '0
     'httpd.shutdown
     '((final: . #t))
     '#f
     '()))
  (define std/net/httpd/server#httpd.shutdown?
    (make-struct-predicate std/net/httpd/server#httpd.shutdown::t))
  (define std/net/httpd/server#make-httpd.shutdown
    (lambda _$args1963_
      (apply make-struct-instance
             std/net/httpd/server#httpd.shutdown::t
             _$args1963_)))
  (define std/net/httpd/server#xdr-httpd.shutdown-read
    (lambda (_buffer1961_)
      (std/actor/xdr#xdr-read-struct
       std/net/httpd/server#httpd.shutdown::t
       _buffer1961_)))
  (define std/net/httpd/server#xdr-httpd.shutdown-write
    (lambda (_obj1956_ _buffer1958_)
      (std/actor/xdr#xdr-write-struct _obj1956_ _buffer1958_)))
  (define std/net/httpd/server#httpd.shutdown::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/net/httpd/server#xdr-httpd.shutdown-read
       std/net/httpd/server#xdr-httpd.shutdown-write)))
  (table-set!
   (##direct-structure-ref
    std/net/httpd/server#httpd::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/net/httpd/server#httpd.shutdown::t
   std/net/httpd/server#httpd.shutdown::xdr)
  (define std/net/httpd/server#current-http-server (make-parameter '#f))
  (define std/net/httpd/server#start-http-server!__%
    (lambda (_g7305_
             _mux19141919_
             _backlog19151921_
             _sockopts19161923_
             .
             _addresses1925_)
      (let* ((_mux1927_
              (if (eq? _mux19141919_ absent-value)
                  (let ((__obj7303
                         (make-object
                          std/net/httpd/mux#default-http-mux::t
                          '2)))
                    (std/net/httpd/mux#default-http-mux:::init!__0 __obj7303)
                    __obj7303)
                  _mux19141919_))
             (_backlog1929_
              (if (eq? _backlog19151921_ absent-value) '10 _backlog19151921_))
             (_sockopts1931_
              (if (eq? _sockopts19161923_ absent-value)
                  (cons std/os/_socket#SO_REUSEADDR '())
                  _sockopts19161923_)))
        (std/logger#start-logger!__0)
        (let* ((_sas1933_ (map std/os/socket#socket-address _addresses1925_))
               (_socks1939_
                (map (lambda (_g19341936_)
                       (std/net/socket/api#ssocket-listen__%
                        _g19341936_
                        _backlog1929_
                        _sockopts1931_))
                     _sas1933_)))
          (gerbil/gambit/threads#spawn/group
           'http-server
           std/net/httpd/server#http-server
           _socks1939_
           _sas1933_
           _mux1927_)))))
  (define std/net/httpd/server#start-http-server!__@
    (lambda (_keys19131945_ . _args1947_)
      (apply std/net/httpd/server#start-http-server!__%
             _keys19131945_
             (table-ref _keys19131945_ 'mux: absent-value)
             (table-ref _keys19131945_ 'backlog: absent-value)
             (table-ref _keys19131945_ 'sockopts: absent-value)
             _args1947_)))
  (define std/net/httpd/server#start-http-server!
    (lambda _args19171953_
      (apply keyword-dispatch
             '#(backlog: mux: #f sockopts:)
             std/net/httpd/server#start-http-server!__@
             _args19171953_)))
  (define std/net/httpd/server#stop-http-server!
    (lambda (_httpd1906_)
      (let ((_tgroup1908_ (thread-thread-group _httpd1906_)))
        (with-unwind-protect
         (lambda ()
           (std/actor/message#send-message__0
            _httpd1906_
            (let ((__tmp7306
                   (let ()
                     (declare (not safe))
                     (##structure std/net/httpd/server#httpd.shutdown::t))))
              (declare (not safe))
              (##structure std/actor/proto#!event::t __tmp7306)))
           (thread-join! _httpd1906_))
         (lambda () (std/misc/threads#thread-group-kill! _tgroup1908_))))))
  (define std/net/httpd/server#http-register-handler__%
    (lambda (_httpd1882_ _path1883_ _handler1884_ _host1885_)
      (if (string? _path1883_)
          (if (procedure? _handler1884_)
              (let ((_token1887_
                     (let ()
                       (declare (not safe))
                       (##structure std/actor/proto#!token::t)))
                    (_dest1889_ _httpd1882_))
                (std/actor/message#send-message__%
                 _dest1889_
                 (let ((__tmp7307
                        (let ()
                          (declare (not safe))
                          (##structure
                           std/net/httpd/server#httpd.register::t
                           _host1885_
                           _path1883_
                           _handler1884_))))
                   (declare (not safe))
                   (##structure
                    std/actor/proto#!call::t
                    __tmp7307
                    _token1887_))
                 '#f
                 '#t)
                (std/actor/proto#!!call-recv _token1887_ _dest1889_))
              (error '"Bad handler; expected procedure" _handler1884_))
          (error '"Bad path; expected string" _path1883_))))
  (define std/net/httpd/server#http-register-handler__0
    (lambda (_httpd1895_ _path1896_ _handler1897_)
      (let ((_host1899_ '#f))
        (std/net/httpd/server#http-register-handler__%
         _httpd1895_
         _path1896_
         _handler1897_
         _host1899_))))
  (define std/net/httpd/server#http-register-handler
    (lambda _g7309_
      (let ((_g7308_ (let () (declare (not safe)) (##length _g7309_))))
        (cond ((let () (declare (not safe)) (##fx= _g7308_ 3))
               (apply std/net/httpd/server#http-register-handler__0 _g7309_))
              ((let () (declare (not safe)) (##fx= _g7308_ 4))
               (apply std/net/httpd/server#http-register-handler__% _g7309_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/server#http-register-handler
                _g7309_))))))
  (define std/net/httpd/server#http-server
    (lambda (_socks1632_ _sas1633_ _mux1634_)
      (letrec* ((_$klass1636_ (object-type _mux1634_))
                (_get-handler1638_
                 (let ((_$e1878_ (find-method _$klass1636_ 'get-handler)))
                   (if _$e1878_
                       _$e1878_
                       (error '"Missing method" _$klass1636_ 'get-handler))))
                (_put-handler!1639_
                 (let ((_$e1875_ (find-method _$klass1636_ 'put-handler!)))
                   (if _$e1875_
                       _$e1875_
                       (error '"Missing method" _$klass1636_ 'put-handler!))))
                (_acceptors1640_
                 (call-with-parameters
                  (lambda ()
                    (map (lambda (_sock1865_ _sa1866_)
                           (gerbil/gambit/threads#spawn/name
                            'http-server-accept
                            std/net/httpd/server#http-server-accept
                            (lambda (_g18671870_ _g18681872_)
                              (_get-handler1638_
                               _mux1634_
                               _g18671870_
                               _g18681872_))
                            _sock1865_
                            (std/os/_socket#sockaddr_family _sa1866_)))
                         _socks1632_
                         _sas1633_))
                  std/net/httpd/server#current-http-server
                  (current-thread)))
                (_shutdown!1641_
                 (lambda ()
                   (for-each std/net/socket/api#ssocket-close _socks1632_)))
                (_monitor1642_
                 (lambda (_thread1855_)
                   (letrec ((_join1857_
                             (lambda (_server1859_ _thread1860_)
                               (with-exception-catcher
                                void
                                (lambda () (thread-join! _thread1860_)))
                               (std/actor/message#send-message__0
                                _server1859_
                                (let ((__tmp7310
                                       (let ()
                                         (declare (not safe))
                                         (##structure
                                          std/net/httpd/server#httpd.join::t
                                          _thread1860_))))
                                  (declare (not safe))
                                  (##structure
                                   std/actor/proto#!event::t
                                   __tmp7310))))))
                     (gerbil/gambit/threads#spawn/name
                      'http-server-monitor
                      _join1857_
                      (current-thread)
                      _thread1855_))))
                (_loop1643_
                 (lambda ()
                   (let _loop16551657_ ()
                     (let ((_next1661_ (thread-mailbox-next)))
                       ((lambda (_$message1664_)
                          (let* ((_$message16661676_ _$message1664_)
                                 (_else16681684_ (lambda () (_loop16551657_)))
                                 (_K16701832_
                                  (lambda (_$options1687_
                                           _$dest1689_
                                           _$source1691_
                                           _$value1693_)
                                    (let* ((_$value17121732_ _$value1693_)
                                           (_else17171740_
                                            (lambda () (_loop16551657_))))
                                      (let ((_K17251806_
                                             (lambda (_k1794_
                                                      _handler1795_
                                                      _path1796_
                                                      _host1797_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g17981800_)
                                                  (if '#t
                                                      (let ((_e1803_ _g17981800_))
                                                        (std/actor/message#send-message__%
                                                         _$source1691_
                                                         (let ()
                                                           (declare (not safe))
                                                           (##structure
                                                            std/actor/proto#!error::t
                                                            _e1803_
                                                            _k1794_))
                                                         '#f
                                                         '#f))
                                                      (raise _g17981800_)))
                                                (lambda ()
                                                  (_put-handler!1639_
                                                   _mux1634_
                                                   _host1797_
                                                   _path1796_
                                                   _handler1795_)
                                                  (std/actor/message#send-message__%
                                                   _$source1691_
                                                   (let ()
                                                     (declare (not safe))
                                                     (##structure
                                                      std/actor/proto#!value::t
                                                      '#!void
                                                      _k1794_))
                                                   '#f
                                                   '#f)))
                                               (_loop1643_)))
                                            (_K17231785_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               '#!void))
                                            (_K17201769_
                                             (lambda (_thread1755_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g17561758_)
                                                  (if ((lambda (_$obj1761_)
                                                         (uncaught-exception?
                                                          _$obj1761_))
                                                       _g17561758_)
                                                      (let ((_e1764_ _g17561758_))
                                                        (std/logger#log-error
                                                         '"acceptor error"
                                                         (uncaught-exception-reason
                                                          _e1764_)))
                                                      (if '#t
                                                          (let ((_e1766_ _g17561758_))
                                                            (std/logger#log-error
                                                             '"acceptor error"
                                                             _e1766_))
                                                          (raise _g17561758_))))
                                                (lambda ()
                                                  (thread-join! _thread1755_)
                                                  (std/logger#warning
                                                   '"acceptor thread ~a exited unexpectedly"
                                                   (thread-name
                                                    _thread1755_))))
                                               (_loop1643_)))
                                            (_K17191746_
                                             (lambda (_bogus1744_)
                                               (thread-mailbox-extract-and-rewind)
                                               (std/logger#warning
                                                '"unexpected message ~a"
                                                _bogus1744_)
                                               (_loop1643_))))
                                        (let ((_try-match17141791_
                                               (lambda ()
                                                 (if (let ()
                                                       (declare (not safe))
                                                       (##structure-direct-instance-of?
                                                        _$value17121732_
                                                        'std/actor/proto#!event::t))
                                                     (let ((_e17241788_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _$value17121732_
                                                               '1))))
                                                       (if (let ()
                                                             (declare
                                                               (not safe))
                                                             (##structure-direct-instance-of?
                                                              _e17241788_
                                                              'std/net/httpd/server#httpd.shutdown::t))
                                                           (_K17231785_)
                                                           (if (let ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (declare (not safe))
                         (##structure-direct-instance-of?
                          _e17241788_
                          'std/net/httpd/server#httpd.join::t))
                       (let* ((_e17221775_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _e17241788_ '1)))
                              (_thread1778_ _e17221775_))
                         (_K17201769_ _thread1778_))
                       (let ((_bogus1749_ _$value17121732_))
                         (_K17191746_ _bogus1749_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (let ((_bogus1749_
                                                            _$value17121732_))
                                                       (_K17191746_
                                                        _bogus1749_))))))
                                          (if (let ()
                                                (declare (not safe))
                                                (##structure-direct-instance-of?
                                                 _$value17121732_
                                                 'std/actor/proto#!call::t))
                                              (let ((_e17261809_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##vector-ref
                                                        _$value17121732_
                                                        '1))))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##structure-direct-instance-of?
                                                       _e17261809_
                                                       'std/net/httpd/server#httpd.register::t))
                                                    (let* ((_e17281812_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e17261809_
                                                               '1)))
                                                           (_e17291817_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e17261809_
                                                               '2)))
                                                           (_e17301822_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e17261809_
                                                               '3)))
                                                           (_e17271827_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _$value17121732_
                                                               '2))))
                                                      (let ((_host1815_
                                                             _e17281812_)
                                                            (_path1820_
                                                             _e17291817_)
                                                            (_handler1825_
                                                             _e17301822_)
                                                            (_k1830_ _e17271827_))
                                                        (_K17251806_
                                                         _k1830_
                                                         _handler1825_
                                                         _path1820_
                                                         _host1815_)))
                                                    (let ((_bogus1749_
                                                           _$value17121732_))
                                                      (_K17191746_
                                                       _bogus1749_))))
                                              (_try-match17141791_))))))))
                            (if (let ()
                                  (declare (not safe))
                                  (##structure-direct-instance-of?
                                   _$message16661676_
                                   'std/actor/message#message::t))
                                (let* ((_e16711835_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message16661676_
                                           '1)))
                                       (_$value1838_ _e16711835_)
                                       (_e16721840_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message16661676_
                                           '2)))
                                       (_$source1843_ _e16721840_)
                                       (_e16731845_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message16661676_
                                           '3)))
                                       (_$dest1848_ _e16731845_)
                                       (_e16741850_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message16661676_
                                           '4)))
                                       (_$options1853_ _e16741850_))
                                  (_K16701832_
                                   _$options1853_
                                   _$dest1848_
                                   _$source1843_
                                   _$value1838_))
                                (_loop16551657_))))
                        _next1661_))))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g16441647_)
              (if '#t
                  (let ((_e1650_ _g16441647_))
                    (std/logger#log-error '"unhandled exception" _e1650_)
                    (raise _e1650_))
                  (raise _g16441647_)))
            (lambda ()
              (for-each _monitor1642_ _acceptors1640_)
              (call-with-parameters
               (lambda () (_loop1643_))
               std/net/httpd/server#current-http-server
               (current-thread)))))
         (lambda () (_shutdown!1641_))))))
  (define std/net/httpd/server#http-server-accept
    (lambda (_get-handler1609_ _sock1610_ _safamily1611_)
      (letrec* ((_cliaddr1613_
                 (std/os/socket#make-socket-address _safamily1611_))
                (_loop1614_
                 (lambda ()
                   (let ((_clisock1630_
                          (std/net/socket/api#ssocket-accept__1
                           _sock1610_
                           _cliaddr1613_)))
                     (gerbil/gambit/threads#spawn/name
                      'http-request-handler
                      std/net/httpd/handler#http-request-handler
                      _get-handler1609_
                      _clisock1630_
                      (std/os/socket#socket-address->address _cliaddr1613_))
                     (_loop1614_)))))
        (let _again1616_ ()
          (with-exception-catcher
           (lambda (_g16181620_)
             (if ((lambda (_$obj1623_) (os-exception? _$obj1623_)) _g16181620_)
                 (let ((_e1626_ _g16181620_))
                   (std/logger#log-error '"error accepting connection" _e1626_)
                   (_again1616_))
                 (raise _g16181620_)))
           (lambda () (_loop1614_))))))))
