/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBArray;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.AdvancedOps;
import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.NameUtility;
import com.ca.commons.naming.RDN;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;

public class DXOps
extends AdvancedOps {
    private static final Logger log = Logger.getLogger(DXOps.class.getName());

    public DXOps(DirContext ctx) throws NamingException {
        super(ctx);
    }

    public DXOps(ConnectionData cData) throws NamingException {
        super(cData);
    }

    public Name preParse(Name name) {
        return name;
    }

    public Name postParse(Name name) {
        return this.postParse(name.toString());
    }

    public Name postParse(String name) {
        if (name.charAt(name.length() - 1) == '\\') {
            name = NameUtility.checkEndSpaces(name);
        }
        try {
            CompositeName cn = new CompositeName(name);
            if (cn.size() == 0) {
                return new DN();
            }
            return new DN(cn.get(cn.size() - 1));
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "unexpected error: bad name back from jndi ftn in CBOps.postParse(" + name + ")?", e);
            e.printStackTrace();
            return new DN(name);
        }
    }

    public String postParseString(String name) {
        if (name.length() == 0) {
            return name;
        }
        if (name.charAt(name.length() - 1) == '\\') {
            name = NameUtility.checkEndSpaces(name);
        }
        if (name.startsWith("ldap://")) {
            try {
                name = URLDecoder.decode(name, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                log.severe("unexpected error: couldn't URL decode in CBOps.postParseString(" + name + ")?\n" + e.toString());
                e.printStackTrace();
                return name;
            }
        }
        try {
            CompositeName cn = new CompositeName(name);
            if (cn.size() == 0) {
                return "";
            }
            name = cn.get(cn.size() - 1);
            return name;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "unexpected error: bad name back from jndi ftn in CBOps.postParseString(" + name + ")?", e);
            e.printStackTrace();
            return name;
        }
    }

    public NamingEnumeration postParseNameClassPairs(NamingEnumeration names, Name base) {
        log.finer("parsing with base :" + base.toString());
        DXNamingEnumeration dxe = new DXNamingEnumeration();
        String baseString = null;
        if (base != null && !base.isEmpty()) {
            baseString = base.toString();
        }
        try {
            while (names.hasMore()) {
                NameClassPair ncp = (NameClassPair)names.next();
                String rawName = this.postParseString(ncp.getName()).toString();
                if (ncp.isRelative() && baseString != null) {
                    rawName = rawName.length() != 0 ? rawName + "," + baseString : baseString;
                }
                log.finer("ended up with: '" + rawName + "'");
                ncp.setName(rawName);
                dxe.add(ncp);
            }
        }
        catch (NamingException ex) {
            CBUtility.error(CBIntText.get("Search partially failed! - only {0} entries returned", new Integer[]{new Integer(dxe.size())}), ex);
        }
        return dxe;
    }

    protected NamingEnumeration rawSearchBaseEntry(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.postParseNameClassPairs(super.rawSearchBaseEntry(searchbase, filter, limit, timeout, returnAttributes), searchbase);
    }

    protected NamingEnumeration rawSearchOneLevel(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.postParseNameClassPairs(super.rawSearchOneLevel(searchbase, filter, limit, timeout, returnAttributes), searchbase);
    }

    protected NamingEnumeration rawSearchSubTree(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.postParseNameClassPairs(super.rawSearchSubTree(searchbase, filter, limit, timeout, returnAttributes), searchbase);
    }

    public void modifyEntry(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        if (oldEntry != null) {
            oldEntry.removeEmptyAttributes();
        }
        if (newEntry != null) {
            newEntry.removeEmptyAttributes();
        }
        if (oldEntry != null || newEntry != null) {
            if (oldEntry == null || newEntry != null && newEntry.getStatus() == 1) {
                this.addEntryToDirectory(newEntry);
            } else if (newEntry == null) {
                this.deleteTree(oldEntry.getDN());
            } else {
                if (oldEntry.getDN() == null || newEntry.getDN() == null) {
                    throw new NamingException("Internal Error: Entry with null DN passed to JNDIBroker unthreadedModify.  Modify Request Cancelled.");
                }
                this.handleAnyNameChange(oldEntry, newEntry);
                this.updateEntry(oldEntry, newEntry);
            }
        }
    }

    private void addEntryToDirectory(DXEntry newEntry) throws NamingException {
        this.addEntry(newEntry);
        newEntry.setStatus(2);
    }

    public void addEntry(DXEntry newEntry) throws NamingException {
        if (newEntry == null) {
            throw new NamingException("Internal Error: null Entry passed to DXOps addEntry");
        }
        if (newEntry.getDN() == null) {
            throw new NamingException("Internal Error: Entry with null DN passed to DXOps addEntry");
        }
        this.addEntry(newEntry.getDN(), (Attributes)newEntry);
    }

    private void handleAnyNameChange(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        DN newDN;
        RDN oldRDN = oldEntry.getRDN();
        RDN newRDN = newEntry.getRDN();
        DN oldDN = oldEntry.getDN();
        if (oldDN.equals(newDN = newEntry.getDN())) {
            return;
        }
        if (oldEntry.size() == 0 && newEntry.size() == 0) {
            this.moveTree(oldDN, newDN);
        } else if (!oldRDN.isMultiValued() && !newRDN.isMultiValued()) {
            this.renameSingleValuedRDNS(oldEntry, newEntry);
        } else {
            this.renameComplexMultiValuedRDNs(oldEntry, newEntry);
        }
    }

    private void renameComplexMultiValuedRDNs(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        String value;
        String type;
        String RDN2;
        int i;
        Object[] oldRDNs = oldEntry.getRDN().getElements();
        Object[] newRDNs = newEntry.getRDN().getElements();
        DN oldDN = oldEntry.getDN();
        DN newDN = newEntry.getDN();
        Object[] temp = CBArray.difference(oldRDNs, newRDNs);
        String[] lostRDNs = new String[temp.length];
        for (int i2 = 0; i2 < temp.length; ++i2) {
            lostRDNs[i2] = temp[i2].toString();
        }
        boolean NOT_SET = false;
        boolean IN_NEW_ENTRY = true;
        int NOT_IN_NEW_ENTRY = -1;
        int deleteRDNState = 0;
        for (i = 0; i < lostRDNs.length; ++i) {
            RDN2 = lostRDNs[i];
            type = RDN2.substring(0, RDN2.indexOf(61));
            value = RDN2.substring(RDN2.indexOf(61) + 1);
            if (newEntry.get(type).contains(value)) {
                if (deleteRDNState == 0) {
                    deleteRDNState = 1;
                }
                if (deleteRDNState == 1) continue;
                this.setWierdoRDNError(oldDN, newDN);
                continue;
            }
            if (deleteRDNState == 0) {
                deleteRDNState = -1;
            }
            if (deleteRDNState == -1) continue;
            this.setWierdoRDNError(oldDN, newDN);
        }
        if (deleteRDNState == 0 || deleteRDNState == 1) {
            this.renameEntry(oldDN, newDN, false);
        } else {
            this.renameEntry(oldDN, newDN, true);
            for (i = 0; i < lostRDNs.length; ++i) {
                RDN2 = lostRDNs[i];
                type = RDN2.substring(0, RDN2.indexOf(61));
                value = RDN2.substring(RDN2.indexOf(61) + 1);
                oldEntry.get(type).remove(value);
            }
        }
    }

    private void renameSingleValuedRDNS(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        RDN oldRDN = oldEntry.getRDN();
        String type = oldRDN.getAtt();
        String value = oldRDN.getRawVal();
        Attribute oldNamingAttInNewEntry = newEntry.get(type);
        if (!oldNamingAttInNewEntry.contains(value)) {
            this.renameEntry(oldEntry.getDN(), newEntry.getDN(), true);
            oldEntry.get(type).remove(value);
        } else {
            this.renameEntry(oldEntry.getDN(), newEntry.getDN(), false);
        }
    }

    private void setWierdoRDNError(DN oldDN, DN newDN) throws NamingException {
        throw new NamingException(CBIntText.get("The rename operation is too complex to proceed.  Try to break it up into smaller stages.") + "\n    " + oldDN.toString() + "\n => " + newDN.toString());
    }

    public void updateEntry(DXEntry oldSet, DXEntry newSet) throws NamingException {
        if (DXAttributes.attributesEqual(oldSet, newSet)) {
            return;
        }
        DN nodeDN = newSet.getDN();
        RDN newRDN = nodeDN.getLowestRDN();
        DXAttributes adds = null;
        DXAttributes reps = null;
        DXAttributes dels = null;
        reps = DXAttributes.getReplacementSet(newRDN, oldSet, newSet);
        dels = DXAttributes.getDeletionSet(newRDN, oldSet, newSet);
        adds = DXAttributes.getAdditionSet(newRDN, oldSet, newSet);
        log.fine("updateNode: " + nodeDN);
        ModificationItem[] mods = new ModificationItem[dels.size() + reps.size() + adds.size()];
        int modIndex = 0;
        modIndex = this.loadMods(mods, dels.getAll(), 3, modIndex);
        modIndex = this.loadMods(mods, adds.getAll(), 1, modIndex);
        modIndex = this.loadMods(mods, reps.getAll(), 2, modIndex);
        this.modifyAttributes(nodeDN, mods);
    }

    private int loadMods(ModificationItem[] mods, NamingEnumeration atts, int TYPE, int index) throws NamingException {
        while (atts.hasMore()) {
            Attribute temp = (Attribute)atts.next();
            mods[index++] = new ModificationItem(TYPE, temp);
        }
        return index;
    }

    private void printDebug(DXEntry oldSet, DXEntry newSet, DXAttributes adds, DXAttributes reps, DXAttributes dels) {
        System.out.println("\n*** entries are ***\n\nold:\n" + oldSet.toString() + "\n\nnew:\n" + newSet.toString());
        System.out.println("\n-----------------\nreps:\n" + reps.toString());
        System.out.println("\n-----------------\ndels:\n" + dels.toString());
        System.out.println("\n-----------------\nadds:\n" + adds.toString());
    }
}

