/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

final class RelationSortUtils {
    private RelationSortUtils() {
    }

    static WayConnectionType.Direction roundaboutType(RelationMember member) {
        if (member == null || !member.isWay()) {
            return WayConnectionType.Direction.NONE;
        }
        return RelationSortUtils.roundaboutType(member.getWay());
    }

    static WayConnectionType.Direction roundaboutType(Way w) {
        int nodesCount;
        if (w != null && w.hasTag("junction", "roundabout") && (nodesCount = w.getNodesCount()) > 2 && nodesCount < 200) {
            Node n1 = w.getNode(0);
            Node n2 = w.getNode(1);
            Node n3 = w.getNode(2);
            if (n1 != null && n2 != null && n3 != null && w.isClosed()) {
                EastNorth en1 = n1.getEastNorth();
                EastNorth en2 = n2.getEastNorth();
                EastNorth en3 = n3.getEastNorth();
                if (en1 != null && en2 != null && en3 != null) {
                    en1 = en2.subtract(en1);
                    en2 = en3.subtract(en2);
                    return en1.north() * en2.east() - en2.north() * en1.east() > 0.0 ? WayConnectionType.Direction.ROUNDABOUT_LEFT : WayConnectionType.Direction.ROUNDABOUT_RIGHT;
                }
            }
        }
        return WayConnectionType.Direction.NONE;
    }

    static boolean isBackward(RelationMember member) {
        return "backward".equals(member.getRole());
    }

    static boolean isForward(RelationMember member) {
        return "forward".equals(member.getRole());
    }

    static boolean isOneway(RelationMember member) {
        return RelationSortUtils.isForward(member) || RelationSortUtils.isBackward(member);
    }
}

