/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class TmgFrameDecoder
extends BaseFrameDecoder {
    private boolean isLetter(byte c) {
        return c >= 97 && c <= 122;
    }

    private int findHeader(ByteBuf buffer) {
        int guessedIndex = buffer.indexOf(buffer.readerIndex(), buffer.writerIndex(), (byte)36);
        while (guessedIndex != -1 && buffer.writerIndex() - guessedIndex >= 5) {
            if (buffer.getByte(guessedIndex + 4) == 44 && this.isLetter(buffer.getByte(guessedIndex + 1)) && this.isLetter(buffer.getByte(guessedIndex + 2)) && this.isLetter(buffer.getByte(guessedIndex + 3))) {
                return guessedIndex;
            }
            guessedIndex = buffer.indexOf(guessedIndex + 1, buffer.writerIndex(), (byte)36);
        }
        return -1;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        int beginIndex = this.findHeader(buf);
        if (beginIndex >= 0) {
            buf.readerIndex(beginIndex);
            int endIndex = buf.indexOf(beginIndex, buf.writerIndex(), (byte)10);
            if (endIndex >= 0) {
                ByteBuf frame = buf.readRetainedSlice(endIndex - beginIndex);
                buf.readByte();
                return frame;
            }
        }
        return null;
    }
}

