/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class AppelloProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("FOLLOWIT,").number("(d+),").groupBegin().number("(dd)(dd)(dd)").number("(dd)(dd)(dd).?d*,").or().text("UTCTIME,").groupEnd().number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(d+),").number("(-?d+),").expression("([FL]),").any().compile();

    public AppelloProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.hasNext(6)) {
            position.setTime(parser.nextDateTime());
        } else {
            this.getLastLocation(position, null);
        }
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt(0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setValid(parser.next().equals("F"));
        return position;
    }
}

