/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Keys;

public class HealthCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckService.class);
    private SystemD systemD;
    private boolean enabled;
    private long period;

    public HealthCheckService() {
        if (!Context.getConfig().getBoolean(Keys.WEB_DISABLE_HEALTH_CHECK) && System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            try {
                this.systemD = (SystemD)Native.load((String)"systemd", SystemD.class);
                String watchdogTimer = System.getenv("WATCHDOG_USEC");
                if (watchdogTimer != null && !watchdogTimer.isEmpty()) {
                    this.period = Long.parseLong(watchdogTimer) / 1000L * 4L / 5L;
                }
                if (this.period > 0L) {
                    LOGGER.info("Health check enabled with period {}", (Object)this.period);
                    this.enabled = true;
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.warn("No systemd support", (Throwable)e);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getPeriod() {
        return this.period;
    }

    private String getUrl() {
        String address = Context.getConfig().getString(Keys.WEB_ADDRESS, "localhost");
        int port = Context.getConfig().getInteger(Keys.WEB_PORT);
        return "http://" + address + ":" + port + "/api/server";
    }

    public TimerTask createTask() {
        return new TimerTask(){

            @Override
            public void run() {
                LOGGER.debug("Health check running");
                int status = Context.getClient().target(HealthCheckService.this.getUrl()).request().get().getStatus();
                if (status == 200) {
                    int result = HealthCheckService.this.systemD.sd_notify(0, "WATCHDOG=1");
                    if (result < 0) {
                        LOGGER.warn("Health check notify error {}", (Object)result);
                    }
                } else {
                    LOGGER.warn("Health check failed with status {}", (Object)status);
                }
            }
        };
    }

    static interface SystemD
    extends Library {
        public int sd_notify(int var1, String var2);
    }
}

