/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.StringBuilderWriter;
import org.apache.velocity.util.StringUtils;
import org.slf4j.Logger;

public abstract class Block
extends Directive {
    protected Node block;
    protected Logger log;
    protected int maxDepth;
    protected String key;

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        super.init(runtimeServices, internalContextAdapter, node);
        this.log = this.rsvc.getLog();
        this.block = node.jjtGetChild(node.jjtGetNumChildren() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer) {
        this.preRender(internalContextAdapter);
        try {
            boolean bl = this.block.render(internalContextAdapter, writer);
            return bl;
        }
        catch (IOException iOException) {
            String string = "Failed to render " + this.id(internalContextAdapter) + " to writer at " + StringUtils.formatFileString(this);
            this.log.error(string, (Throwable)iOException);
            throw new RuntimeException(string, iOException);
        }
        catch (StopCommand stopCommand) {
            if (!stopCommand.isFor(this)) {
                throw stopCommand;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.postRender(internalContextAdapter);
        }
    }

    protected String id(InternalContextAdapter internalContextAdapter) {
        StringBuilder stringBuilder = new StringBuilder(100).append("block $").append(this.key);
        if (!internalContextAdapter.getCurrentTemplateName().equals(this.getTemplateName())) {
            stringBuilder.append(" used in ").append(internalContextAdapter.getCurrentTemplateName());
        }
        return stringBuilder.toString();
    }

    public static class Reference
    implements Renderable {
        private InternalContextAdapter context;
        private Block parent;
        private int depth;

        public Reference(InternalContextAdapter internalContextAdapter, Block block) {
            this.context = internalContextAdapter;
            this.parent = block;
        }

        @Override
        public boolean render(InternalContextAdapter internalContextAdapter, Writer writer) {
            ++this.depth;
            if (this.depth > this.parent.maxDepth) {
                this.parent.log.debug("Max recursion depth reached for {} at {}", (Object)this.parent.id(internalContextAdapter), (Object)StringUtils.formatFileString(this.parent));
                --this.depth;
                return false;
            }
            this.parent.render(internalContextAdapter, writer);
            --this.depth;
            return true;
        }

        public boolean getAsBoolean() {
            return this.depth <= this.parent.maxDepth;
        }

        public String toString() {
            StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
            if (this.render(this.context, stringBuilderWriter)) {
                return ((Object)stringBuilderWriter).toString();
            }
            return null;
        }
    }
}

