/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor;

import java.util.HashMap;
import java.util.List;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.javafragment.ImportsFragment;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitable;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.TypeParameters;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.LineNumberToken;
import org.jd.core.v1.model.token.ReferenceToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.model.token.Token;
import org.jd.core.v1.util.DefaultList;

public class TypeVisitor
extends AbstractJavaSyntaxVisitor {
    public static final KeywordToken BOOLEAN = new KeywordToken("boolean");
    public static final KeywordToken BYTE = new KeywordToken("byte");
    public static final KeywordToken CHAR = new KeywordToken("char");
    public static final KeywordToken DOUBLE = new KeywordToken("double");
    public static final KeywordToken EXPORTS = new KeywordToken("exports");
    public static final KeywordToken EXTENDS = new KeywordToken("extends");
    public static final KeywordToken FLOAT = new KeywordToken("float");
    public static final KeywordToken INT = new KeywordToken("int");
    public static final KeywordToken LONG = new KeywordToken("long");
    public static final KeywordToken MODULE = new KeywordToken("module");
    public static final KeywordToken OPEN = new KeywordToken("open");
    public static final KeywordToken OPENS = new KeywordToken("opens");
    public static final KeywordToken PROVIDES = new KeywordToken("provides");
    public static final KeywordToken REQUIRES = new KeywordToken("requires");
    public static final KeywordToken SHORT = new KeywordToken("short");
    public static final KeywordToken SUPER = new KeywordToken("super");
    public static final KeywordToken TO = new KeywordToken("to");
    public static final KeywordToken TRANSITIVE = new KeywordToken("transitive");
    public static final KeywordToken USES = new KeywordToken("uses");
    public static final KeywordToken VOID = new KeywordToken("void");
    public static final KeywordToken WITH = new KeywordToken("with");
    public static final int UNKNOWN_LINE_NUMBER = 0;
    protected Loader loader;
    protected String internalPackageName;
    protected int majorVersion;
    protected ImportsFragment importsFragment;
    protected Tokens tokens;
    protected int maxLineNumber = 0;
    protected String currentInternalTypeName;
    protected HashMap<String, TextToken> textTokenCache = new HashMap();

    public TypeVisitor(Loader loader, String mainInternalTypeName, int majorVersion, ImportsFragment importsFragment) {
        this.loader = loader;
        this.majorVersion = majorVersion;
        this.importsFragment = importsFragment;
        int index = mainInternalTypeName.lastIndexOf(47);
        this.internalPackageName = index == -1 ? "" : mainInternalTypeName.substring(0, index + 1);
    }

    @Override
    public void visit(TypeArguments arguments) {
        this.buildTokensForList(arguments, TextToken.COMMA_SPACE);
    }

    @Override
    public void visit(DiamondTypeArgument argument) {
    }

    @Override
    public void visit(WildcardExtendsTypeArgument argument) {
        this.tokens.add(TextToken.QUESTIONMARK_SPACE);
        this.tokens.add(EXTENDS);
        this.tokens.add(TextToken.SPACE);
        Type type = argument.getType();
        type.accept(this);
    }

    @Override
    public void visit(PrimitiveType type) {
        switch (type.getJavaPrimitiveFlags()) {
            case 1: {
                this.tokens.add(BOOLEAN);
                break;
            }
            case 2: {
                this.tokens.add(CHAR);
                break;
            }
            case 4: {
                this.tokens.add(FLOAT);
                break;
            }
            case 8: {
                this.tokens.add(DOUBLE);
                break;
            }
            case 16: {
                this.tokens.add(BYTE);
                break;
            }
            case 32: {
                this.tokens.add(SHORT);
                break;
            }
            case 64: {
                this.tokens.add(INT);
                break;
            }
            case 128: {
                this.tokens.add(LONG);
                break;
            }
            case 256: {
                this.tokens.add(VOID);
            }
        }
        this.visitDimension(type.getDimension());
    }

    @Override
    public void visit(ObjectType type) {
        BaseTypeArgument typeArguments;
        this.tokens.add(this.newTypeReferenceToken(type, this.currentInternalTypeName));
        if (this.majorVersion >= 49 && (typeArguments = type.getTypeArguments()) != null) {
            this.visitTypeArgumentList(typeArguments);
        }
        this.visitDimension(type.getDimension());
    }

    @Override
    public void visit(InnerObjectType type) {
        if (this.currentInternalTypeName == null || !this.currentInternalTypeName.equals(type.getInternalName()) && !this.currentInternalTypeName.equals(type.getOuterType().getInternalName())) {
            ObjectType outerType = type.getOuterType();
            outerType.accept(this);
            this.tokens.add(TextToken.DOT);
        }
        this.tokens.add(new ReferenceToken(1, type.getInternalName(), type.getName(), null, this.currentInternalTypeName));
        this.visitTypeArgumentList(type.getTypeArguments());
        this.visitDimension(type.getDimension());
    }

    protected void visitTypeArgumentList(BaseTypeArgument arguments) {
        if (arguments != null) {
            this.tokens.add(TextToken.LEFTANGLEBRACKET);
            arguments.accept(this);
            this.tokens.add(TextToken.RIGHTANGLEBRACKET);
        }
    }

    protected void visitDimension(int dimension) {
        switch (dimension) {
            case 0: {
                break;
            }
            case 1: {
                this.tokens.add(TextToken.DIMENSION_1);
                break;
            }
            case 2: {
                this.tokens.add(TextToken.DIMENSION_2);
                break;
            }
            default: {
                this.tokens.add(this.newTextToken(new String(new char[dimension]).replaceAll("\u0000", "[]")));
            }
        }
    }

    @Override
    public void visit(WildcardSuperTypeArgument argument) {
        this.tokens.add(TextToken.QUESTIONMARK_SPACE);
        this.tokens.add(SUPER);
        this.tokens.add(TextToken.SPACE);
        Type type = argument.getType();
        type.accept(this);
    }

    @Override
    public void visit(Types types) {
        this.buildTokensForList(types, TextToken.COMMA_SPACE);
    }

    @Override
    public void visit(TypeParameter parameter) {
        this.tokens.add(this.newTextToken(parameter.getIdentifier()));
    }

    @Override
    public void visit(TypeParameterWithTypeBounds parameter) {
        this.tokens.add(this.newTextToken(parameter.getIdentifier()));
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(EXTENDS);
        this.tokens.add(TextToken.SPACE);
        BaseType types = parameter.getTypeBounds();
        if (types.isList()) {
            this.buildTokensForList(types.getList(), TextToken.SPACE_AND_SPACE);
        } else {
            BaseType type = (BaseType)types.getFirst();
            type.accept(this);
        }
    }

    @Override
    public void visit(TypeParameters parameters) {
        int size = parameters.size();
        if (size > 0) {
            ((TypeParameter)parameters.get(0)).accept(this);
            for (int i = 1; i < size; ++i) {
                this.tokens.add(TextToken.COMMA_SPACE);
                ((TypeParameter)parameters.get(i)).accept(this);
            }
        }
    }

    @Override
    public void visit(GenericType type) {
        this.tokens.add(this.newTextToken(type.getName()));
        this.visitDimension(type.getDimension());
    }

    @Override
    public void visit(WildcardTypeArgument type) {
        this.tokens.add(TextToken.QUESTIONMARK);
    }

    protected <T extends TypeArgumentVisitable> void buildTokensForList(List<T> list, TextToken separator) {
        int size = list.size();
        if (size > 0) {
            ((TypeArgumentVisitable)list.get(0)).accept(this);
            for (int i = 1; i < size; ++i) {
                this.tokens.add(separator);
                ((TypeArgumentVisitable)list.get(i)).accept(this);
            }
        }
    }

    protected ReferenceToken newTypeReferenceToken(ObjectType ot, String ownerInternalName) {
        String internalName = ot.getInternalName();
        String qualifiedName = ot.getQualifiedName();
        String name = ot.getName();
        if (TypeVisitor.packageContainsType(this.internalPackageName, internalName)) {
            return new ReferenceToken(1, internalName, name, null, ownerInternalName);
        }
        if (TypeVisitor.packageContainsType("java/lang/", internalName)) {
            String internalLocalTypeName = this.internalPackageName + name;
            if (this.loader.canLoad(internalLocalTypeName)) {
                return new ReferenceToken(1, internalName, qualifiedName, null, ownerInternalName);
            }
            return new ReferenceToken(1, internalName, name, null, ownerInternalName);
        }
        return new TypeReferenceToken(this.importsFragment, internalName, qualifiedName, name, ownerInternalName);
    }

    protected static boolean packageContainsType(String internalPackageName, String internalClassName) {
        if (internalClassName.startsWith(internalPackageName)) {
            return internalClassName.indexOf(47, internalPackageName.length()) == -1;
        }
        return false;
    }

    protected TextToken newTextToken(String text) {
        TextToken textToken = this.textTokenCache.get(text);
        if (textToken == null) {
            textToken = new TextToken(text);
            this.textTokenCache.put(text, textToken);
        }
        return textToken;
    }

    public class Tokens
    extends DefaultList<Token> {
        protected int currentLineNumber = 0;

        public int getCurrentLineNumber() {
            return this.currentLineNumber;
        }

        @Override
        public boolean add(Token token) {
            assert (!(token instanceof LineNumberToken));
            return super.add(token);
        }

        public void addLineNumberToken(Expression expression) {
            this.addLineNumberToken(expression.getLineNumber());
        }

        public void addLineNumberToken(int lineNumber) {
            if (lineNumber != 0 && lineNumber >= TypeVisitor.this.maxLineNumber) {
                super.add(new LineNumberToken(lineNumber));
                TypeVisitor.this.maxLineNumber = this.currentLineNumber = lineNumber;
            }
        }
    }

    private static class TypeReferenceToken
    extends ReferenceToken {
        protected ImportsFragment importsFragment;
        protected String qualifiedName;

        public TypeReferenceToken(ImportsFragment importsFragment, String internalTypeName, String qualifiedName, String name, String ownerInternalName) {
            super(1, internalTypeName, name, null, ownerInternalName);
            this.importsFragment = importsFragment;
            this.qualifiedName = qualifiedName;
        }

        @Override
        public String getName() {
            if (this.importsFragment.contains(this.internalTypeName)) {
                return this.name;
            }
            return this.qualifiedName;
        }
    }
}

