/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;

public class SimpleGlobalFilesBuildSettingsDescriptor
implements BuildContentGenerator {
    private final DocumentationRegistry documentationRegistry;
    private final BuildScriptBuilderFactory scriptBuilderFactory;

    public SimpleGlobalFilesBuildSettingsDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, DocumentationRegistry documentationRegistry) {
        this.scriptBuilderFactory = scriptBuilderFactory;
        this.documentationRegistry = documentationRegistry;
    }

    public void generateWithoutComments(InitSettings settings) {
        this.builder(settings).withExternalComments().create(settings.getTarget()).generate();
    }

    @Override
    public void generate(InitSettings settings) {
        this.builder(settings).create(settings.getTarget()).generate();
    }

    private BuildScriptBuilder builder(InitSettings settings) {
        BuildScriptBuilder builder = this.scriptBuilderFactory.script(settings.getDsl(), "settings");
        builder.fileComment("The settings file is used to specify which projects to include in your build.\n\nDetailed information about configuring a multi-project build in Gradle can be found\nin the user manual at " + this.documentationRegistry.getDocumentationFor("multi_project_builds"));
        builder.propertyAssignment(null, "rootProject.name", settings.getProjectName());
        if (!settings.getSubprojects().isEmpty()) {
            builder.methodInvocation(null, "include", settings.getSubprojects().toArray());
        }
        return builder;
    }
}

