/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.servicelocator.ServiceLocator;

public class ExecutorService {
    private static ExecutorService instance = new ExecutorService();
    private List<Executor> registry = new ArrayList<Executor>();
    private Map<String, Executor> executors = new HashMap<String, Executor>();

    private ExecutorService() {
        try {
            Class<Executor>[] classes;
            for (Class<Executor> clazz : classes = ServiceLocator.getInstance().findClasses(Executor.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    private String createKey(String executorName, Database database) {
        String key = executorName.toLowerCase() + "#" + System.identityHashCode(database);
        return key;
    }

    private Executor getExecutorValue(String executorName, Database database) throws UnexpectedLiquibaseException {
        String key = this.createKey(executorName, database);
        if (this.executors.containsKey(key)) {
            return this.executors.get(key);
        }
        TreeSet<Executor> foundExecutors = new TreeSet<Executor>(new Comparator<Executor>(){

            @Override
            public int compare(Executor o1, Executor o2) {
                return -1 * Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        for (Executor executor : this.registry) {
            if (!executor.getName().toLowerCase().equals(executorName.toLowerCase())) continue;
            foundExecutors.add(executor);
        }
        if (foundExecutors.isEmpty()) {
            throw new UnexpectedLiquibaseException("Cannot find Executor for " + executorName);
        }
        try {
            Executor executor;
            Executor exampleService = (Executor)foundExecutors.iterator().next();
            Class<?> aClass = exampleService.getClass();
            try {
                aClass.getConstructor(new Class[0]);
                executor = (Executor)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e2) {
                executor = exampleService;
            }
            return executor;
        }
        catch (Exception e3) {
            throw new UnexpectedLiquibaseException(e3);
        }
    }

    private void register(Executor executor) {
        this.registry.add(0, executor);
    }

    public static ExecutorService getInstance() {
        return instance;
    }

    public Executor getExecutor(String name, Database database) {
        Executor returnExecutor = this.executors.computeIfAbsent(this.createKey(name, database), db2 -> {
            try {
                Executor executor = this.getExecutorValue(name, database);
                executor.setDatabase(database);
                return executor;
            }
            catch (Exception e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
        });
        return returnExecutor;
    }

    public boolean executorExists(String name, Database database) {
        return this.executors.containsKey(this.createKey(name, database));
    }

    public Executor getExecutor(Database database) {
        return this.getExecutor("jdbc", database);
    }

    public void setExecutor(Database database, Executor executor) {
        this.setExecutor("jdbc", database, executor);
    }

    public void setExecutor(String name, Database database, Executor executor) {
        this.executors.put(this.createKey(name, database), executor);
    }

    public void clearExecutor(Database database) {
        this.clearExecutor("jdbc", database);
    }

    public void clearExecutor(String name, Database database) {
        this.executors.remove(this.createKey(name, database));
    }

    public void reset() {
        this.executors.clear();
    }
}

