/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.osHandlers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.osHandlers.GenericAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.LinuxAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.MacAttachOSHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AttachOSHandler {
    private static final Logger LOGGER = Logger.getInstance(AttachOSHandler.class);
    @NotNull
    private final OSType myOSType;
    @NotNull
    protected final EnvironmentAwareHost myHost;

    public AttachOSHandler(@NotNull EnvironmentAwareHost host, @NotNull OSType osType) {
        if (host == null) {
            AttachOSHandler.$$$reportNull$$$0(0);
        }
        if (osType == null) {
            AttachOSHandler.$$$reportNull$$$0(1);
        }
        this.myHost = host;
        this.myOSType = osType;
    }

    @NotNull
    public OSType getOSType() {
        OSType oSType = this.myOSType;
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(2);
        }
        return oSType;
    }

    @NotNull
    public static AttachOSHandler getAttachOsHandler(@NotNull EnvironmentAwareHost host) {
        if (host == null) {
            AttachOSHandler.$$$reportNull$$$0(3);
        }
        try {
            OSType osType = AttachOSHandler.computeOsType(host);
            if (osType == OSType.LINUX) {
                return new LinuxAttachOSHandler(host);
            }
            if (osType == OSType.MACOSX) {
                return new MacAttachOSHandler(host);
            }
            if (osType == OSType.WINDOWS) {
                return new GenericAttachOSHandler(host, OSType.WINDOWS);
            }
        }
        catch (ExecutionException e) {
            LOGGER.warn("Error while obtaining host operating system", (Throwable)e);
        }
        return new GenericAttachOSHandler(host, OSType.UNKNOWN);
    }

    @NotNull
    private static OSType localComputeOsType() {
        if (SystemInfo.isLinux) {
            OSType oSType = OSType.LINUX;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(4);
            }
            return oSType;
        }
        if (SystemInfo.isMac) {
            OSType oSType = OSType.MACOSX;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(5);
            }
            return oSType;
        }
        if (SystemInfo.isWindows) {
            OSType oSType = OSType.WINDOWS;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(6);
            }
            return oSType;
        }
        OSType oSType = OSType.UNKNOWN;
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(7);
        }
        return oSType;
    }

    @NotNull
    private static OSType computeOsType(@NotNull EnvironmentAwareHost host) throws ExecutionException {
        OSType oSType;
        if (host == null) {
            AttachOSHandler.$$$reportNull$$$0(8);
        }
        if (host instanceof LocalAttachHost) {
            return AttachOSHandler.localComputeOsType();
        }
        try {
            OSType osType;
            String osString;
            GeneralCommandLine getOsCommandLine = new GeneralCommandLine(new String[]{"uname", "-s"});
            switch (osString = host.getProcessOutput(getOsCommandLine).getStdout().trim()) {
                case "Linux": {
                    osType = OSType.LINUX;
                    break;
                }
                case "Darwin": {
                    osType = OSType.MACOSX;
                    break;
                }
                default: {
                    osType = OSType.UNKNOWN;
                }
            }
            oSType = osType;
        }
        catch (ExecutionException ex) {
            throw new ExecutionException("Error while calculating the remote operating system", (Throwable)ex);
        }
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(9);
        }
        return oSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/attach/osHandlers/AttachOSHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/attach/osHandlers/AttachOSHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "localComputeOsType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttachOsHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeOsType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OSType {
        LINUX,
        MACOSX,
        WINDOWS,
        UNKNOWN;

    }
}

