/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.ui.UISettings;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.DirectDataBufferInt;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.StatsCounters;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.util.SystemProperties;
import com.intellij.util.loader.NativeLibraryLoader;
import com.intellij.util.ui.EmptyIcon;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.WritableRasterNative;

public final class NST {
    private static final Logger LOG = Logger.getInstance(NST.class);
    private static final String ourRegistryKeyTouchbar = "ide.mac.touchbar.use";
    private static NSTLibrary ourNSTLibrary = null;
    private static final String MIN_OS_VERSION = "10.12.2";

    static boolean isSupportedOS() {
        return SystemInfo.isMac && SystemInfo.isOsVersionAtLeast((String)MIN_OS_VERSION);
    }

    static void initialize() {
        block13: {
            try {
                if (!NST.isSupportedOS()) {
                    LOG.info("OS doesn't support touchbar, skip nst loading");
                    break block13;
                }
                if (GraphicsEnvironment.isHeadless()) {
                    LOG.info("The graphics environment is headless, skip nst loading");
                    break block13;
                }
                if (!SystemProperties.getBooleanProperty((String)ourRegistryKeyTouchbar, (boolean)true)) {
                    LOG.info("system property 'ide.mac.touchbar.use' is set to false, skip nst loading");
                    break block13;
                }
                if (!JnaLoader.isLoaded()) {
                    LOG.info("JNA library is unavailable, skip nst loading");
                    break block13;
                }
                if (!Utils.isTouchBarServerRunning()) {
                    LOG.info("touchbar-server isn't running, skip nst loading");
                    break block13;
                }
                try {
                    NST.loadLibrary();
                }
                catch (Throwable e) {
                    LOG.error("Failed to load nst library for touchbar: ", e);
                }
                if (ourNSTLibrary != null) {
                    try {
                        ID test = ourNSTLibrary.createTouchBar("test", uid -> ID.NIL, null);
                        if (test == null || test.equals((Object)ID.NIL)) {
                            LOG.error("Failed to create native touchbar object, result is null");
                            ourNSTLibrary = null;
                            break block13;
                        }
                        ourNSTLibrary.releaseTouchBar(test);
                        LOG.info("nst library works properly, successfully created and released native touchbar object");
                    }
                    catch (Throwable e) {
                        LOG.error("nst library was loaded, but can't be used: ", e);
                        ourNSTLibrary = null;
                    }
                    break block13;
                }
                LOG.error("nst library wasn't loaded");
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    static NSTLibrary loadLibrary() {
        NativeLibraryLoader.loadPlatformLibrary((String)"nst");
        ourNSTLibrary = (NSTLibrary)Native.load((String)"nst", NSTLibrary.class, Collections.singletonMap("jna.encoding", "UTF8"));
        return ourNSTLibrary;
    }

    public static boolean isAvailable() {
        return ourNSTLibrary != null;
    }

    public static ID createTouchBar(String name, NSTLibrary.ItemCreator creator, String escID) {
        return ourNSTLibrary.createTouchBar(name, creator, escID);
    }

    public static void releaseTouchBar(ID tbObj) {
        ourNSTLibrary.releaseTouchBar(tbObj);
    }

    public static void setTouchBar(TouchBar tb) {
        ourNSTLibrary.setTouchBar(tb == null ? ID.NIL : tb.getNativePeer());
    }

    public static void selectItemsToShow(ID tbObj, String[] ids, int count) {
        ourNSTLibrary.selectItemsToShow(tbObj, ids, count);
    }

    public static void setPrincipal(ID tbObj, String uid) {
        ourNSTLibrary.setPrincipal(tbObj, uid);
    }

    public static ID createButton(String uid, int buttWidth, int buttFlags, String text, Icon icon2, NSTLibrary.Action action2) {
        BufferedImage img = NST._getImg4ByteRGBA(icon2);
        Pointer raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        return ourNSTLibrary.createButton(uid, buttWidth, buttFlags, text, raster4ByteRGBA, w, h, action2);
    }

    public static ID createPopover(String uid, int itemWidth, String text, Icon icon2, ID tbObjExpand, ID tbObjTapAndHold) {
        BufferedImage img = NST._getImg4ByteRGBA(icon2);
        Pointer raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        return ourNSTLibrary.createPopover(uid, itemWidth, text, raster4ByteRGBA, w, h, tbObjExpand, tbObjTapAndHold);
    }

    public static ID createScrubber(String uid, int itemWidth, NSTLibrary.ScrubberDelegate delegate, NSTLibrary.ScrubberCacheUpdater updater2, List<? extends TBItemScrubber.ItemData> items, int visibleItems, @Nullable TouchBarStats stats) {
        Pair<Pointer, Integer> mem = items == null ? null : NST._packItems(items, 0, items.size(), visibleItems, false, true);
        return ourNSTLibrary.createScrubber(uid, itemWidth, delegate, updater2, mem == null ? null : (Pointer)mem.getFirst(), mem == null ? 0 : (Integer)mem.getSecond());
    }

    public static ID createGroupItem(String uid, ID[] items) {
        return ourNSTLibrary.createGroupItem(uid, items == null || items.length == 0 ? null : items, items == null ? 0 : items.length);
    }

    public static void updateButton(ID buttonObj, int updateOptions, int buttWidth, int buttonFlags, String text, @Nullable Pair<Pointer, Dimension> raster, NSTLibrary.Action action2) {
        ourNSTLibrary.updateButton(buttonObj, updateOptions, buttWidth, buttonFlags, text, raster == null ? null : (Pointer)raster.getFirst(), raster == null ? 0 : ((Dimension)raster.getSecond()).width, raster == null ? 0 : ((Dimension)raster.getSecond()).height, action2);
    }

    public static void setArrowImage(ID buttObj, @Nullable Icon arrow) {
        BufferedImage img = NST._getImg4ByteRGBA(arrow);
        Pointer raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.setArrowImage(buttObj, raster4ByteRGBA, w, h);
    }

    private static Pointer _makeIndices(Collection<Integer> indices) {
        if (indices == null || indices.isEmpty()) {
            return null;
        }
        int step = Native.getNativeSize(Integer.class);
        Pointer mem = new Pointer(Native.malloc((long)((long)indices.size() * (long)step)));
        int offset = 0;
        for (Integer i2 : indices) {
            mem.setInt((long)offset, i2.intValue());
            offset += step;
        }
        return mem;
    }

    static void updateScrubberItems(ID scrubObj, List<? extends TBItemScrubber.ItemData> items, int fromIndex, int itemsCount, boolean withImages, boolean withText, @Nullable TouchBarStats stats) {
        long startNs = withImages && stats != null ? System.nanoTime() : 0L;
        Pair<Pointer, Integer> mem = items == null ? null : NST._packItems(items, fromIndex, itemsCount, itemsCount, withImages, withText);
        ourNSTLibrary.updateScrubberItems(scrubObj, mem == null ? null : (Pointer)mem.getFirst(), mem == null ? 0 : (Integer)mem.getSecond(), fromIndex);
        if (withImages && stats != null) {
            stats.incrementCounter(StatsCounters.scrubberIconsProcessingDurationNs, System.nanoTime() - startNs);
        }
    }

    public static void enableScrubberItems(ID scrubObj, Collection<Integer> indices, boolean enabled) {
        if (indices == null || indices.isEmpty()) {
            return;
        }
        Pointer mem = NST._makeIndices(indices);
        ourNSTLibrary.enableScrubberItems(scrubObj, mem, indices.size(), enabled);
    }

    public static void showScrubberItem(ID scrubObj, Collection<Integer> indices, boolean show2, boolean inverseOthers) {
        Pointer mem = NST._makeIndices(indices);
        ourNSTLibrary.showScrubberItems(scrubObj, mem, indices == null ? 0 : indices.size(), show2, inverseOthers);
    }

    @Nullable
    private static Pair<Pointer, Integer> _packItems(List<? extends TBItemScrubber.ItemData> items, int fromIndex, int itemsCount, int visibleItems, boolean withImages, boolean withText) {
        if (items == null || itemsCount <= 0) {
            return null;
        }
        if (fromIndex < 0) {
            LOG.error("_packItems: fromIndex < 0 (" + fromIndex + ")");
            return null;
        }
        if (fromIndex + itemsCount > items.size()) {
            LOG.error("_packItems: fromIndex + itemsCount > items.size() (" + fromIndex + ", " + itemsCount + ", " + items.size() + ")");
            return null;
        }
        long ptr = 0L;
        try {
            int byteCount = 2;
            for (int c = 0; c < itemsCount; ++c) {
                TBItemScrubber.ItemData id2 = items.get(fromIndex + c);
                id2.offset = byteCount;
                if (c >= visibleItems) {
                    byteCount += 6;
                    continue;
                }
                int textSize = 2 + (withText && id2.getTextBytes() != null && id2.getTextBytes().length > 0 ? id2.getTextBytes().length + 1 : 0);
                byteCount += textSize;
                Icon icon2 = id2.darkIcon = withImages && id2.getIcon() != null && !(id2.getIcon() instanceof EmptyIcon) && id2.getIcon().getIconWidth() > 0 && id2.getIcon().getIconHeight() > 0 ? IconLoader.getDarkIcon((Icon)id2.getIcon(), (boolean)true) : null;
                if (id2.darkIcon != null) {
                    id2.fMulX = NST.getIconScaleForTouchbar(id2.darkIcon);
                    id2.scaledWidth = Math.round((float)id2.darkIcon.getIconWidth() * id2.fMulX);
                    id2.scaledHeight = Math.round((float)id2.darkIcon.getIconHeight() * id2.fMulX);
                    int sizeInBytes = id2.scaledWidth * id2.scaledHeight * 4;
                    int totalSize = sizeInBytes + 4;
                    byteCount += totalSize;
                    continue;
                }
                byteCount += 4;
            }
            ptr = Native.malloc((long)byteCount);
            Pointer result2 = new Pointer(ptr);
            result2.setShort(0L, (short)itemsCount);
            int offset = 2;
            for (int c = 0; c < itemsCount; ++c) {
                byte[] txtBytes;
                TBItemScrubber.ItemData id3 = items.get(fromIndex + c);
                if (id3.offset != offset) {
                    throw new Exception("Offset mismatch: scrubber item " + c + ", id.offset=" + id3.offset + " offset=" + offset);
                }
                if (c >= visibleItems) {
                    result2.setShort((long)offset, (short)0);
                    result2.setShort((long)(offset + 2), (short)0);
                    result2.setShort((long)(offset + 4), (short)0);
                    offset += 6;
                    continue;
                }
                byte[] byArray = txtBytes = withText ? id3.getTextBytes() : null;
                if (txtBytes != null && txtBytes.length > 0) {
                    result2.setShort((long)offset, (short)txtBytes.length);
                    result2.write((long)(offset += 2), txtBytes, 0, txtBytes.length);
                    result2.setByte((long)(offset += txtBytes.length), (byte)0);
                    ++offset;
                } else {
                    result2.setShort((long)offset, (short)0);
                    offset += 2;
                }
                if (withImages && id3.darkIcon != null) {
                    offset += NST._writeIconRaster(id3.darkIcon, id3.fMulX, result2, offset, byteCount);
                    continue;
                }
                boolean hasIcon = id3.getIcon() != null && !(id3.getIcon() instanceof EmptyIcon) && id3.getIcon().getIconWidth() > 0 && id3.getIcon().getIconHeight() > 0;
                result2.setShort((long)offset, hasIcon ? (short)1 : 0);
                result2.setShort((long)(offset + 2), (short)0);
                offset += 4;
            }
            return Pair.create((Object)result2, (Object)byteCount);
        }
        catch (Throwable e) {
            if (ptr != 0L) {
                Native.free((long)ptr);
            }
            LOG.error(e);
            return null;
        }
    }

    protected static Pair<Pointer, Dimension> get4ByteRGBARaster(@Nullable Icon icon2) {
        if (icon2 == null || icon2.getIconHeight() <= 0 || icon2.getIconWidth() <= 0) {
            return null;
        }
        float fMulX = NST.getIconScaleForTouchbar(icon2);
        @NotNull BufferedImage img = NST._getImg4ByteRGBA(icon2, fMulX);
        return Pair.create((Object)NST._getRaster(img), (Object)new Dimension(img.getWidth(), img.getHeight()));
    }

    private static Pointer _getRaster(BufferedImage img) {
        if (img == null) {
            return null;
        }
        DataBuffer db = img.getRaster().getDataBuffer();
        DirectDataBufferInt dbb = (DirectDataBufferInt)db;
        return dbb.myMemory;
    }

    private static int _getImgW(BufferedImage img) {
        return img == null ? 0 : img.getWidth();
    }

    private static int _getImgH(BufferedImage img) {
        return img == null ? 0 : img.getHeight();
    }

    private static BufferedImage _getImg4ByteRGBA(Icon icon2, float scale) {
        if (icon2 == null || icon2.getIconHeight() <= 0 || icon2.getIconWidth() <= 0) {
            return null;
        }
        int w = Math.round((float)icon2.getIconWidth() * scale);
        int h = Math.round((float)icon2.getIconHeight() * scale);
        int memLength = w * h * 4;
        Memory memory = new Memory((long)memLength);
        return NST._drawIconIntoMemory(icon2, scale, (Pointer)memory, 0);
    }

    private static float getIconScaleForTouchbar(@NotNull Icon icon2) {
        if (icon2 == null) {
            NST.$$$reportNull$$$0(0);
        }
        return UISettings.getInstance().getPresentationMode() ? 40.0f / (float)icon2.getIconHeight() : (icon2.getIconHeight() < 24 ? 2.5f : 44.0f / (float)icon2.getIconHeight());
    }

    private static BufferedImage _getImg4ByteRGBA(@Nullable Icon icon2) {
        if (icon2 == null || icon2.getIconHeight() <= 0 || icon2.getIconWidth() <= 0) {
            return null;
        }
        float fMulX = NST.getIconScaleForTouchbar(icon2);
        return NST._getImg4ByteRGBA(icon2, fMulX);
    }

    private static int _writeIconRaster(@NotNull Icon icon2, float scale, @NotNull Pointer memory, int offset, int totalMemoryBytes) throws Exception {
        if (icon2 == null) {
            NST.$$$reportNull$$$0(1);
        }
        if (memory == null) {
            NST.$$$reportNull$$$0(2);
        }
        int w = Math.round((float)icon2.getIconWidth() * scale);
        int h = Math.round((float)icon2.getIconHeight() * scale);
        if (w <= 0 || h <= 0) {
            throw new Exception("Incorrect icon sizes: " + icon2.getIconWidth() + "x" + icon2.getIconHeight() + ", scale=" + scale);
        }
        int rasterSizeInBytes = w * h * 4;
        int totalSize = rasterSizeInBytes + 4;
        if (offset + totalSize > totalMemoryBytes) {
            throw new Exception("Incorrect memory offset: offset=" + offset + ", rasterSize=" + rasterSizeInBytes + ", totalMemoryBytes=" + totalMemoryBytes);
        }
        memory.setShort((long)offset, (short)w);
        memory.setShort((long)(offset += 2), (short)h);
        NST._drawIconIntoMemory(icon2, scale, memory, offset += 2);
        return totalSize;
    }

    @NotNull
    private static BufferedImage _drawIconIntoMemory(@NotNull Icon icon2, float scale, @NotNull Pointer memory, int offset) {
        if (icon2 == null) {
            NST.$$$reportNull$$$0(3);
        }
        if (memory == null) {
            NST.$$$reportNull$$$0(4);
        }
        int w = Math.round((float)icon2.getIconWidth() * scale);
        int h = Math.round((float)icon2.getIconHeight() * scale);
        int rasterSizeInBytes = w * h * 4;
        memory.setMemory((long)offset, (long)rasterSizeInBytes, (byte)0);
        DirectDataBufferInt dataBuffer = new DirectDataBufferInt(memory, rasterSizeInBytes, offset);
        DirectColorModel colorModel = new DirectColorModel(ColorModel.getRGBdefault().getColorSpace(), 32, 255, 65280, 0xFF0000, -16777216, false, 3);
        SampleModel sm = colorModel.createCompatibleSampleModel(w, h);
        WritableRasterNative raster = WritableRasterNative.createNativeRaster(sm, dataBuffer);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g = image.createGraphics();
        g.scale(scale, scale);
        g.setComposite(AlphaComposite.SrcOver);
        icon2.paintIcon(null, g, 0, 0);
        g.dispose();
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            NST.$$$reportNull$$$0(5);
        }
        return bufferedImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/NST";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/NST";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "_drawIconIntoMemory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIconScaleForTouchbar";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_writeIconRaster";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "_drawIconIntoMemory";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

