/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachedFileType {
    private static final ConcurrentMap<FileType, CachedFileType> ourInterner = new ConcurrentHashMap<FileType, CachedFileType>();
    @Nullable
    private FileType fileType;

    private CachedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            CachedFileType.$$$reportNull$$$0(0);
        }
        this.fileType = fileType;
    }

    @Nullable
    FileType getUpToDateOrNull() {
        return this.fileType;
    }

    static CachedFileType forType(@NotNull FileType fileType) {
        if (fileType == null) {
            CachedFileType.$$$reportNull$$$0(1);
        }
        return ourInterner.computeIfAbsent(fileType, CachedFileType::new);
    }

    public static void clearCache() {
        ourInterner.forEach((type, cachedType) -> {
            cachedType.fileType = null;
        });
        ourInterner.clear();
    }

    public static void remove(@NotNull FileType type) {
        CachedFileType cached;
        if (type == null) {
            CachedFileType.$$$reportNull$$$0(2);
        }
        if ((cached = (CachedFileType)ourInterner.remove(type)) != null) {
            cached.fileType = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/CachedFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PsiListener
    implements PsiModificationTracker.Listener {
        PsiListener() {
        }

        public void modificationCountChanged() {
            CachedFileType.clearCache();
        }
    }
}

