/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsData;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsState;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsStateService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\tJ\u000e\u0010 \u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\tR:\u0010\u0007\u001a.\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\f\u00a2\u0006\u0002\b\u000b0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsState;", "", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsStateService;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsStateService;)V", "enabledExtensionOrFileNames", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "addEnabledExtensionOrFileNameAndInvalidateCache", "", "extensionOrFileName", "createUnknownExtensionFeature", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeature;", "getCachedData", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsData;", "ignoreExtensionOrFileNameAndInvalidateCache", "invalidateCacheDataForKey", "isIgnored", "", "requestData", "knownExtensions", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$KnownExtensions;", "requestExtensionData", "fileName", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "fullExtension", "updateCache", "Companion", "intellij.platform.ide.impl"})
public final class PluginAdvertiserExtensionsState {
    private final Set<String> enabledExtensionOrFileNames;
    private final Project project;
    private final PluginAdvertiserExtensionsStateService service;
    private static final Logger LOG;
    public static final Companion Companion;

    public final void ignoreExtensionOrFileNameAndInvalidateCache(@NotNull String extensionOrFileName) {
        Intrinsics.checkParameterIsNotNull((Object)extensionOrFileName, (String)"extensionOrFileName");
        UnknownFeaturesCollector.getInstance(this.project).ignoreFeature(this.createUnknownExtensionFeature(extensionOrFileName));
        this.invalidateCacheDataForKey(extensionOrFileName);
    }

    public final void addEnabledExtensionOrFileNameAndInvalidateCache(@NotNull String extensionOrFileName) {
        Intrinsics.checkParameterIsNotNull((Object)extensionOrFileName, (String)"extensionOrFileName");
        Collection collection = this.enabledExtensionOrFileNames;
        boolean bl = false;
        collection.add(extensionOrFileName);
        this.invalidateCacheDataForKey(extensionOrFileName);
    }

    private final PluginAdvertiserExtensionsData getCachedData(String extensionOrFileName) {
        Optional optional = (Optional)this.service.getCache$intellij_platform_ide_impl().getIfPresent((Object)extensionOrFileName);
        return optional != null ? (PluginAdvertiserExtensionsData)optional.orElse(null) : null;
    }

    public final boolean updateCache(@NotNull String extensionOrFileName) {
        Intrinsics.checkParameterIsNotNull((Object)extensionOrFileName, (String)"extensionOrFileName");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        LOG.assertTrue(!application.isReadAccessAllowed());
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        LOG.assertTrue(!application2.isDispatchThread());
        if (this.service.getCache$intellij_platform_ide_impl().getIfPresent((Object)extensionOrFileName) != null) {
            return false;
        }
        PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
        if (knownExtensions == null) {
            return false;
        }
        PluginAdvertiserExtensionsData newData = this.requestData(extensionOrFileName, knownExtensions);
        this.service.getCache$intellij_platform_ide_impl().put((Object)extensionOrFileName, Optional.ofNullable(newData));
        return true;
    }

    private final void invalidateCacheDataForKey(String extensionOrFileName) {
        this.service.getCache$intellij_platform_ide_impl().invalidate((Object)extensionOrFileName);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PluginAdvertiserExtensionsData requestExtensionData(@NotNull String fileName, @NotNull FileType fileType, @Nullable String fullExtension) {
        block10: {
            Object object;
            block12: {
                block11: {
                    boolean alreadySupported;
                    Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                    Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
                    boolean bl = alreadySupported = !(fileType instanceof PlainTextLikeFileType);
                    if (fullExtension != null && this.isIgnored(fullExtension)) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "Extension '%s' is ignored in project '%s'";
                        Object[] objectArray = new Object[]{fullExtension, this.project.getName()};
                        Logger logger = LOG;
                        boolean bl2 = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                        String string3 = string2;
                        logger.debug(string3);
                        return null;
                    }
                    if (this.isIgnored(fileName)) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "File '%s' is ignored in project '%s'";
                        Object[] objectArray = new Object[]{fileName, this.project.getName()};
                        Logger logger = LOG;
                        boolean bl3 = false;
                        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                        String string5 = string4;
                        logger.debug(string5);
                        return null;
                    }
                    if (fullExtension == null && fileType instanceof FakeFileType) {
                        return null;
                    }
                    PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
                    if (knownExtensions == null) break block10;
                    if (alreadySupported) {
                        Object $i$f$map22;
                        String string;
                        Object object2;
                        Set<PluginsAdvertiser.Plugin> availablePlugins = knownExtensions.find(fileName);
                        if (availablePlugins != null) {
                            StringCompanionObject $this$mapTo$iv$iv;
                            Iterable $this$map$iv = availablePlugins;
                            boolean $i$f$map22 = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                PluginsAdvertiser.Plugin plugin = (PluginsAdvertiser.Plugin)item$iv$iv;
                                object2 = destination$iv$iv;
                                boolean bl4 = false;
                                string = it.myPluginId;
                                object2.add(string);
                            }
                            Set plugins = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                            $i$f$map22 = PluginManagerCore.getLoadedPlugins().iterator();
                            while ($i$f$map22.hasNext()) {
                                IdeaPluginDescriptor loadedPlugin;
                                IdeaPluginDescriptor ideaPluginDescriptor = loadedPlugin = (IdeaPluginDescriptor)$i$f$map22.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"loadedPlugin");
                                if (!ideaPluginDescriptor.isEnabled()) continue;
                                PluginId pluginId = loadedPlugin.getPluginId();
                                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"loadedPlugin.pluginId");
                                if (!plugins.contains(pluginId.getIdString())) continue;
                                $this$mapTo$iv$iv = StringCompanionObject.INSTANCE;
                                String string6 = "File '%s' (type: '%s') is already supported by fileName via '%s'(id: '%s') plugin";
                                Object[] objectArray = new Object[4];
                                objectArray[0] = fileName;
                                objectArray[1] = fileType;
                                objectArray[2] = loadedPlugin.getName();
                                PluginId pluginId2 = loadedPlugin.getPluginId();
                                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId2, (String)"loadedPlugin.pluginId");
                                objectArray[3] = pluginId2.getIdString();
                                Object[] objectArray2 = objectArray;
                                object2 = LOG;
                                boolean bl5 = false;
                                String string7 = String.format(string6, Arrays.copyOf(objectArray2, objectArray2.length));
                                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
                                string = string7;
                                object2.debug(string);
                                return null;
                            }
                        }
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string8 = "File '%s' (type: '%s') is already supported therefore looking only for plugins exactly matching fileName";
                        $i$f$map22 = new Object[]{fileName, fileType};
                        object2 = LOG;
                        boolean $this$mapTo$iv$iv = false;
                        String string9 = String.format(string8, Arrays.copyOf($i$f$map22, ((Object[])$i$f$map22).length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String.format(format, *args)");
                        string = string9;
                        object2.debug(string);
                        return this.getCachedData(fileName);
                    }
                    object = fullExtension;
                    if (object == null) break block11;
                    String string = object;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    String it = string;
                    boolean bl8 = false;
                    object = this.getCachedData(it);
                    if (object != null) break block12;
                }
                object = this.getCachedData(fileName);
            }
            return object;
        }
        LOG.debug("No known extensions loaded");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final PluginAdvertiserExtensionsData requestData(String extensionOrFileName, PluginsAdvertiser.KnownExtensions knownExtensions) {
        Iterable $this$filterTo$iv$iv;
        Object[] objectArray;
        IdeCompatibleUpdate it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Set allPlugins;
        Set<PluginsAdvertiser.Plugin> set = knownExtensions.find(extensionOrFileName);
        Set set2 = allPlugins = set != null ? CollectionsKt.toSet((Iterable)set) : null;
        if (allPlugins == null || allPlugins.isEmpty()) {
            LOG.debug("No features for extension " + extensionOrFileName);
            return null;
        }
        Iterable iterable = allPlugins;
        Object object2 = MarketplaceRequests.Companion.getInstance();
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PluginsAdvertiser.Plugin plugin = (PluginsAdvertiser.Plugin)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            objectArray = ((PluginsAdvertiser.Plugin)((Object)it)).myPluginId;
            object.add(objectArray);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = ((MarketplaceRequests)object2).getLastCompatiblePluginUpdate((List<String>)object, null);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeCompatibleUpdate)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.getPluginId();
            object2.add(object);
        }
        Set pluginIdsFromMarketplace = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = allPlugins;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginsAdvertiser.Plugin it2 = (PluginsAdvertiser.Plugin)element$iv$iv;
            boolean bl = false;
            if (!(it2.myFromCustomRepository || it2.myBundled || pluginIdsFromMarketplace.contains(it2.myPluginId))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set compatiblePlugins = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Collection collection = compatiblePlugins;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            collection = StringCompanionObject.INSTANCE;
            String string = "Found following plugins for '%s': [%s]";
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = extensionOrFileName;
            $this$filterTo$iv$iv = compatiblePlugins;
            int n = 1;
            objectArray = objectArray2;
            object = objectArray2;
            object2 = LOG;
            boolean $i$f$map2 = false;
            void $i$f$filterTo2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                PluginsAdvertiser.Plugin plugin = (PluginsAdvertiser.Plugin)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl2 = false;
                String string2 = it3.myPluginId;
                collection2.add(string2);
            }
            collection2 = (List)destination$iv$iv3;
            objectArray[n] = CollectionsKt.joinToString$default((Iterable)collection2, null, null, null, (int)0, null, (Function1)requestData.2.INSTANCE, (int)31, null);
            Object[] objectArray3 = object;
            boolean bl3 = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray3, objectArray3.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            object = string3;
            object2.debug((String)object);
            return new PluginAdvertiserExtensionsData(extensionOrFileName, compatiblePlugins);
        }
        LOG.debug("No plugins for extension " + extensionOrFileName);
        return null;
    }

    private final boolean isIgnored(String extensionOrFileName) {
        return this.enabledExtensionOrFileNames.contains(extensionOrFileName) || UnknownFeaturesCollector.getInstance(this.project).isIgnored(this.createUnknownExtensionFeature(extensionOrFileName));
    }

    private final UnknownFeature createUnknownExtensionFeature(String extensionOrFileName) {
        ExtensionPointName extensionPointName = FileTypeFactory.FILE_TYPE_FACTORY_EP;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"FileTypeFactory.FILE_TYPE_FACTORY_EP");
        return new UnknownFeature(extensionPointName.getName(), "File Type", extensionOrFileName, extensionOrFileName);
    }

    public PluginAdvertiserExtensionsState(@NotNull Project project, @NotNull PluginAdvertiserExtensionsStateService service) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        this.project = project;
        this.service = service;
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.newConcurrentSet<String>()");
        this.enabledExtensionOrFileNames = set;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(PluginsAdvertiser.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(PluginsAdvertiser::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final PluginAdvertiserExtensionsState getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsState$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsState;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PluginAdvertiserExtensionsState getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return new PluginAdvertiserExtensionsState(project, PluginAdvertiserExtensionsStateService.Companion.getInstance());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

