/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance(ProjectFileIndexImpl.class);
    private final Project myProject;

    public ProjectFileIndexImpl(@NotNull Project project) {
        if (project == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(0);
        }
        super(DirectoryIndex.getInstance(project));
        this.myProject = project;
    }

    @Deprecated
    public ProjectFileIndexImpl(@NotNull Project project, @NotNull DirectoryIndex index, @NotNull FileTypeRegistry fileTypeManager) {
        if (project == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(1);
        }
        if (index == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(2);
        }
        if (fileTypeManager == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(3);
        }
        super(index);
        this.myProject = project;
    }

    public boolean iterateContent(@NotNull ContentIterator processor2, @Nullable VirtualFileFilter filter2) {
        Module[] modules2;
        if (processor2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(4);
        }
        for (Module module : modules2 = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).getModules())) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module)) {
                if (this.iterateContentUnderDirectory(contentRoot, processor2, filter2)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<VirtualFile> getRootsToIterate(@NotNull Module module) {
        if (module == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(5);
        }
        Set set = (Set)ReadAction.compute(() -> {
            if (module.isDisposed()) {
                return Collections.emptySet();
            }
            ModuleFileIndexImpl moduleFileIndex = (ModuleFileIndexImpl)ModuleRootManager.getInstance((Module)module).getFileIndex();
            Set<VirtualFile> result2 = moduleFileIndex.getModuleRootsToIterate();
            Iterator<VirtualFile> iterator2 = result2.iterator();
            while (iterator2.hasNext()) {
                VirtualFile root = iterator2.next();
                DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                if (!module.equals(info.getModule())) {
                    iterator2.remove();
                    continue;
                }
                VirtualFile parent = root.getParent();
                if (parent == null || !this.isInContent(parent)) continue;
                iterator2.remove();
            }
            return result2;
        });
        if (set == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    public boolean isExcluded(@NotNull VirtualFile file2) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(7);
        }
        return (info = this.getInfoForFileOrDirectory(file2)).isIgnored() || info.isExcluded(file2);
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(8);
        }
        return this.getInfoForFileOrDirectory(file2).isIgnored();
    }

    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(9);
        }
        return this.getModuleForFile(file2, true);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(10);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((info = this.getInfoForFileOrDirectory(file2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file2))).isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getModule();
        }
        return null;
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(11);
        }
        List<OrderEntry> list2 = this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(file2));
        if (list2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public VirtualFile getClassRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(13);
        }
        return ProjectFileIndexImpl.getClassRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Nullable
    public static VirtualFile getClassRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(14);
        }
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(15);
        }
        return info.isInProject(file2) ? info.getLibraryClassRoot() : null;
    }

    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(16);
        }
        return ProjectFileIndexImpl.getSourceRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Nullable
    public static VirtualFile getSourceRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(17);
        }
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(18);
        }
        return info.isInProject(file2) ? info.getSourceRoot() : null;
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(19);
        }
        return this.getContentRootForFile(file2, true);
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(20);
        }
        return ProjectFileIndexImpl.getContentRootForFile(this.getInfoForFileOrDirectory(file2), file2, honorExclusion);
    }

    @Nullable
    public static VirtualFile getContentRootForFile(@NotNull DirectoryInfo info, @NotNull VirtualFile file2, boolean honorExclusion) {
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(21);
        }
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(22);
        }
        if (info.isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getContentRoot();
        }
        return null;
    }

    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(23);
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myDirectoryIndex.getPackageName(dir);
    }

    public boolean isLibraryClassFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(24);
        }
        if (file2.isDirectory()) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file2);
        return parentInfo.isInProject(file2) && parentInfo.hasLibraryClassRoot();
    }

    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(25);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) || info.isInLibrarySource(fileOrDir);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(26);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.hasLibraryClassRoot();
    }

    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(27);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.isInLibrarySource(fileOrDir);
    }

    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(28);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && (info.hasLibraryClassRoot() || info.isInLibrarySource(fileOrDir));
    }

    public boolean isIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(29);
        }
        return this.isExcluded(file2);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(30);
        }
        return ProjectFileIndexImpl.isFileInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    public static boolean isFileInContent(@NotNull VirtualFile fileOrDir, @NotNull DirectoryInfo info) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(31);
        }
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(32);
        }
        return info.isInProject(fileOrDir) && info.getModule() != null;
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(33);
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource(fileOrDir);
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(34);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.isTestSourcesRoot(info);
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(35);
        }
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(36);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Nullable
    public SourceFolder getSourceFolder(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(37);
        }
        return this.myDirectoryIndex.getSourceRootFolder(this.getInfoForFileOrDirectory(fileOrDir));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myProject.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToIterate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToIterate";
                break;
            }
            case 6: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnderIgnored";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getClassRootForFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootForFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryClassFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInSource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isFileInContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

