/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.actions.CaretStopOptions;
import com.intellij.openapi.editor.ex.BidiTextDirection;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="EditorSettings", storages={@Storage(value="editor.xml")})
public final class EditorSettingsExternalizable
implements PersistentStateComponent<OptionSet> {
    @NonNls
    public static final String PROP_VIRTUAL_SPACE = "VirtualSpace";
    public static final UINumericRange BLINKING_RANGE = new UINumericRange(500, 10, 1500);
    public static final UINumericRange TOOLTIPS_DELAY_RANGE = new UINumericRange(500, 1, 5000);
    private static final String SOFT_WRAP_FILE_MASKS_ENABLED_DEFAULT = "*";
    private static final String SOFT_WRAP_FILE_MASKS_DISABLED_DEFAULT = "*.md; *.txt; *.rst; *.adoc";
    private static final String COMPOSITE_PROPERTY_SEPARATOR = ":";
    @NotNull
    private final OsSpecificState myOsSpecificState;
    private final Set<SoftWrapAppliancePlaces> myPlacesToUseSoftWraps;
    private OptionSet myOptions;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final Map<String, Boolean> myDefaultBreadcrumbVisibility;
    private int myBlockIndent;
    private int myAdditionalLinesCount;
    @NonNls
    public static final String STRIP_TRAILING_SPACES_NONE = "None";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_CHANGED = "Changed";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_WHOLE = "Whole";

    public EditorSettingsExternalizable() {
        this((OsSpecificState)ApplicationManager.getApplication().getService(OsSpecificState.class));
    }

    @NonInjectable
    public EditorSettingsExternalizable(@NotNull OsSpecificState state) {
        if (state == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(0);
        }
        this.myPlacesToUseSoftWraps = EnumSet.noneOf(SoftWrapAppliancePlaces.class);
        this.myOptions = new OptionSet();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myDefaultBreadcrumbVisibility = new HashMap<String, Boolean>();
        this.myAdditionalLinesCount = 10;
        this.myOsSpecificState = state;
    }

    public static EditorSettingsExternalizable getInstance() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return new EditorSettingsExternalizable(new OsSpecificState());
        }
        return (EditorSettingsExternalizable)ServiceManager.getService(EditorSettingsExternalizable.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @NotNull
    public OptionSet getState() {
        OptionSet optionSet = this.myOptions;
        if (optionSet == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(1);
        }
        return optionSet;
    }

    public void loadState(@NotNull OptionSet state) {
        if (state == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(2);
        }
        this.myOptions = state;
        this.parseRawSoftWraps();
    }

    private void parseRawSoftWraps() {
        String[] placeNames;
        this.myPlacesToUseSoftWraps.clear();
        if (StringUtil.isEmpty((String)this.myOptions.USE_SOFT_WRAPS)) {
            return;
        }
        for (String placeName : placeNames = this.myOptions.USE_SOFT_WRAPS.split(COMPOSITE_PROPERTY_SEPARATOR)) {
            try {
                SoftWrapAppliancePlaces place = SoftWrapAppliancePlaces.valueOf(placeName);
                this.myPlacesToUseSoftWraps.add(place);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.storeRawSoftWraps();
    }

    private void storeRawSoftWraps() {
        StringBuilder buffer = new StringBuilder();
        for (SoftWrapAppliancePlaces placeToStore : this.myPlacesToUseSoftWraps) {
            buffer.append((Object)placeToStore).append(COMPOSITE_PROPERTY_SEPARATOR);
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        this.myOptions.USE_SOFT_WRAPS = buffer.toString();
    }

    public OptionSet getOptions() {
        return this.myOptions;
    }

    public boolean isRightMarginShown() {
        return this.myOptions.IS_RIGHT_MARGIN_SHOWN;
    }

    public void setRightMarginShown(boolean val) {
        this.myOptions.IS_RIGHT_MARGIN_SHOWN = val;
    }

    public boolean isLineNumbersShown() {
        return this.myOptions.ARE_LINE_NUMBERS_SHOWN;
    }

    public void setLineNumbersShown(boolean val) {
        this.myOptions.ARE_LINE_NUMBERS_SHOWN = val;
    }

    public boolean areGutterIconsShown() {
        return this.myOptions.ARE_GUTTER_ICONS_SHOWN;
    }

    public void setGutterIconsShown(boolean val) {
        this.myOptions.ARE_GUTTER_ICONS_SHOWN = val;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public int getAdditionalLinesCount() {
        return this.myAdditionalLinesCount;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setAdditionalLinesCount(int additionalLinesCount) {
        this.myAdditionalLinesCount = additionalLinesCount;
    }

    public boolean isFoldingOutlineShown() {
        return this.myOptions.IS_FOLDING_OUTLINE_SHOWN;
    }

    public void setFoldingOutlineShown(boolean val) {
        this.myOptions.IS_FOLDING_OUTLINE_SHOWN = val;
    }

    public boolean isBreadcrumbsAbove() {
        return this.myOptions.SHOW_BREADCRUMBS_ABOVE;
    }

    public boolean setBreadcrumbsAbove(boolean value2) {
        if (this.myOptions.SHOW_BREADCRUMBS_ABOVE == value2) {
            return false;
        }
        this.myOptions.SHOW_BREADCRUMBS_ABOVE = value2;
        return true;
    }

    public boolean isBreadcrumbsShown() {
        return this.myOptions.SHOW_BREADCRUMBS;
    }

    public boolean setBreadcrumbsShown(boolean value2) {
        if (this.myOptions.SHOW_BREADCRUMBS == value2) {
            return false;
        }
        this.myOptions.SHOW_BREADCRUMBS = value2;
        return true;
    }

    public boolean isBreadcrumbsShownFor(String languageID) {
        Boolean visible = (Boolean)this.myOptions.mapLanguageBreadcrumbs.get(languageID);
        if (visible == null) {
            Boolean defaultVisible = this.myDefaultBreadcrumbVisibility.get(languageID);
            if (defaultVisible == null) {
                for (BreadcrumbsProvider provider : BreadcrumbsProvider.EP_NAME.getExtensionList()) {
                    for (Language language : provider.getLanguages()) {
                        this.myDefaultBreadcrumbVisibility.put(language.getID(), provider.isShownByDefault());
                    }
                }
                defaultVisible = this.myDefaultBreadcrumbVisibility.get(languageID);
            }
            return defaultVisible == null || defaultVisible != false;
        }
        return visible;
    }

    public void resetDefaultBreadcrumbVisibility() {
        this.myDefaultBreadcrumbVisibility.clear();
    }

    public boolean hasBreadcrumbSettings(String languageID) {
        return this.myOptions.mapLanguageBreadcrumbs.containsKey(languageID);
    }

    public boolean setBreadcrumbsShownFor(String languageID, boolean value2) {
        Boolean visible = this.myOptions.mapLanguageBreadcrumbs.put(languageID, value2);
        return (visible == null || visible != false) != value2;
    }

    public boolean isDocCommentRenderingEnabled() {
        return this.myOptions.ENABLE_RENDERED_DOC;
    }

    public void setDocCommentRenderingEnabled(boolean value2) {
        this.myOptions.ENABLE_RENDERED_DOC = value2;
    }

    public boolean isBlockCursor() {
        return this.myOptions.IS_BLOCK_CURSOR;
    }

    public void setBlockCursor(boolean val) {
        this.myOptions.IS_BLOCK_CURSOR = val;
    }

    public boolean isCaretRowShown() {
        return true;
    }

    public int getBlockIndent() {
        return this.myBlockIndent;
    }

    public void setBlockIndent(int blockIndent) {
        this.myBlockIndent = blockIndent;
    }

    public boolean isSmartHome() {
        return this.myOptions.SMART_HOME;
    }

    public void setSmartHome(boolean val) {
        this.myOptions.SMART_HOME = val;
    }

    public boolean isUseSoftWraps() {
        return this.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public boolean isUseSoftWraps(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(3);
        }
        return this.myPlacesToUseSoftWraps.contains((Object)place);
    }

    public void setUseSoftWraps(boolean use2) {
        this.setUseSoftWraps(use2, SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public void setUseSoftWraps(boolean use2, @NotNull SoftWrapAppliancePlaces place) {
        boolean update2;
        if (place == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(4);
        }
        if (!(update2 = use2 ^ this.myPlacesToUseSoftWraps.contains((Object)place))) {
            return;
        }
        if (use2) {
            this.myPlacesToUseSoftWraps.add(place);
        } else {
            this.myPlacesToUseSoftWraps.remove((Object)place);
        }
        this.storeRawSoftWraps();
        if (place == SoftWrapAppliancePlaces.MAIN_EDITOR) {
            this.setSoftWrapFileMasks(this.getSoftWrapFileMasks());
        }
    }

    public boolean isUseCustomSoftWrapIndent() {
        return this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setUseCustomSoftWrapIndent(boolean use2) {
        this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT = use2;
    }

    public int getCustomSoftWrapIndent() {
        return this.myOptions.CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setCustomSoftWrapIndent(int indent) {
        this.myOptions.CUSTOM_SOFT_WRAP_INDENT = indent;
    }

    public boolean isVirtualSpace() {
        return this.myOptions.IS_VIRTUAL_SPACE;
    }

    public void setVirtualSpace(boolean val) {
        boolean oldValue = this.myOptions.IS_VIRTUAL_SPACE;
        this.myOptions.IS_VIRTUAL_SPACE = val;
        this.myPropertyChangeSupport.firePropertyChange(PROP_VIRTUAL_SPACE, oldValue, val);
    }

    public boolean isCaretInsideTabs() {
        return this.myOptions.IS_CARET_INSIDE_TABS;
    }

    public void setCaretInsideTabs(boolean val) {
        this.myOptions.IS_CARET_INSIDE_TABS = val;
    }

    public boolean isBlinkCaret() {
        return this.myOptions.IS_CARET_BLINKING;
    }

    public void setBlinkCaret(boolean blinkCaret) {
        this.myOptions.IS_CARET_BLINKING = blinkCaret;
    }

    public int getBlinkPeriod() {
        return BLINKING_RANGE.fit(this.myOptions.CARET_BLINKING_PERIOD);
    }

    public void setBlinkPeriod(int blinkInterval) {
        this.myOptions.CARET_BLINKING_PERIOD = BLINKING_RANGE.fit(blinkInterval);
    }

    public boolean isEnsureNewLineAtEOF() {
        return this.myOptions.IS_ENSURE_NEWLINE_AT_EOF;
    }

    public void setEnsureNewLineAtEOF(boolean ensure) {
        this.myOptions.IS_ENSURE_NEWLINE_AT_EOF = ensure;
    }

    @StripTrailingSpaces
    public String getStripTrailingSpaces() {
        return this.myOptions.STRIP_TRAILING_SPACES;
    }

    public void setStripTrailingSpaces(@StripTrailingSpaces String stripTrailingSpaces) {
        this.myOptions.STRIP_TRAILING_SPACES = stripTrailingSpaces;
    }

    public boolean isShowQuickDocOnMouseOverElement() {
        return this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT;
    }

    public void setShowQuickDocOnMouseOverElement(boolean show2) {
        this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = show2;
    }

    public boolean isShowInspectionWidget() {
        return this.myOptions.SHOW_INSPECTION_WIDGET;
    }

    public void setShowInspectionWidget(boolean show2) {
        this.myOptions.SHOW_INSPECTION_WIDGET = show2;
    }

    @Deprecated
    public int getQuickDocOnMouseOverElementDelayMillis() {
        return this.getTooltipsDelay();
    }

    public int getTooltipsDelay() {
        return TOOLTIPS_DELAY_RANGE.fit(this.myOptions.TOOLTIPS_DELAY_MS);
    }

    public void setTooltipsDelay(int delay) {
        this.myOptions.TOOLTIPS_DELAY_MS = TOOLTIPS_DELAY_RANGE.fit(delay);
    }

    public boolean isShowIntentionBulb() {
        return this.myOptions.SHOW_INTENTION_BULB;
    }

    public void setShowIntentionBulb(boolean show2) {
        this.myOptions.SHOW_INTENTION_BULB = show2;
    }

    public boolean isRefrainFromScrolling() {
        return this.myOptions.REFRAIN_FROM_SCROLLING;
    }

    public void setRefrainFromScrolling(boolean b) {
        this.myOptions.REFRAIN_FROM_SCROLLING = b;
    }

    public boolean isShowNotificationAfterReformat() {
        return Registry.is((String)"editor.show.notification.after.reformat");
    }

    public boolean isShowNotificationAfterOptimizeImports() {
        return Registry.is((String)"editor.show.notification.after.optimize.imports");
    }

    public boolean isWhitespacesShown() {
        return this.myOptions.IS_WHITESPACES_SHOWN;
    }

    public void setWhitespacesShown(boolean val) {
        this.myOptions.IS_WHITESPACES_SHOWN = val;
    }

    public boolean isLeadingWhitespacesShown() {
        return this.myOptions.IS_LEADING_WHITESPACES_SHOWN;
    }

    public void setLeadingWhitespacesShown(boolean val) {
        this.myOptions.IS_LEADING_WHITESPACES_SHOWN = val;
    }

    public boolean isInnerWhitespacesShown() {
        return this.myOptions.IS_INNER_WHITESPACES_SHOWN;
    }

    public void setInnerWhitespacesShown(boolean val) {
        this.myOptions.IS_INNER_WHITESPACES_SHOWN = val;
    }

    public boolean isTrailingWhitespacesShown() {
        return this.myOptions.IS_TRAILING_WHITESPACES_SHOWN;
    }

    public void setTrailingWhitespacesShown(boolean val) {
        this.myOptions.IS_TRAILING_WHITESPACES_SHOWN = val;
    }

    public boolean isAllSoftWrapsShown() {
        return this.myOptions.IS_ALL_SOFTWRAPS_SHOWN;
    }

    public void setAllSoftwrapsShown(boolean val) {
        this.myOptions.IS_ALL_SOFTWRAPS_SHOWN = val;
    }

    public boolean isIndentGuidesShown() {
        return this.myOptions.IS_INDENT_GUIDES_SHOWN;
    }

    public void setIndentGuidesShown(boolean val) {
        this.myOptions.IS_INDENT_GUIDES_SHOWN = val;
    }

    public boolean isFocusMode() {
        return this.myOptions.IS_FOCUS_MODE;
    }

    public void setFocusMode(boolean val) {
        this.myOptions.IS_FOCUS_MODE = val;
    }

    public boolean isSmoothScrolling() {
        return this.myOptions.IS_ANIMATED_SCROLLING;
    }

    public void setSmoothScrolling(boolean val) {
        this.myOptions.IS_ANIMATED_SCROLLING = val;
    }

    public boolean isCamelWords() {
        return this.myOptions.IS_CAMEL_WORDS;
    }

    public void setCamelWords(boolean val) {
        this.myOptions.IS_CAMEL_WORDS = val;
    }

    public boolean isAdditionalPageAtBottom() {
        return this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM;
    }

    public void setAdditionalPageAtBottom(boolean val) {
        this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM = val;
    }

    public boolean isDndEnabled() {
        return this.myOptions.IS_DND_ENABLED;
    }

    public void setDndEnabled(boolean val) {
        this.myOptions.IS_DND_ENABLED = val;
    }

    public boolean isWheelFontChangeEnabled() {
        return this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED;
    }

    public void setWheelFontChangeEnabled(boolean val) {
        this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED = val;
    }

    public boolean isMouseClickSelectionHonorsCamelWords() {
        return this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
    }

    public void setMouseClickSelectionHonorsCamelWords(boolean val) {
        this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = val;
    }

    public boolean isVariableInplaceRenameEnabled() {
        return this.myOptions.RENAME_VARIABLES_INPLACE;
    }

    public void setVariableInplaceRenameEnabled(boolean val) {
        this.myOptions.RENAME_VARIABLES_INPLACE = val;
    }

    public boolean isPreselectRename() {
        return this.myOptions.PRESELECT_RENAME;
    }

    public void setPreselectRename(boolean val) {
        this.myOptions.PRESELECT_RENAME = val;
    }

    public boolean isShowInlineLocalDialog() {
        return this.myOptions.SHOW_INLINE_DIALOG;
    }

    public void setShowInlineLocalDialog(boolean val) {
        this.myOptions.SHOW_INLINE_DIALOG = val;
    }

    public boolean addCaretsOnDoubleCtrl() {
        return this.myOptions.ADD_CARETS_ON_DOUBLE_CTRL;
    }

    public void setAddCaretsOnDoubleCtrl(boolean val) {
        this.myOptions.ADD_CARETS_ON_DOUBLE_CTRL = val;
    }

    public BidiTextDirection getBidiTextDirection() {
        return this.myOptions.BIDI_TEXT_DIRECTION;
    }

    public void setBidiTextDirection(BidiTextDirection direction) {
        this.myOptions.BIDI_TEXT_DIRECTION = direction;
    }

    @Deprecated
    public boolean isShowParameterNameHints() {
        return this.myOptions.SHOW_PARAMETER_NAME_HINTS;
    }

    @Deprecated
    public void setShowParameterNameHints(boolean value2) {
        this.myOptions.SHOW_PARAMETER_NAME_HINTS = value2;
    }

    public boolean isKeepTrailingSpacesOnCaretLine() {
        return this.myOptions.KEEP_TRAILING_SPACE_ON_CARET_LINE;
    }

    public void setKeepTrailingSpacesOnCaretLine(boolean keep) {
        this.myOptions.KEEP_TRAILING_SPACE_ON_CARET_LINE = keep;
    }

    @NotNull
    public String getSoftWrapFileMasks() {
        String storedValue = this.myOptions.SOFT_WRAP_FILE_MASKS;
        if (storedValue != null) {
            String string = storedValue;
            if (string == null) {
                EditorSettingsExternalizable.$$$reportNull$$$0(5);
            }
            return string;
        }
        return this.isUseSoftWraps() ? SOFT_WRAP_FILE_MASKS_ENABLED_DEFAULT : SOFT_WRAP_FILE_MASKS_DISABLED_DEFAULT;
    }

    public void setSoftWrapFileMasks(@NotNull String value2) {
        if (value2 == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(6);
        }
        this.myOptions.SOFT_WRAP_FILE_MASKS = value2;
    }

    @NotNull
    public CaretStopOptions getCaretStopOptions() {
        CaretStopOptions caretStopOptions = this.myOsSpecificState.CARET_STOP_OPTIONS;
        if (caretStopOptions == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(7);
        }
        return caretStopOptions;
    }

    public void setCaretStopOptions(@NotNull CaretStopOptions options2) {
        if (options2 == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(8);
        }
        this.myOsSpecificState.CARET_STOP_OPTIONS = options2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/EditorSettingsExternalizable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/EditorSettingsExternalizable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapFileMasks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretStopOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUseSoftWraps";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUseSoftWraps";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSoftWrapFileMasks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCaretStopOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface StripTrailingSpaces {
    }

    @State(name="OsSpecificEditorSettings", storages={@Storage(value="editor.os-specific.xml", roamingType=RoamingType.PER_OS)})
    public static final class OsSpecificState
    implements PersistentStateComponent<OsSpecificState> {
        public CaretStopOptions CARET_STOP_OPTIONS = new CaretStopOptions();

        public OsSpecificState getState() {
            return this;
        }

        public void loadState(@NotNull OsSpecificState state) {
            if (state == null) {
                OsSpecificState.$$$reportNull$$$0(0);
            }
            XmlSerializerUtil.copyBean((Object)state, (Object)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable$OsSpecificState", "loadState"));
        }
    }

    public static final class OptionSet {
        public String LINE_SEPARATOR;
        public String USE_SOFT_WRAPS;
        public String SOFT_WRAP_FILE_MASKS;
        public boolean USE_CUSTOM_SOFT_WRAP_INDENT = false;
        public int CUSTOM_SOFT_WRAP_INDENT = 0;
        public boolean IS_VIRTUAL_SPACE = false;
        public boolean IS_CARET_INSIDE_TABS;
        @NonNls
        public String STRIP_TRAILING_SPACES = "Changed";
        public boolean IS_ENSURE_NEWLINE_AT_EOF = false;
        public boolean SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = true;
        public boolean SHOW_INSPECTION_WIDGET = true;
        public int TOOLTIPS_DELAY_MS;
        public boolean SHOW_INTENTION_BULB;
        public boolean IS_CARET_BLINKING;
        public int CARET_BLINKING_PERIOD;
        public boolean IS_RIGHT_MARGIN_SHOWN;
        public boolean ARE_LINE_NUMBERS_SHOWN;
        public boolean ARE_GUTTER_ICONS_SHOWN;
        public boolean IS_FOLDING_OUTLINE_SHOWN;
        public boolean SHOW_BREADCRUMBS_ABOVE;
        public boolean SHOW_BREADCRUMBS;
        public boolean ENABLE_RENDERED_DOC;
        public boolean SMART_HOME;
        public boolean IS_BLOCK_CURSOR;
        public boolean IS_WHITESPACES_SHOWN;
        public boolean IS_LEADING_WHITESPACES_SHOWN;
        public boolean IS_INNER_WHITESPACES_SHOWN;
        public boolean IS_TRAILING_WHITESPACES_SHOWN;
        public boolean IS_ALL_SOFTWRAPS_SHOWN;
        public boolean IS_INDENT_GUIDES_SHOWN;
        public boolean IS_FOCUS_MODE;
        public boolean IS_ANIMATED_SCROLLING;
        public boolean IS_CAMEL_WORDS;
        public boolean ADDITIONAL_PAGE_AT_BOTTOM;
        public boolean IS_DND_ENABLED;
        public boolean IS_WHEEL_FONTCHANGE_ENABLED;
        public boolean IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
        public boolean RENAME_VARIABLES_INPLACE;
        public boolean PRESELECT_RENAME;
        public boolean SHOW_INLINE_DIALOG;
        public boolean REFRAIN_FROM_SCROLLING;
        public boolean ADD_CARETS_ON_DOUBLE_CTRL;
        public BidiTextDirection BIDI_TEXT_DIRECTION;
        public boolean SHOW_PARAMETER_NAME_HINTS;
        public boolean KEEP_TRAILING_SPACE_ON_CARET_LINE;
        private final Map<String, Boolean> mapLanguageBreadcrumbs;

        public OptionSet() {
            this.TOOLTIPS_DELAY_MS = EditorSettingsExternalizable.TOOLTIPS_DELAY_RANGE.initial;
            this.SHOW_INTENTION_BULB = true;
            this.IS_CARET_BLINKING = true;
            this.CARET_BLINKING_PERIOD = EditorSettingsExternalizable.BLINKING_RANGE.initial;
            this.IS_RIGHT_MARGIN_SHOWN = true;
            this.ARE_LINE_NUMBERS_SHOWN = true;
            this.ARE_GUTTER_ICONS_SHOWN = true;
            this.IS_FOLDING_OUTLINE_SHOWN = true;
            this.SHOW_BREADCRUMBS_ABOVE = false;
            this.SHOW_BREADCRUMBS = true;
            this.ENABLE_RENDERED_DOC = false;
            this.SMART_HOME = true;
            this.IS_BLOCK_CURSOR = false;
            this.IS_WHITESPACES_SHOWN = false;
            this.IS_LEADING_WHITESPACES_SHOWN = true;
            this.IS_INNER_WHITESPACES_SHOWN = true;
            this.IS_TRAILING_WHITESPACES_SHOWN = true;
            this.IS_ALL_SOFTWRAPS_SHOWN = false;
            this.IS_INDENT_GUIDES_SHOWN = true;
            this.IS_FOCUS_MODE = false;
            this.IS_ANIMATED_SCROLLING = true;
            this.IS_CAMEL_WORDS = false;
            this.ADDITIONAL_PAGE_AT_BOTTOM = false;
            this.IS_DND_ENABLED = true;
            this.IS_WHEEL_FONTCHANGE_ENABLED = false;
            this.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = true;
            this.RENAME_VARIABLES_INPLACE = true;
            this.PRESELECT_RENAME = true;
            this.SHOW_INLINE_DIALOG = true;
            this.REFRAIN_FROM_SCROLLING = false;
            this.ADD_CARETS_ON_DOUBLE_CTRL = true;
            this.BIDI_TEXT_DIRECTION = BidiTextDirection.CONTENT_BASED;
            this.SHOW_PARAMETER_NAME_HINTS = true;
            this.KEEP_TRAILING_SPACE_ON_CARET_LINE = true;
            this.mapLanguageBreadcrumbs = new HashMap<String, Boolean>();
        }

        public Map<String, Boolean> getLanguageBreadcrumbsMap() {
            return this.mapLanguageBreadcrumbs;
        }

        public void setLanguageBreadcrumbsMap(Map<String, Boolean> map2) {
            if (this.mapLanguageBreadcrumbs != map2) {
                this.mapLanguageBreadcrumbs.clear();
                this.mapLanguageBreadcrumbs.putAll(map2);
            }
        }
    }
}

