/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004H\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"CONTAINER_PATTERN", "Ljava/util/regex/Pattern;", "getColoredAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/intellij/navigation/ItemPresentation;", "getLocationText", "", "intellij.platform.lang.impl"})
public final class UtilKt {
    private static final Pattern CONTAINER_PATTERN;

    @Nullable
    public static final TextAttributes getColoredAttributes(@NotNull ItemPresentation $this$getColoredAttributes) {
        ColoredItemPresentation coloredPresentation;
        ColoredItemPresentation coloredItemPresentation;
        Intrinsics.checkParameterIsNotNull((Object)$this$getColoredAttributes, (String)"$this$getColoredAttributes");
        ItemPresentation itemPresentation = $this$getColoredAttributes;
        if (!(itemPresentation instanceof ColoredItemPresentation)) {
            itemPresentation = null;
        }
        if ((coloredItemPresentation = (coloredPresentation = (ColoredItemPresentation)itemPresentation)) == null || (coloredItemPresentation = coloredItemPresentation.getTextAttributesKey()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)coloredItemPresentation, (String)"coloredPresentation?.tex\u2026ributesKey ?: return null");
        ColoredItemPresentation textAttributesKey = coloredItemPresentation;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        return editorColorsManager.getSchemeForCurrentUITheme().getAttributes((TextAttributesKey)textAttributesKey);
    }

    @Nullable
    public static final String getLocationText(@NotNull ItemPresentation $this$getLocationText) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getLocationText, (String)"$this$getLocationText");
        String string = $this$getLocationText.getLocationString();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locationString ?: return null");
        String locationString = string;
        Matcher matcher = CONTAINER_PATTERN.matcher(locationString);
        return matcher.matches() ? matcher.group(2) : locationString;
    }

    static {
        Pattern pattern = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"(\\\\(in |\\\\()?([^)]*)(\\\\))?\")");
        CONTAINER_PATTERN = pattern;
    }
}

