/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumenter;
import java.lang.reflect.Method;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class TestDiscoveryInnerClassInstrumenter
extends TestDiscoveryInstrumenter {
    private final String myInternalCounterClassJVMName;
    private static final String myInternalCounterClassName = "int";
    private volatile Method myDefineClassMethodRef;
    private final ClassLoader myClassLoader;

    public TestDiscoveryInnerClassInstrumenter(ClassWriter classWriter, ClassReader cr, String className, ClassLoader loader) {
        super(classWriter, cr, className);
        this.myInternalCounterClassJVMName = this.myInternalClassName + "$" + myInternalCounterClassName;
        this.myClassLoader = loader;
    }

    protected void ensureArrayInitialized(MethodVisitor mv) {
    }

    protected String getFieldClassName() {
        return this.myInternalCounterClassJVMName;
    }

    private void generateInnerClassWithCounter() {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(this.myClassVersion, 4152, this.myInternalCounterClassJVMName, null, "java/lang/Object", null);
        cw.visitOuterClass(this.myInternalClassName, this.myInternalCounterClassJVMName, null);
        cw.visitField(25, "__$methodsVisited$__", "[Z", null, null);
        MethodVisitor staticBlockVisitor = cw.visitMethod(8, "<clinit>", "()V", null, null);
        staticBlockVisitor.visitCode();
        this.initArray(staticBlockVisitor);
        staticBlockVisitor.visitInsn(177);
        staticBlockVisitor.visitMaxs(6, 0);
        staticBlockVisitor.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        try {
            byte[] bytes = cw.toByteArray();
            Method defineClassMethodRef = this.myDefineClassMethodRef;
            if (defineClassMethodRef == null && (defineClassMethodRef = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE)) != null) {
                defineClassMethodRef.setAccessible(true);
                this.myDefineClassMethodRef = defineClassMethodRef;
            }
            defineClassMethodRef.invoke((Object)this.myClassLoader, bytes, 0, bytes.length);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void generateMembers() {
        this.generateInnerClassWithCounter();
        this.visitInnerClass(this.myInternalCounterClassJVMName, this.myInternalClassName, myInternalCounterClassName, 26);
    }
}

