/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorColorPalette {
    protected final EditorColorsScheme myColorsScheme;
    private final MultiMap<Color, TextAttributesKey> myColors = new MultiMap();
    public static final Comparator<Color> ORDER_NONE = Comparator.comparingInt(EditorColorPalette::getDefaultOrder);
    public static final Comparator<Color> ORDER_BY_INTENSITY = Comparator.comparingInt(EditorColorPalette::getIntensity);

    public EditorColorPalette(EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    public EditorColorPalette withBackgroundColors() {
        return this.collectColors((Function<? super TextAttributes, ? extends Color>)((Function)attr -> attr.getBackgroundColor()));
    }

    public EditorColorPalette withForegroundColors() {
        return this.collectColors((Function<? super TextAttributes, ? extends Color>)((Function)attr -> attr.getForegroundColor()));
    }

    private Collection<Color> orderBy(@Nullable Comparator<? super Color> comparator) {
        ArrayList<Color> sorted = new ArrayList<Color>(this.myColors.keySet());
        sorted.sort(comparator);
        return sorted;
    }

    private static int getIntensity(@NotNull Color color) {
        if (color == null) {
            EditorColorPalette.$$$reportNull$$$0(0);
        }
        return (color.getRed() + color.getGreen() + color.getBlue()) / 3;
    }

    @Contract(pure=true)
    private static int getDefaultOrder(@NotNull Color color) {
        if (color == null) {
            EditorColorPalette.$$$reportNull$$$0(1);
        }
        return 0;
    }

    public Collection<Color> getColors(@NotNull Comparator<? super Color> comparator) {
        if (comparator == null) {
            EditorColorPalette.$$$reportNull$$$0(2);
        }
        return comparator == ORDER_NONE ? this.myColors.keySet() : this.orderBy(comparator);
    }

    @NotNull
    public Set<Map.Entry<Color, Collection<TextAttributesKey>>> getEntries() {
        Set set = this.myColors.entrySet();
        if (set == null) {
            EditorColorPalette.$$$reportNull$$$0(3);
        }
        return set;
    }

    public EditorColorPalette collectColors(@NotNull Function<? super TextAttributes, ? extends Color> attrColorReader) {
        if (attrColorReader == null) {
            EditorColorPalette.$$$reportNull$$$0(4);
        }
        return this.collectColorsWithFilter(attrColorReader, false);
    }

    public EditorColorPalette collectColorsWithFilter(@NotNull Function<? super TextAttributes, ? extends Color> attrColorReader, boolean filterOutRainbowAttrKeys) {
        if (attrColorReader == null) {
            EditorColorPalette.$$$reportNull$$$0(5);
        }
        MultiMap colors = new MultiMap();
        for (TextAttributesKey key : this.getTextAttributeKeys(filterOutRainbowAttrKeys)) {
            Color usedColor;
            TextAttributes attributes = this.myColorsScheme.getAttributes(key);
            if (attributes == null || (usedColor = (Color)attrColorReader.fun((Object)attributes)) == null) continue;
            colors.putValue((Object)usedColor, (Object)key);
        }
        this.myColors.putAllValues(colors);
        return this;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor) {
        boolean searchBrighter;
        Color foundColor;
        if (sampleColor == null) {
            EditorColorPalette.$$$reportNull$$$0(6);
        }
        if ((foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(searchBrighter = ColorUtil.isDark((Color)sampleColor)))) == null) {
            foundColor = this.getClosestNonConflictingColor(sampleColor, EditorColorPalette.getAdjuster(!searchBrighter));
        }
        return foundColor;
    }

    @Contract(pure=true)
    private static Function<Color, Color> getAdjuster(boolean searchBrighter) {
        return searchBrighter ? Color::brighter : Color::darker;
    }

    @Nullable
    public Color getClosestNonConflictingColor(@NotNull Color sampleColor, @NotNull Function<? super Color, ? extends Color> colorAdjuster) {
        if (sampleColor == null) {
            EditorColorPalette.$$$reportNull$$$0(7);
        }
        if (colorAdjuster == null) {
            EditorColorPalette.$$$reportNull$$$0(8);
        }
        if (this.myColors.containsKey((Object)sampleColor)) {
            Color newColor = (Color)colorAdjuster.fun((Object)sampleColor);
            return !sampleColor.equals(newColor) ? this.getClosestNonConflictingColor(newColor, colorAdjuster) : null;
        }
        return sampleColor;
    }

    protected abstract Collection<TextAttributesKey> getTextAttributeKeys(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/EditorColorPalette";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrColorReader";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleColor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorAdjuster";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/EditorColorPalette";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIntensity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectColors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectColorsWithFilter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClosestNonConflictingColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

