/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsFactoryElementChildRoleBase;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsValidationConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.JpsCompilerExcludesImpl;
import org.jetbrains.jps.model.java.impl.compiler.JpsValidationConfigurationImpl;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.model.java.impl.compiler.ResourcePatterns;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsJavaCompilerConfigurationImpl
extends JpsCompositeElementBase<JpsJavaCompilerConfigurationImpl>
implements JpsJavaCompilerConfiguration {
    public static final JpsFactoryElementChildRoleBase<JpsJavaCompilerConfiguration> ROLE = JpsFactoryElementChildRoleBase.create((String)"compiler configuration", () -> new JpsJavaCompilerConfigurationImpl());
    private boolean myAddNotNullAssertions = true;
    private List<String> myNotNullAnnotations = Collections.singletonList(NotNull.class.getName());
    private boolean myClearOutputDirectoryOnRebuild = true;
    private final JpsCompilerExcludes myCompilerExcludes = new JpsCompilerExcludesImpl();
    private final JpsCompilerExcludes myValidationExcludes = new JpsCompilerExcludesImpl();
    private final List<String> myResourcePatterns = new ArrayList<String>();
    private final List<ProcessorConfigProfile> myAnnotationProcessingProfiles = new ArrayList<ProcessorConfigProfile>();
    private final ProcessorConfigProfileImpl myDefaultAnnotationProcessingProfile = new ProcessorConfigProfileImpl("Default");
    private boolean myUseReleaseOption = true;
    private String myProjectByteCodeTargetLevel;
    private final Map<String, String> myModulesByteCodeTargetLevels = new HashMap<String, String>();
    private final Map<String, JpsJavaCompilerOptions> myCompilerOptions = new HashMap<String, JpsJavaCompilerOptions>();
    private String myJavaCompilerId = "Javac";
    private Map<JpsModule, ProcessorConfigProfile> myAnnotationProcessingProfileMap;
    private ResourcePatterns myCompiledPatterns;
    private JpsValidationConfiguration myValidationConfiguration = new JpsValidationConfigurationImpl(false, Collections.emptySet());

    public JpsJavaCompilerConfigurationImpl() {
    }

    private JpsJavaCompilerConfigurationImpl(JpsJavaCompilerConfigurationImpl original) {
        super((JpsCompositeElementBase)original);
    }

    @NotNull
    public JpsJavaCompilerConfigurationImpl createCopy() {
        return new JpsJavaCompilerConfigurationImpl(this);
    }

    public boolean isAddNotNullAssertions() {
        return this.myAddNotNullAssertions;
    }

    public List<String> getNotNullAnnotations() {
        return this.myNotNullAnnotations;
    }

    public boolean isClearOutputDirectoryOnRebuild() {
        return this.myClearOutputDirectoryOnRebuild;
    }

    public void setAddNotNullAssertions(boolean addNotNullAssertions) {
        this.myAddNotNullAssertions = addNotNullAssertions;
    }

    public void setNotNullAnnotations(List<String> notNullAnnotations) {
        this.myNotNullAnnotations = Collections.unmodifiableList(notNullAnnotations);
    }

    public void setClearOutputDirectoryOnRebuild(boolean clearOutputDirectoryOnRebuild) {
        this.myClearOutputDirectoryOnRebuild = clearOutputDirectoryOnRebuild;
    }

    @NotNull
    public JpsCompilerExcludes getCompilerExcludes() {
        JpsCompilerExcludes jpsCompilerExcludes = this.myCompilerExcludes;
        if (jpsCompilerExcludes == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(0);
        }
        return jpsCompilerExcludes;
    }

    @NotNull
    public JpsCompilerExcludes getValidationExcludes() {
        JpsCompilerExcludes jpsCompilerExcludes = this.myValidationExcludes;
        if (jpsCompilerExcludes == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(1);
        }
        return jpsCompilerExcludes;
    }

    @NotNull
    public JpsValidationConfiguration getValidationConfiguration() {
        JpsValidationConfiguration jpsValidationConfiguration = this.myValidationConfiguration;
        if (jpsValidationConfiguration == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(2);
        }
        return jpsValidationConfiguration;
    }

    public void setValidationConfiguration(boolean validateOnBuild, @NotNull Set<String> disabledValidators) {
        if (disabledValidators == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(3);
        }
        this.myValidationConfiguration = new JpsValidationConfigurationImpl(validateOnBuild, disabledValidators);
    }

    @NotNull
    public ProcessorConfigProfile getDefaultAnnotationProcessingProfile() {
        ProcessorConfigProfileImpl processorConfigProfileImpl = this.myDefaultAnnotationProcessingProfile;
        if (processorConfigProfileImpl == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(4);
        }
        return processorConfigProfileImpl;
    }

    @NotNull
    public Collection<ProcessorConfigProfile> getAnnotationProcessingProfiles() {
        List<ProcessorConfigProfile> list = this.myAnnotationProcessingProfiles;
        if (list == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void addResourcePattern(String pattern) {
        this.myResourcePatterns.add(pattern);
    }

    public List<String> getResourcePatterns() {
        return this.myResourcePatterns;
    }

    public boolean isResourceFile(@NotNull File file, @NotNull File srcRoot) {
        ResourcePatterns patterns;
        if (file == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(6);
        }
        if (srcRoot == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(7);
        }
        if ((patterns = this.myCompiledPatterns) == null) {
            this.myCompiledPatterns = patterns = new ResourcePatterns(this);
        }
        return patterns.isResourceFile(file, srcRoot);
    }

    @Nullable
    public String getByteCodeTargetLevel(String moduleName) {
        String level = this.myModulesByteCodeTargetLevels.get(moduleName);
        if (level != null) {
            return level.isEmpty() ? null : level;
        }
        return this.myProjectByteCodeTargetLevel;
    }

    public void setModuleByteCodeTargetLevel(String moduleName, String level) {
        this.myModulesByteCodeTargetLevels.put(moduleName, level);
    }

    @NotNull
    public String getJavaCompilerId() {
        String string = this.myJavaCompilerId;
        if (string == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setJavaCompilerId(@NotNull String compiler) {
        if (compiler == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(9);
        }
        this.myJavaCompilerId = compiler;
    }

    @NotNull
    public JpsJavaCompilerOptions getCompilerOptions(@NotNull String compilerId) {
        JpsJavaCompilerOptions options;
        if (compilerId == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(10);
        }
        if ((options = this.myCompilerOptions.get(compilerId)) == null) {
            options = new JpsJavaCompilerOptions();
            this.myCompilerOptions.put(compilerId, options);
        }
        JpsJavaCompilerOptions jpsJavaCompilerOptions = options;
        if (jpsJavaCompilerOptions == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(11);
        }
        return jpsJavaCompilerOptions;
    }

    public void setCompilerOptions(@NotNull String compilerId, @NotNull JpsJavaCompilerOptions options) {
        if (compilerId == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(12);
        }
        if (options == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(13);
        }
        this.myCompilerOptions.put(compilerId, options);
    }

    @NotNull
    public JpsJavaCompilerOptions getCurrentCompilerOptions() {
        JpsJavaCompilerOptions jpsJavaCompilerOptions = this.getCompilerOptions(this.getJavaCompilerId());
        if (jpsJavaCompilerOptions == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(14);
        }
        return jpsJavaCompilerOptions;
    }

    public void setProjectByteCodeTargetLevel(String level) {
        this.myProjectByteCodeTargetLevel = level;
    }

    public boolean useReleaseOption() {
        return this.myUseReleaseOption;
    }

    public void setUseReleaseOption(boolean useReleaseOption) {
        this.myUseReleaseOption = useReleaseOption;
    }

    public ProcessorConfigProfile addAnnotationProcessingProfile() {
        ProcessorConfigProfileImpl profile = new ProcessorConfigProfileImpl("");
        this.myAnnotationProcessingProfiles.add(profile);
        return profile;
    }

    @NotNull
    public ProcessorConfigProfile getAnnotationProcessingProfile(JpsModule module) {
        ProcessorConfigProfile profile;
        Map<JpsModule, ProcessorConfigProfile> map = this.myAnnotationProcessingProfileMap;
        if (map == null) {
            map = new HashMap<JpsModule, ProcessorConfigProfile>();
            HashMap<String, JpsModule> namesMap = new HashMap<String, JpsModule>();
            for (JpsModule m : module.getProject().getModules()) {
                namesMap.put(m.getName(), m);
            }
            if (!namesMap.isEmpty()) {
                for (ProcessorConfigProfile profile2 : this.getAnnotationProcessingProfiles()) {
                    for (String name : profile2.getModuleNames()) {
                        JpsModule mod = (JpsModule)namesMap.get(name);
                        if (mod == null) continue;
                        map.put(mod, profile2);
                    }
                }
            }
            this.myAnnotationProcessingProfileMap = map;
        }
        ProcessorConfigProfile processorConfigProfile = (profile = map.get(module)) != null ? profile : this.getDefaultAnnotationProcessingProfile();
        if (processorConfigProfile == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(15);
        }
        return processorConfigProfile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledValidators";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerExcludes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationExcludes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationConfiguration";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAnnotationProcessingProfile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessingProfiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaCompilerId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOptions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCompilerOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessingProfile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValidationConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResourceFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setJavaCompilerId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerOptions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCompilerOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

