/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PostponableLogRefresher
implements VcsLogRefresher {
    private static final Logger LOG = Logger.getInstance(PostponableLogRefresher.class);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Set<VirtualFile> myRootsToRefresh;
    @NotNull
    private final Set<VcsLogWindow> myLogWindows;

    public PostponableLogRefresher(@NotNull VcsLogData logData) {
        if (logData == null) {
            PostponableLogRefresher.$$$reportNull$$$0(0);
        }
        this.myRootsToRefresh = new HashSet<VirtualFile>();
        this.myLogWindows = new HashSet<VcsLogWindow>();
        this.myLogData = logData;
        this.myLogData.addDataPackChangeListener(dataPack -> {
            LOG.debug("Refreshing log windows " + this.myLogWindows);
            for (VcsLogWindow window : this.myLogWindows) {
                PostponableLogRefresher.dataPackArrived(window.getRefresher(), window.isVisible());
            }
        });
    }

    @NotNull
    public Disposable addLogWindow(@NotNull VcsLogWindow window) {
        if (window == null) {
            PostponableLogRefresher.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(!ContainerUtil.exists(this.myLogWindows, w -> w.getId().equals(window.getId())), (Object)("Log window with id '" + window.getId() + "' was already added."));
        this.myLogWindows.add(window);
        this.refresherActivated(window.getRefresher(), true);
        Disposable disposable = () -> {
            LOG.debug("Removing disposed log window " + window.toString());
            this.myLogWindows.remove(window);
        };
        if (disposable == null) {
            PostponableLogRefresher.$$$reportNull$$$0(2);
        }
        return disposable;
    }

    public static boolean keepUpToDate() {
        return Registry.is((String)"vcs.log.keep.up.to.date") && !PowerSaveMode.isEnabled();
    }

    private boolean canRefreshNow() {
        if (PostponableLogRefresher.keepUpToDate()) {
            return true;
        }
        return this.isLogVisible();
    }

    public boolean isLogVisible() {
        for (VcsLogWindow window : this.myLogWindows) {
            if (!window.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void refresherActivated(@NotNull VisiblePackRefresher refresher, boolean firstTime) {
        if (refresher == null) {
            PostponableLogRefresher.$$$reportNull$$$0(3);
        }
        this.myLogData.initialize();
        if (!this.myRootsToRefresh.isEmpty()) {
            this.refreshPostponedRoots();
        } else {
            refresher.setValid(true, firstTime);
        }
    }

    private static void dataPackArrived(@NotNull VisiblePackRefresher refresher, boolean visible) {
        if (refresher == null) {
            PostponableLogRefresher.$$$reportNull$$$0(4);
        }
        refresher.setValid(visible, true);
    }

    public void refresh(@NotNull VirtualFile root) {
        if (root == null) {
            PostponableLogRefresher.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.canRefreshNow()) {
                this.myLogData.refresh(Collections.singleton(root));
            } else {
                LOG.debug("Postponed refresh for " + root);
                this.myRootsToRefresh.add(root);
            }
        }, ModalityState.any());
    }

    private void refreshPostponedRoots() {
        HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>(this.myRootsToRefresh);
        this.myRootsToRefresh.removeAll(toRefresh);
        this.myLogData.refresh(toRefresh);
    }

    @NotNull
    public Set<VcsLogWindow> getLogWindows() {
        Set<VcsLogWindow> set = this.myLogWindows;
        if (set == null) {
            PostponableLogRefresher.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/PostponableLogRefresher";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/PostponableLogRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addLogWindow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addLogWindow";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refresherActivated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dataPackArrived";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VcsLogWindow {
        @NotNull
        private final String myId;
        @NotNull
        private final VisiblePackRefresher myRefresher;

        public VcsLogWindow(@NotNull String id, @NotNull VisiblePackRefresher refresher) {
            if (id == null) {
                VcsLogWindow.$$$reportNull$$$0(0);
            }
            if (refresher == null) {
                VcsLogWindow.$$$reportNull$$$0(1);
            }
            this.myId = id;
            this.myRefresher = refresher;
        }

        @NotNull
        public VisiblePackRefresher getRefresher() {
            VisiblePackRefresher visiblePackRefresher = this.myRefresher;
            if (visiblePackRefresher == null) {
                VcsLogWindow.$$$reportNull$$$0(2);
            }
            return visiblePackRefresher;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                VcsLogWindow.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            return "VcsLogWindow '" + this.myId + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refresher";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefresher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

