/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.CustomCommitterKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\f\u001a.\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\u0007\u00a2\u0006\u0002\b\u00100\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/commit/CustomCommitter;", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/vcs/changes/CommitSession;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/CommitSession;Ljava/util/List;Ljava/lang/String;)V", "resultHandlers", "", "Lcom/intellij/openapi/vcs/changes/CommitResultHandler;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addResultHandler", "", "resultHandler", "runCommit", "taskName", "intellij.platform.vcs.impl"})
public final class CustomCommitter {
    private final List<CommitResultHandler> resultHandlers;
    private final Project project;
    private final CommitSession session;
    private final List<Change> changes;
    private final String commitMessage;

    public final void addResultHandler(@NotNull CommitResultHandler resultHandler) {
        Intrinsics.checkParameterIsNotNull((Object)resultHandler, (String)"resultHandler");
        Collection collection = this.resultHandlers;
        boolean bl = false;
        collection.add(resultHandler);
    }

    public final void runCommit(@NotNull String taskName) {
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        new Task.Modal(this, taskName, this.project, UIUtil.removeMnemonic((String)taskName), true){
            final /* synthetic */ CustomCommitter this$0;
            final /* synthetic */ String $taskName;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                CustomCommitter.access$getSession$p(this.this$0).execute((Collection)CustomCommitter.access$getChanges$p(this.this$0), CustomCommitter.access$getCommitMessage$p(this.this$0));
            }

            public void onSuccess() {
                CustomCommitterKt.access$getLOG$p().debug("Commit successful");
                Iterable $this$forEach$iv = CustomCommitter.access$getResultHandlers$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    CommitResultHandler it = (CommitResultHandler)element$iv;
                    boolean bl = false;
                    it.onSuccess(CustomCommitter.access$getCommitMessage$p(this.this$0));
                }
            }

            public void onCancel() {
                CustomCommitterKt.access$getLOG$p().debug("Commit canceled");
                CustomCommitter.access$getSession$p(this.this$0).executionCanceled();
                Iterable $this$forEach$iv = CustomCommitter.access$getResultHandlers$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    CommitResultHandler it = (CommitResultHandler)element$iv;
                    boolean bl = false;
                    it.onCancel();
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                Messages.showErrorDialog((String)VcsBundle.message((String)"error.executing.commit", (Object[])new Object[]{this.$taskName, error.getLocalizedMessage()}), (String)this.$taskName);
                List errors = CollectionsKt.listOf((Object)((Object)new VcsException(error)));
                Iterable $this$forEach$iv = CustomCommitter.access$getResultHandlers$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    CommitResultHandler it = (CommitResultHandler)element$iv;
                    boolean bl = false;
                    it.onFailure(errors);
                }
            }
            {
                this.this$0 = $outer;
                this.$taskName = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    public CustomCommitter(@NotNull Project project, @NotNull CommitSession session, @NotNull List<? extends Change> changes, @NotNull String commitMessage2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)commitMessage2, (String)"commitMessage");
        this.project = project;
        this.session = session;
        this.changes = changes;
        this.commitMessage = commitMessage2;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"createLockFreeCopyOnWrit\u2026st<CommitResultHandler>()");
        this.resultHandlers = list;
    }

    public static final /* synthetic */ CommitSession access$getSession$p(CustomCommitter $this) {
        return $this.session;
    }

    public static final /* synthetic */ List access$getChanges$p(CustomCommitter $this) {
        return $this.changes;
    }

    public static final /* synthetic */ String access$getCommitMessage$p(CustomCommitter $this) {
        return $this.commitMessage;
    }

    public static final /* synthetic */ List access$getResultHandlers$p(CustomCommitter $this) {
        return $this.resultHandlers;
    }
}

