/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.ui;

import com.jetbrains.python.psi.PyClass;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class PyClassCellRenderer
extends DefaultListCellRenderer {
    private final boolean myShowReadOnly;

    public PyClassCellRenderer() {
        this.setOpaque(true);
        this.myShowReadOnly = true;
    }

    public PyClassCellRenderer(boolean showReadOnly) {
        this.setOpaque(true);
        this.myShowReadOnly = showReadOnly;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        return this.customizeRenderer(value, this.myShowReadOnly);
    }

    public JLabel customizeRenderer(Object value, boolean showReadOnly) {
        Icon icon;
        PyClass aClass = (PyClass)value;
        this.setText(PyClassCellRenderer.getClassText(aClass));
        int flags = 1;
        if (showReadOnly) {
            flags |= 2;
        }
        if ((icon = aClass.getIcon(flags)) != null) {
            this.setIcon(icon);
        }
        return this;
    }

    @Nullable
    public static String getClassText(PyClass aClass) {
        return aClass.getName();
    }
}

