/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.predict;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.jetbrains.changeReminder.UtilKt;
import com.jetbrains.changeReminder.predict.ProbabilityProvider;
import com.jetbrains.changeReminder.repository.Commit;
import com.jetbrains.changeReminder.repository.FilesHistoryProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ.\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/changeReminder/predict/FileProbabilityRequest;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "changeListFiles", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogData;Ljava/util/Collection;)V", "calculate", "", "candidate", "predict", "files", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "history", "Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;", "intellij.vcs.changeReminder"})
public final class FileProbabilityRequest {
    private final Project project;
    private final VcsLogData dataManager;
    private final Collection<FilePath> changeListFiles;

    private final double predict(FilePath candidate, Collection<? extends FilePath> files, VirtualFile root, FilesHistoryProvider history) {
        long l = System.currentTimeMillis();
        Object object = (VcsUser)this.dataManager.getCurrentUser().get(root);
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        Commit commit = new Commit(-1, l, (String)object, CollectionsKt.toSet((Iterable)this.changeListFiles));
        return ProbabilityProvider.INSTANCE.predict(commit, candidate, CollectionsKt.toSet((Iterable)history.getFilesHistory(root, files)));
    }

    /*
     * WARNING - void declaration
     */
    public final double calculate(@NotNull FilePath candidate) {
        void $this$mapNotNullTo$iv$iv;
        Map<VirtualFile, Collection<FilePath>> roots;
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        VcsLogIndex vcsLogIndex = this.dataManager.getIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogIndex, (String)"dataManager.index");
        IndexDataGetter indexDataGetter = vcsLogIndex.getDataGetter();
        if (indexDataGetter == null) {
            return 0.0;
        }
        IndexDataGetter indexDataGetter2 = indexDataGetter;
        boolean bl = false;
        boolean bl2 = false;
        Object it = indexDataGetter2;
        boolean bl3 = false;
        IndexDataGetter indexDataGetter3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)indexDataGetter3, (String)"it");
        FilesHistoryProvider history = new FilesHistoryProvider(this.project, this.dataManager, indexDataGetter3);
        Map<VirtualFile, Collection<FilePath>> $this$mapNotNull$iv = roots = UtilKt.getGitRootFiles(this.project, this.changeListFiles);
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var11_13 = $this$forEach$iv$iv$iv;
        boolean bl4 = false;
        Iterator iterator = var11_13.entrySet().iterator();
        while (iterator.hasNext()) {
            Double d;
            void root;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl5 = false;
            Map.Entry $dstr$root$files = element$iv$iv;
            boolean bl6 = false;
            Map.Entry entry = $dstr$root$files;
            boolean bl7 = false;
            VirtualFile virtualFile = (VirtualFile)entry.getKey();
            entry = $dstr$root$files;
            bl7 = false;
            Collection files = (Collection)entry.getValue();
            if ((this.dataManager.getIndex().isIndexed((VirtualFile)root) ? Double.valueOf(this.predict(candidate, files, (VirtualFile)root, history)) : null) == null) continue;
            d = d;
            boolean bl8 = false;
            boolean bl9 = false;
            Double it$iv$iv = d;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Double d = CollectionsKt.max((Iterable)((List)destination$iv$iv));
        return d != null ? d : 0.0;
    }

    public FileProbabilityRequest(@NotNull Project project, @NotNull VcsLogData dataManager, @NotNull Collection<? extends FilePath> changeListFiles) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataManager, (String)"dataManager");
        Intrinsics.checkParameterIsNotNull(changeListFiles, (String)"changeListFiles");
        this.project = project;
        this.dataManager = dataManager;
        this.changeListFiles = changeListFiles;
    }
}

