/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.cli;

import java.util.Scanner;

public class Terminal {
    private static final boolean useConsole = Boolean.valueOf(System.getProperty("cli.console", String.valueOf(System.console() != null)));
    private static final Scanner scanner = new Scanner(System.in);

    public void writeLine(String line) {
        if (useConsole) {
            System.console().writer().println(line);
            System.console().writer().flush();
        } else {
            System.out.println(line);
        }
    }

    public void write(String text) {
        if (useConsole) {
            System.console().writer().print(text);
            System.console().writer().flush();
        } else {
            System.out.print(text);
        }
    }

    public String readLine() {
        if (useConsole) {
            return System.console().readLine();
        }
        return scanner.next();
    }

    public char[] readSecret() {
        if (useConsole) {
            return System.console().readPassword();
        }
        return scanner.next().toCharArray();
    }
}

