/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.PluginHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@LogstashPlugin(name="java_generator")
public class Generator
implements Input {
    public static final PluginConfigSpec<Long> COUNT_CONFIG = PluginConfigSpec.numSetting("count", 0L);
    public static final PluginConfigSpec<List<Object>> LINES_CONFIG = PluginConfigSpec.arraySetting("lines");
    public static final PluginConfigSpec<String> MESSAGE_CONFIG = PluginConfigSpec.stringSetting("message", "Hello world!");
    public static final PluginConfigSpec<Long> THREADS_CONFIG = PluginConfigSpec.numSetting("threads", 1L);
    public static final PluginConfigSpec<Double> EPS_CONFIG = PluginConfigSpec.floatSetting("eps", 0.0);
    private final String hostname;
    private final long count;
    private final double eps;
    private String id;
    private long threads;
    private volatile boolean stopRequested = false;
    private final CountDownLatch countDownLatch;
    private String[] lines;
    private int[] linesIndex;
    private long[] sequence;
    private ScheduledFuture<?>[] futures;
    private List<Map<String, Object>> events;

    public Generator(String id, Configuration configuration, Context context) {
        String host;
        this.id = id;
        this.count = configuration.get(COUNT_CONFIG);
        this.eps = configuration.get(EPS_CONFIG);
        this.threads = configuration.get(THREADS_CONFIG);
        if (this.threads < 1L) {
            throw new IllegalStateException("May not specify fewer than one generator thread");
        }
        this.countDownLatch = new CountDownLatch((int)this.threads);
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "[unknownHost]";
        }
        this.hostname = host;
        List<Object> linesConfig = configuration.get(LINES_CONFIG);
        if (linesConfig != null) {
            this.lines = new String[linesConfig.size()];
            for (int k = 0; k < linesConfig.size(); ++k) {
                this.lines[k] = (String)linesConfig.get(k);
            }
        } else {
            this.lines = new String[]{configuration.get(MESSAGE_CONFIG)};
        }
    }

    @Override
    public void start(Consumer<Map<String, Object>> writer) {
        if (this.eps > 0.0) {
            this.startThrottledGenerator(writer);
        } else {
            this.startUnthrottledGenerator(writer);
        }
    }

    private void startUnthrottledGenerator(Consumer<Map<String, Object>> writer) {
        this.sequence = new long[(int)this.threads];
        this.events = new ArrayList<Map<String, Object>>();
        this.linesIndex = new int[(int)this.threads];
        int k = 0;
        while ((long)k < this.threads) {
            HashMap<String, Object> event = new HashMap<String, Object>();
            event.put("hostname", this.hostname);
            event.put("thread_number", k);
            this.events.add(event);
            if (k > 0) {
                int finalK = k;
                Thread t = new Thread(() -> {
                    while (this.runGenerator(writer, finalK, () -> this.countDownLatch.countDown())) {
                    }
                });
                t.setName("generator_" + this.getId() + "_" + k);
                t.start();
            }
            ++k;
        }
        while (this.runGenerator(writer, 0, () -> this.countDownLatch.countDown())) {
        }
    }

    private void startThrottledGenerator(Consumer<Map<String, Object>> writer) {
        ScheduledExecutorService ses = Executors.newScheduledThreadPool((int)this.threads);
        int delayMilli = (int)(1000.0 / this.eps);
        this.sequence = new long[(int)this.threads];
        this.futures = new ScheduledFuture[(int)this.threads];
        this.events = new ArrayList<Map<String, Object>>();
        this.linesIndex = new int[(int)this.threads];
        int k = 0;
        while ((long)k < this.threads) {
            HashMap<String, Object> event = new HashMap<String, Object>();
            event.put("hostname", this.hostname);
            event.put("thread_number", k);
            this.events.add(event);
            int finalk = k;
            this.futures[k] = ses.scheduleAtFixedRate(() -> this.runGenerator(writer, finalk, () -> {
                this.countDownLatch.countDown();
                this.futures[finalk].cancel(false);
            }), 0L, delayMilli, TimeUnit.MILLISECONDS);
            ++k;
        }
        boolean finished = false;
        while (!this.stopRequested && !finished) {
            try {
                Thread.sleep(1000L);
                boolean allCancelled = true;
                int k2 = 0;
                while ((long)k2 < this.threads) {
                    allCancelled = allCancelled && this.futures[k2].isCancelled();
                    ++k2;
                }
                if (!allCancelled) continue;
                finished = true;
                ses.shutdownNow();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean runGenerator(Consumer<Map<String, Object>> writer, int thread, Runnable finishAction) {
        if (this.stopRequested || this.count > 0L && this.sequence[thread] >= this.count) {
            finishAction.run();
            return false;
        }
        this.events.get(thread).put("sequence", this.sequence[thread]);
        int n = thread;
        int n2 = this.linesIndex[n];
        this.linesIndex[n] = n2 + 1;
        this.events.get(thread).put("message", this.lines[n2]);
        writer.accept(this.events.get(thread));
        if (this.linesIndex[thread] == this.lines.length) {
            this.linesIndex[thread] = 0;
            int n3 = thread;
            this.sequence[n3] = this.sequence[n3] + 1L;
        }
        return true;
    }

    @Override
    public void stop() {
        this.stopRequested = true;
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.countDownLatch.await();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return PluginHelper.commonInputSettings(Arrays.asList(COUNT_CONFIG, LINES_CONFIG, MESSAGE_CONFIG, THREADS_CONFIG, EPS_CONFIG));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

