/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.factory;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Plugin;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.common.EnvironmentVariableProvider;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.FilterDelegatorExt;
import org.logstash.config.ir.compiler.OutputDelegatorExt;
import org.logstash.config.ir.compiler.OutputStrategyExt;
import org.logstash.config.ir.compiler.RubyIntegration;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.execution.ExecutionContextExt;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.plugins.ConfigVariableExpander;
import org.logstash.plugins.PluginLookup;
import org.logstash.plugins.factory.AbstractPluginCreator;
import org.logstash.plugins.factory.CodecPluginCreator;
import org.logstash.plugins.factory.ExecutionContextFactoryExt;
import org.logstash.plugins.factory.FilterPluginCreator;
import org.logstash.plugins.factory.InputPluginCreator;
import org.logstash.plugins.factory.OutputPluginCreator;
import org.logstash.plugins.factory.PluginMetricsFactoryExt;

@JRubyClass(name={"PluginFactory"})
public final class PluginFactoryExt
extends RubyBasicObject
implements RubyIntegration.PluginFactory {
    private static final long serialVersionUID = 1L;
    private static final RubyString ID_KEY = RubyUtil.RUBY.newString("id");
    private final Collection<String> pluginsById = new HashSet<String>();
    private PipelineIR lir;
    private ExecutionContextFactoryExt executionContextFactory;
    private PluginMetricsFactoryExt metrics;
    private RubyClass filterClass;
    private ConfigVariableExpander configVariables;
    private PluginResolver pluginResolver;
    private Map<PluginLookup.PluginType, AbstractPluginCreator<? extends Plugin>> pluginCreatorsRegistry = new HashMap<PluginLookup.PluginType, AbstractPluginCreator<? extends Plugin>>(4);

    @JRubyMethod(name={"filter_delegator"}, meta=true, required=5)
    public static IRubyObject filterDelegator(ThreadContext context, IRubyObject recv, IRubyObject ... args) {
        RubyHash arguments = (RubyHash)args[2];
        IRubyObject filterInstance = args[1].callMethod(context, "new", (IRubyObject)arguments);
        RubyString id = (RubyString)arguments.op_aref(context, (IRubyObject)ID_KEY);
        filterInstance.callMethod(context, "metric=", (IRubyObject)((AbstractMetricExt)args[3]).namespace(context, (IRubyObject)id.intern()));
        filterInstance.callMethod(context, "execution_context=", args[4]);
        return new FilterDelegatorExt(context.runtime, RubyUtil.FILTER_DELEGATOR_CLASS).initialize(context, filterInstance, (IRubyObject)id);
    }

    public PluginFactoryExt(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, PluginLookup::lookup);
    }

    PluginFactoryExt(Ruby runtime, RubyClass metaClass, PluginResolver pluginResolver) {
        super(runtime, metaClass);
        this.pluginResolver = pluginResolver;
    }

    @JRubyMethod(required=4)
    public PluginFactoryExt initialize(ThreadContext context, IRubyObject[] args) {
        return this.init((PipelineIR)args[0].toJava(PipelineIR.class), (PluginMetricsFactoryExt)args[1], (ExecutionContextFactoryExt)args[2], (RubyClass)args[3]);
    }

    public PluginFactoryExt init(PipelineIR lir, PluginMetricsFactoryExt metrics, ExecutionContextFactoryExt executionContextFactoryExt, RubyClass filterClass) {
        return this.init(lir, metrics, executionContextFactoryExt, filterClass, EnvironmentVariableProvider.defaultProvider());
    }

    PluginFactoryExt init(PipelineIR lir, PluginMetricsFactoryExt metrics, ExecutionContextFactoryExt executionContextFactoryExt, RubyClass filterClass, EnvironmentVariableProvider envVars) {
        this.lir = lir;
        this.metrics = metrics;
        this.executionContextFactory = executionContextFactoryExt;
        this.filterClass = filterClass;
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.INPUT, new InputPluginCreator(this));
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.CODEC, new CodecPluginCreator());
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.FILTER, new FilterPluginCreator());
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.OUTPUT, new OutputPluginCreator(this));
        this.configVariables = ConfigVariableExpander.withoutSecret(envVars);
        return this;
    }

    @Override
    public IRubyObject buildInput(RubyString name, SourceWithMetadata source, IRubyObject args, Map<String, Object> pluginArgs) {
        return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.INPUT, name.asJavaString(), source, (Map)args, pluginArgs);
    }

    @Override
    public AbstractOutputDelegatorExt buildOutput(RubyString name, SourceWithMetadata source, IRubyObject args, Map<String, Object> pluginArgs) {
        return (AbstractOutputDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.OUTPUT, name.asJavaString(), source, (Map)args, pluginArgs);
    }

    @Override
    public AbstractFilterDelegatorExt buildFilter(RubyString name, SourceWithMetadata source, IRubyObject args, Map<String, Object> pluginArgs) {
        return (AbstractFilterDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.FILTER, name.asJavaString(), source, (Map)args, pluginArgs);
    }

    @Override
    public IRubyObject buildCodec(RubyString name, SourceWithMetadata source, IRubyObject args, Map<String, Object> pluginArgs) {
        return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.CODEC, name.asJavaString(), source, (Map)args, pluginArgs);
    }

    @Override
    public Codec buildDefaultCodec(String codecName) {
        return (Codec)JavaUtil.unwrapJavaValue((IRubyObject)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.CODEC, codecName, null, Collections.emptyMap(), Collections.emptyMap()));
    }

    @JRubyMethod(required=3, optional=1)
    public IRubyObject plugin(ThreadContext context, IRubyObject[] args) {
        return this.plugin(context, PluginLookup.PluginType.valueOf(args[0].asJavaString().toUpperCase(Locale.ENGLISH)), args[1].asJavaString(), (SourceWithMetadata)JavaUtil.unwrapIfJavaObject((IRubyObject)args[2]), args.length > 3 ? (Map)args[3] : new HashMap(), null);
    }

    private IRubyObject plugin(ThreadContext context, PluginLookup.PluginType type, String name, SourceWithMetadata source, Map<String, IRubyObject> args, Map<String, Object> pluginArgs) {
        String id = this.generateOrRetrievePluginId(context, type, name, source);
        this.pluginsById.add(id);
        AbstractNamespacedMetricExt typeScopedMetric = this.metrics.create(context, (IRubyObject)type.rubyLabel());
        PluginLookup.PluginClass pluginClass = this.pluginResolver.resolve(type, name);
        if (pluginClass.language() == PluginLookup.PluginLanguage.RUBY) {
            HashMap<String, IRubyObject> newArgs = new HashMap<String, IRubyObject>(args);
            newArgs.put("id", (IRubyObject)id);
            RubyClass klass = (RubyClass)pluginClass.klass();
            ExecutionContextExt executionCntx = this.executionContextFactory.create(context, (IRubyObject)RubyUtil.RUBY.newString(id), klass.callMethod(context, "config_name"));
            RubyHash rubyArgs = RubyHash.newHash((Ruby)context.runtime);
            rubyArgs.putAll(newArgs);
            if (type == PluginLookup.PluginType.OUTPUT) {
                return new OutputDelegatorExt(context.runtime, RubyUtil.RUBY_OUTPUT_DELEGATOR_CLASS).initialize(context, new IRubyObject[]{klass, typeScopedMetric, executionCntx, OutputStrategyExt.OutputStrategyRegistryExt.instance(context, null), rubyArgs});
            }
            if (type == PluginLookup.PluginType.FILTER) {
                return PluginFactoryExt.filterDelegator(context, null, new IRubyObject[]{this.filterClass, klass, rubyArgs, typeScopedMetric, executionCntx});
            }
            IRubyObject pluginInstance = klass.callMethod(context, "new", (IRubyObject)rubyArgs);
            AbstractNamespacedMetricExt scopedMetric = typeScopedMetric.namespace(context, (IRubyObject)RubyUtil.RUBY.newSymbol(id));
            scopedMetric.gauge(context, (IRubyObject)MetricKeys.NAME_KEY, pluginInstance.callMethod(context, "config_name"));
            pluginInstance.callMethod(context, "metric=", (IRubyObject)scopedMetric);
            pluginInstance.callMethod(context, "execution_context=", (IRubyObject)executionCntx);
            return pluginInstance;
        }
        if (pluginArgs == null) {
            String err = String.format("Cannot start the Java plugin '%s' in the Ruby execution engine. The Java execution engine is required to run Java plugins.", name);
            throw new IllegalStateException(err);
        }
        AbstractPluginCreator<? extends Plugin> pluginCreator = this.pluginCreatorsRegistry.get((Object)type);
        if (pluginCreator == null) {
            throw new IllegalStateException("Unable to create plugin: " + pluginClass.toReadableString());
        }
        Context contextWithMetrics = this.executionContextFactory.toContext(type, this.metrics.getRoot(context));
        return pluginCreator.createDelegator(name, pluginArgs, id, typeScopedMetric, pluginClass, contextWithMetrics);
    }

    private String generateOrRetrievePluginId(ThreadContext context, PluginLookup.PluginType type, String name, SourceWithMetadata source) {
        String id;
        if (type == PluginLookup.PluginType.CODEC) {
            id = UUID.randomUUID().toString();
        } else {
            String unresolvedId = this.lir.getGraph().vertices().filter(v -> v.getSourceWithMetadata() != null && v.getSourceWithMetadata().equalsWithoutText(source)).findFirst().map(Vertex::getId).orElse(null);
            id = (String)this.configVariables.expand(unresolvedId);
        }
        if (id == null) {
            throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Could not determine ID for %s/%s", type.rubyLabel().asJavaString(), name));
        }
        if (this.pluginsById.contains(id)) {
            throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Two plugins have the id '%s', please fix this conflict", id));
        }
        return id;
    }

    ExecutionContextFactoryExt getExecutionContextFactory() {
        return this.executionContextFactory;
    }

    @FunctionalInterface
    public static interface PluginResolver {
        public PluginLookup.PluginClass resolve(PluginLookup.PluginType var1, String var2);
    }
}

