/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;

@JRubyClass(name={"AbstractOutputDelegator"})
public abstract class AbstractOutputDelegatorExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    public static final String OUTPUT_METHOD_NAME = "multi_receive";
    private AbstractMetricExt metric;
    protected AbstractNamespacedMetricExt namespacedMetric;
    private AbstractNamespacedMetricExt metricEvents;
    private RubyString id;
    private LongCounter eventMetricOut;
    private LongCounter eventMetricIn;
    private LongCounter eventMetricTime;

    public AbstractOutputDelegatorExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public IRubyObject register(ThreadContext context) {
        this.doRegister(context);
        return context.nil;
    }

    @JRubyMethod(name={"do_close"})
    public IRubyObject doClose(ThreadContext context) {
        this.close(context);
        return context.nil;
    }

    @JRubyMethod(name={"reloadable?"})
    public IRubyObject isReloadable(ThreadContext context) {
        return this.reloadable(context);
    }

    @JRubyMethod
    public IRubyObject concurrency(ThreadContext context) {
        return this.getConcurrency(context);
    }

    @JRubyMethod(name={"config_name"})
    public IRubyObject configName(ThreadContext context) {
        return this.getConfigName(context);
    }

    @JRubyMethod(name={"id"})
    public IRubyObject getId() {
        return this.id;
    }

    @JRubyMethod
    public IRubyObject metric() {
        return this.metric;
    }

    @JRubyMethod(name={"namespaced_metric"})
    public IRubyObject namespacedMetric() {
        return this.namespacedMetric;
    }

    @JRubyMethod(name={"metric_events"})
    public IRubyObject metricEvents() {
        return this.metricEvents;
    }

    @JRubyMethod(name={"multi_receive"})
    public IRubyObject multiReceive(IRubyObject events) {
        RubyArray batch = (RubyArray)events;
        int count = batch.size();
        this.eventMetricIn.increment(count);
        long start = System.nanoTime();
        this.doOutput((Collection<JrubyEventExtLibrary.RubyEvent>)batch);
        this.eventMetricTime.increment(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        this.eventMetricOut.increment(count);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMetrics(String id, AbstractMetricExt metric) {
        this.metric = metric;
        ThreadContext context = RubyUtil.RUBY.getCurrentContext();
        this.id = RubyString.newString((Ruby)context.runtime, (String)id);
        AbstractMetricExt abstractMetricExt = metric;
        synchronized (abstractMetricExt) {
            this.namespacedMetric = metric.namespace(context, (IRubyObject)context.runtime.newSymbol(id));
            this.metricEvents = this.namespacedMetric.namespace(context, (IRubyObject)MetricKeys.EVENTS_KEY);
            this.namespacedMetric.gauge(context, (IRubyObject)MetricKeys.NAME_KEY, this.configName(context));
            this.eventMetricOut = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.OUT_KEY);
            this.eventMetricIn = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.IN_KEY);
            this.eventMetricTime = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.DURATION_IN_MILLIS_KEY);
        }
    }

    protected abstract IRubyObject getConfigName(ThreadContext var1);

    protected abstract IRubyObject getConcurrency(ThreadContext var1);

    protected abstract void doOutput(Collection<JrubyEventExtLibrary.RubyEvent> var1);

    protected abstract void close(ThreadContext var1);

    protected abstract void doRegister(ThreadContext var1);

    protected abstract IRubyObject reloadable(ThreadContext var1);
}

