/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.Event;
import org.logstash.ackedqueue.Checkpoint;
import org.logstash.ackedqueue.io.CheckpointIO;
import org.logstash.ackedqueue.io.FileCheckpointIO;
import org.logstash.ackedqueue.io.MmapPageIOV1;
import org.logstash.ackedqueue.io.PageIO;

public final class QueueUpgrade {
    private static final Logger LOGGER = LogManager.getLogger(QueueUpgrade.class);
    private static final Pattern PAGE_NAME_PATTERN = Pattern.compile("page\\.\\d+");

    private QueueUpgrade() {
    }

    public static void upgradeQueueDirectoryToV2(Path path) throws IOException {
        File upgradeFile = path.resolve(".queue-version").toFile();
        if (upgradeFile.exists()) {
            if (Ints.fromByteArray((byte[])Files.readAllBytes(upgradeFile.toPath())) != 2) {
                throw new IllegalStateException("Unexpected upgrade file contents found.");
            }
            LOGGER.debug("PQ version file with correct version information (v2) found.");
        } else {
            LOGGER.info("No PQ version file found, upgrading to PQ v2.");
            try (DirectoryStream<Path> files = Files.newDirectoryStream(path);){
                Collection pageFiles = StreamSupport.stream(files.spliterator(), false).filter(file -> PAGE_NAME_PATTERN.matcher(file.getFileName().toString()).matches()).map(Path::toFile).collect(Collectors.toList());
                FileCheckpointIO cpIo = new FileCheckpointIO(path);
                pageFiles.forEach(p -> QueueUpgrade.validatePageFile(path, cpIo, p));
                pageFiles.forEach(QueueUpgrade::setV2);
            }
            Files.write(upgradeFile.toPath(), Ints.toByteArray((int)2), StandardOpenOption.CREATE);
        }
    }

    private static void validatePageFile(Path path, CheckpointIO cpIo, File v1PageFile) {
        int num = Integer.parseInt(v1PageFile.getName().substring("page.".length()));
        try (MmapPageIOV1 iov1 = new MmapPageIOV1(num, Ints.checkedCast((long)v1PageFile.length()), path);){
            Checkpoint cp = QueueUpgrade.loadCheckpoint(path, cpIo, num);
            int count = cp.getElementCount();
            long minSeqNum = cp.getMinSeqNum();
            iov1.open(minSeqNum, count);
            for (int i = 0; i < count; ++i) {
                QueueUpgrade.verifyEvent(iov1, minSeqNum + (long)i);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void verifyEvent(PageIO iov1, long seqNum) {
        try {
            Event.deserialize(iov1.read(seqNum, 1).getElements().get(0));
        }
        catch (IOException ex) {
            QueueUpgrade.failValidation(ex);
        }
    }

    private static void setV2(File v1PageFile) {
        try (RandomAccessFile raf = new RandomAccessFile(v1PageFile, "rw");){
            raf.seek(0L);
            raf.writeByte(2);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Checkpoint loadCheckpoint(Path path, CheckpointIO cpIo, int num) throws IOException {
        Checkpoint cp;
        String cpFilename = cpIo.tailFileName(num);
        if (path.resolve(cpFilename).toFile().exists()) {
            cp = cpIo.read(cpFilename);
        } else {
            cp = cpIo.read("checkpoint.head");
            if (cp.getPageNum() != num) {
                throw new IllegalStateException(String.format("No checkpoint file found for page %d", num));
            }
        }
        return cp;
    }

    private static void failValidation(Throwable ex) {
        LOGGER.error("Logstash was unable to upgrade your persistent queue data.Please either downgrade to your previous version of Logstash and fully drain your persistent queue or delete your queue data.dir if you don't need to retain the data currently in your queue.");
        throw new IllegalStateException(ex);
    }
}

