/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ServerName {
    private final short nameType;
    private final byte[] nameData;

    public ServerName(short s, Object object) {
        byte[] byArray;
        if (null == object) {
            throw new NullPointerException("'name' cannot be null");
        }
        switch (s) {
            case 0: {
                if (object instanceof String) {
                    String string = (String)object;
                    byArray = Strings.toUTF8ByteArray((String)string);
                    break;
                }
                throw new IllegalArgumentException("'name' is not an instance of a supported type");
            }
            default: {
                throw new IllegalArgumentException("'nameType' is an unsupported NameType");
            }
        }
        if (byArray.length < 1 || !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'name' must have length from 1 to 65535");
        }
        this.nameType = s;
        this.nameData = byArray;
    }

    public ServerName(short s, byte[] byArray) {
        if (!TlsUtils.isValidUint8(s)) {
            throw new IllegalArgumentException("'nameType' must be from 0 to 255");
        }
        if (null == byArray) {
            throw new NullPointerException("'nameData' cannot be null");
        }
        if (byArray.length < 1 || !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'nameData' must have length from 1 to 65535");
        }
        this.nameType = s;
        this.nameData = byArray;
    }

    public short getNameType() {
        return this.nameType;
    }

    public byte[] getNameData() {
        return this.nameData;
    }

    public String getHostName() {
        if (0 != this.nameType) {
            throw new IllegalStateException("Not of type host_name");
        }
        return Strings.fromUTF8ByteArray((byte[])this.nameData);
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.nameType, outputStream);
        TlsUtils.writeOpaque16(this.nameData, outputStream);
    }

    public static ServerName parse(InputStream inputStream) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        return new ServerName(s, byArray);
    }
}

