/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertPathParameters;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTrustManagerFactorySpi
extends TrustManagerFactorySpi {
    private static final Logger LOG = Logger.getLogger(ProvTrustManagerFactorySpi.class.getName());
    protected final Provider pkixProvider;
    protected ProvX509TrustManager x509TrustManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStore getDefaultTrustStore() throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string = KeyStore.getDefaultType();
        Object object4 = null;
        char[] cArray = null;
        String string2 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStore");
        if (!"NONE".equals(string2)) {
            if (null != string2) {
                if (new File(string2).exists()) {
                    object4 = string2;
                }
            } else {
                object3 = PropertyUtils.getSystemProperty("java.home");
                if (null != object3) {
                    object2 = (String)object3 + "/lib/security/jssecacerts".replace("/", File.separator);
                    if (new File((String)object2).exists()) {
                        string = "jks";
                        object4 = object2;
                    } else {
                        object = (String)object3 + "/lib/security/cacerts".replace("/", File.separator);
                        if (new File((String)object).exists()) {
                            string = "jks";
                            object4 = object;
                        }
                    }
                }
            }
        }
        object3 = ProvTrustManagerFactorySpi.createTrustStore(string);
        object2 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStorePassword");
        if (null != object2) {
            cArray = ((String)object2).toCharArray();
        }
        object = null;
        try {
            if (null == object4) {
                LOG.info("Initializing empty trust store");
            } else {
                LOG.info("Initializing with trust store at path: " + (String)object4);
                object = new BufferedInputStream(new FileInputStream((String)object4));
            }
            ((KeyStore)object3).load((InputStream)object, cArray);
        }
        finally {
            if (null != object) {
                ((InputStream)object).close();
            }
        }
        return object3;
    }

    ProvTrustManagerFactorySpi(Provider provider) {
        this.pkixProvider = provider;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        if (null == this.x509TrustManager) {
            throw new IllegalStateException("TrustManagerFactory not initialized");
        }
        return new TrustManager[]{this.x509TrustManager.getExportX509TrustManager()};
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        if (null == keyStore) {
            try {
                keyStore = ProvTrustManagerFactorySpi.getDefaultTrustStore();
            }
            catch (SecurityException securityException) {
                LOG.log(Level.WARNING, "Skipped default trust store", securityException);
            }
            catch (Error error) {
                LOG.log(Level.WARNING, "Skipped default trust store", error);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                LOG.log(Level.WARNING, "Skipped default trust store", runtimeException);
                throw runtimeException;
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Skipped default trust store", exception);
                throw new KeyStoreException("Failed to load default\u00a0trust store", exception);
            }
        }
        Set<TrustAnchor> set = ProvTrustManagerFactorySpi.getTrustAnchors(keyStore);
        try {
            this.x509TrustManager = new ProvX509TrustManager(this.pkixProvider, set);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KeyStoreException("Failed to create trust manager", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof CertPathTrustManagerParameters) {
            try {
                CertPathParameters certPathParameters = ((CertPathTrustManagerParameters)managerFactoryParameters).getParameters();
                if (!(certPathParameters instanceof PKIXParameters)) {
                    throw new InvalidAlgorithmParameterException("parameters must inherit from PKIXParameters");
                }
                PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
                this.x509TrustManager = new ProvX509TrustManager(this.pkixProvider, pKIXParameters);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidAlgorithmParameterException("unable to process parameters: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        } else {
            if (managerFactoryParameters == null) {
                throw new InvalidAlgorithmParameterException("spec cannot be null");
            }
            throw new InvalidAlgorithmParameterException("unknown spec: " + managerFactoryParameters.getClass().getName());
        }
    }

    private static KeyStore createTrustStore(String string) throws NoSuchProviderException, KeyStoreException {
        String string2 = ProvTrustManagerFactorySpi.getTrustStoreType(string);
        String string3 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStoreProvider");
        return null == string3 || string3.length() < 1 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
    }

    private static Set<TrustAnchor> getTrustAnchors(KeyStore keyStore) throws KeyStoreException {
        if (null == keyStore) {
            return Collections.emptySet();
        }
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>(keyStore.size());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            hashSet.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        return hashSet;
    }

    private static String getTrustStoreType(String string) {
        String string2 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStoreType");
        return null == string2 ? string : string2;
    }
}

