/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.FileDataSourceImpl;
import com.googlecode.mp4parser.MultiFileDataSourceImpl;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.builder.DefaultMp4Builder;
import com.googlecode.mp4parser.authoring.tracks.AbstractH26XTrack;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderSpecificInfo;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Mp4Arrays;
import com.googlecode.mp4parser.util.Path;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H263TrackImpl
extends AbstractH26XTrack {
    private static Logger LOG = Logger.getLogger(ESDescriptor.class.getName());
    int RECTANGULAR = 0;
    int BINARY = 1;
    int BINARY_ONLY = 2;
    int GRAYSCALE = 3;
    SampleDescriptionBox stsd;
    List<Sample> samples = new ArrayList<Sample>();
    List<ByteBuffer> esdsStuff = new ArrayList<ByteBuffer>();
    boolean esdsComplete = false;
    int fixed_vop_time_increment = -1;
    int vop_time_increment_resolution = 0;

    public H263TrackImpl(DataSource dataSource) throws IOException {
        super(dataSource, false);
        ByteBuffer nal;
        AbstractH26XTrack.LookAhead la = new AbstractH26XTrack.LookAhead(dataSource);
        ArrayList<ByteBuffer> nalsInSample = new ArrayList<ByteBuffer>();
        int visual_object_verid = 0;
        VisualSampleEntry mp4v = new VisualSampleEntry("mp4v");
        this.stsd = new SampleDescriptionBox();
        this.stsd.addBox(mp4v);
        long last_sync_point = 0L;
        long last_time_code = -1L;
        while ((nal = this.findNextNal(la)) != null) {
            ByteBuffer origNal = nal.duplicate();
            int type = IsoTypeReader.readUInt8(nal);
            if (type == 176 || type == 181 || type == 0 || type == 32 || type == 178) {
                if (this.esdsComplete) continue;
                this.esdsStuff.add(origNal);
                if (type == 32) {
                    this.parse0x20Unit(nal, visual_object_verid, mp4v);
                    continue;
                }
                if (type != 181) continue;
                visual_object_verid = this.parse0x05Unit(nal);
                continue;
            }
            if (type == 179) {
                this.esdsComplete = true;
                BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(nal);
                int time_code = bitReaderBuffer.readBits(18);
                last_sync_point = (time_code & 0x3F) + (time_code >>> 7 & 0x3F) * 60 + (time_code >>> 13 & 0x1F) * 60 * 60;
                this.stss.add(this.samples.size() + 1);
                nalsInSample.add(origNal);
                continue;
            }
            if (type == 182) {
                BitReaderBuffer brb = new BitReaderBuffer(nal);
                brb.readBits(2);
                while (brb.readBool()) {
                    ++last_sync_point;
                }
                brb.readBool();
                int i = 0;
                while (this.vop_time_increment_resolution >= 1 << i) {
                    ++i;
                }
                int vop_time_increment = brb.readBits(i);
                long time_code = last_sync_point * (long)this.vop_time_increment_resolution + (long)(vop_time_increment % this.vop_time_increment_resolution);
                if (last_time_code != -1L) {
                    this.decodingTimes = Mp4Arrays.copyOfAndAppend(this.decodingTimes, time_code - last_time_code);
                }
                System.err.println("Frame increment: " + (time_code - last_time_code) + " vop time increment: " + vop_time_increment + " last_sync_point: " + last_sync_point + " time_code: " + time_code);
                last_time_code = time_code;
                nalsInSample.add(origNal);
                this.samples.add(this.createSampleObject(nalsInSample));
                nalsInSample.clear();
                continue;
            }
            throw new RuntimeException("Got start code I don't know. Ask Sebastian via mp4parser mailing list what to do");
        }
        this.decodingTimes = Mp4Arrays.copyOfAndAppend(this.decodingTimes, this.decodingTimes[this.decodingTimes.length - 1]);
        ESDescriptor esDescriptor = new ESDescriptor();
        esDescriptor.setEsId(1);
        DecoderConfigDescriptor decoderConfigDescriptor = new DecoderConfigDescriptor();
        decoderConfigDescriptor.setObjectTypeIndication(32);
        decoderConfigDescriptor.setStreamType(4);
        DecoderSpecificInfo decoderSpecificInfo = new DecoderSpecificInfo();
        Sample s = this.createSampleObject(this.esdsStuff);
        byte[] data = new byte[CastUtils.l2i(s.getSize())];
        s.asByteBuffer().get(data);
        decoderSpecificInfo.setData(data);
        decoderConfigDescriptor.setDecoderSpecificInfo(decoderSpecificInfo);
        esDescriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
        SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
        slConfigDescriptor.setPredefined(2);
        esDescriptor.setSlConfigDescriptor(slConfigDescriptor);
        ESDescriptorBox esds = new ESDescriptorBox();
        esds.setEsDescriptor(esDescriptor);
        mp4v.addBox(esds);
        this.trackMetaData.setTimescale(this.vop_time_increment_resolution);
    }

    private int parse0x05Unit(ByteBuffer nal) {
        int visual_object_verid = 0;
        BitReaderBuffer brb = new BitReaderBuffer(nal);
        boolean is_visual_object_identifier = brb.readBool();
        if (is_visual_object_identifier) {
            visual_object_verid = brb.readBits(4);
            brb.readBits(3);
        }
        return visual_object_verid;
    }

    private void parse0x20Unit(ByteBuffer nal, int visual_object_verid, VisualSampleEntry mp4v) {
        int video_object_layer_shape;
        boolean vol_control_parameters;
        int aspect_ratio_info;
        BitReaderBuffer brb = new BitReaderBuffer(nal);
        brb.readBool();
        brb.readBits(8);
        boolean is_object_layer_identifier = brb.readBool();
        int video_object_layer_verid = visual_object_verid;
        if (is_object_layer_identifier) {
            video_object_layer_verid = brb.readBits(4);
            brb.readBits(3);
        }
        if ((aspect_ratio_info = brb.readBits(4)) == 15) {
            brb.readBits(8);
            brb.readBits(8);
        }
        if (vol_control_parameters = brb.readBool()) {
            brb.readBits(2);
            brb.readBool();
            boolean vbv_parameters = brb.readBool();
            if (vbv_parameters) {
                throw new RuntimeException("Implemented when needed");
            }
        }
        if ((video_object_layer_shape = brb.readBits(2)) == this.GRAYSCALE && video_object_layer_verid != 1) {
            brb.readBits(4);
        }
        brb.readBool();
        this.vop_time_increment_resolution = brb.readBits(16);
        brb.readBool();
        boolean fixed_vop_rate = brb.readBool();
        if (fixed_vop_rate) {
            LOG.info("Fixed Frame Rate");
            int i = 0;
            while (this.vop_time_increment_resolution >= 1 << i) {
                ++i;
            }
            this.fixed_vop_time_increment = brb.readBits(i);
        }
        if (video_object_layer_shape != this.BINARY_ONLY) {
            if (video_object_layer_shape == this.RECTANGULAR) {
                brb.readBool();
                int video_object_layer_width = brb.readBits(13);
                mp4v.setWidth(video_object_layer_width);
                brb.readBool();
                int video_object_layer_height = brb.readBits(13);
                mp4v.setHeight(video_object_layer_height);
                brb.readBool();
            }
        } else {
            throw new RuntimeException("Please implmenet me");
        }
    }

    @Override
    protected Sample createSampleObject(List<? extends ByteBuffer> nals) {
        byte[] byArray = new byte[3];
        byArray[2] = 1;
        ByteBuffer startcode = ByteBuffer.wrap(byArray);
        ByteBuffer[] data = new ByteBuffer[nals.size() * 2];
        int i = 0;
        while (i < nals.size()) {
            data[2 * i] = startcode;
            data[2 * i + 1] = nals.get(i);
            ++i;
        }
        return new SampleImpl(data);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    public static void main1(String[] args) throws IOException {
        Object[] files = new File("C:\\dev\\mp4parser\\frames").listFiles();
        Arrays.sort(files);
        Movie m = new Movie();
        H263TrackImpl track = new H263TrackImpl(new MultiFileDataSourceImpl((File[])files));
        m.addTrack(track);
        DefaultMp4Builder builder = new DefaultMp4Builder();
        Container c = builder.build(m);
        FileOutputStream fos = new FileOutputStream("output.mp4");
        c.writeContainer(Channels.newChannel(fos));
    }

    public static void main(String[] args) throws IOException {
        FileDataSourceImpl ds = new FileDataSourceImpl("C:\\content\\bbb.h263");
        Movie m = new Movie();
        H263TrackImpl track = new H263TrackImpl(ds);
        m.addTrack(track);
        DefaultMp4Builder builder = new DefaultMp4Builder();
        Container c = builder.build(m);
        FileOutputStream fos = new FileOutputStream("output.mp4");
        c.writeContainer(Channels.newChannel(fos));
    }

    public static void main2(String[] args) throws IOException {
        ESDescriptorBox esds = (ESDescriptorBox)Path.getPath(new IsoFile("C:\\content\\bbb.mp4"), "/moov[0]/trak[0]/mdia[0]/minf[0]/stbl[0]/stsd[0]/mp4v[0]/esds[0]");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        esds.getBox(Channels.newChannel(baos));
        System.err.println(Hex.encodeHex(baos.toByteArray()));
        System.err.println(esds.getEsDescriptor());
        baos = new ByteArrayOutputStream();
        esds.getBox(Channels.newChannel(baos));
        System.err.println(Hex.encodeHex(baos.toByteArray()));
    }
}

