/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;

@BuiltinFunction(value={"contains/1"})
public class ContainsFunction
implements Function {
    private static final JsonNodeComparator COMPARATOR = JsonNodeComparator.getInstance();

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode value : args.get(0).apply(scope, in)) {
            if (in.getNodeType() != value.getNodeType() || in.isBoolean() && in.asBoolean() != value.asBoolean()) {
                throw JsonQueryTypeException.format("%s (%s) and %s (%s) cannot have their containment checked", in.getNodeType(), in, value.getNodeType(), value);
            }
            out.add((JsonNode)BooleanNode.valueOf((boolean)ContainsFunction.contains(value, in)));
        }
        return out;
    }

    private static boolean contains(JsonNode needle, JsonNode haystack) throws JsonQueryException {
        if (haystack.isTextual() && needle.isTextual()) {
            return haystack.asText().contains(needle.asText());
        }
        if (haystack.isArray() && needle.isArray()) {
            for (JsonNode n : needle) {
                boolean found = false;
                for (JsonNode h : haystack) {
                    if (!ContainsFunction.contains(n, h)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        if (haystack.isObject() && needle.isObject()) {
            Iterator iter = needle.fields();
            while (iter.hasNext()) {
                Map.Entry field = (Map.Entry)iter.next();
                JsonNode tmp = haystack.get((String)field.getKey());
                if (tmp == null) {
                    return false;
                }
                if (ContainsFunction.contains((JsonNode)field.getValue(), tmp)) continue;
                return false;
            }
            return true;
        }
        return COMPARATOR.compare(haystack, needle) == 0;
    }
}

