(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/actor/rpc/proto/cookie#challenge-digest
    std/crypto/digest#digest::sha256)
  (define std/actor/rpc/proto/cookie#challenge-length
    (std/crypto/digest#digest-size
     std/actor/rpc/proto/cookie#challenge-digest))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-accept
    (lambda (_ibuf203667_ _obuf203668_ _cookie203669_)
      (std/actor/rpc/proto/null#rpc-proto-accept-e
       _ibuf203667_
       _obuf203668_
       std/actor/rpc/proto/message#rpc-proto-cookie
       (lambda (_ibuf203671_ _obuf203672_)
         (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge
          _ibuf203671_
          _obuf203672_
          _cookie203669_)
         (values std/actor/rpc/proto/null#rpc-null-proto-read
                 std/actor/rpc/proto/null#rpc-null-proto-write)))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-connect
    (lambda (_ibuf203658_ _obuf203659_ _cookie203660_)
      (std/actor/rpc/proto/null#rpc-proto-connect-e
       _ibuf203658_
       _obuf203659_
       std/actor/rpc/proto/message#rpc-proto-cookie
       (lambda (_ibuf203662_ _obuf203663_)
         (let ((_e203665_ (std/net/bio/input#bio-read-u8 _ibuf203662_)))
           (if (eq? _e203665_ std/actor/rpc/proto/message#rpc-proto-challenge)
               (begin
                 (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge-respond
                  _ibuf203662_
                  _obuf203663_
                  _cookie203660_)
                 (values std/actor/rpc/proto/null#rpc-null-proto-read
                         std/actor/rpc/proto/null#rpc-null-proto-write))
               (if (eof-object? _e203665_)
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"connection closed")
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"bad hello"
                    _e203665_))))))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge
    (lambda (_ibuf203641_ _obuf203642_ _cookie203643_)
      (std/net/bio/output#bio-write-u8
       std/actor/rpc/proto/message#rpc-proto-challenge
       _obuf203642_)
      (let ((_challenge203645_
             (std/crypto/etc#random-bytes
              std/actor/rpc/proto/cookie#challenge-length)))
        (std/net/bio/output#bio-write-u32
         std/actor/rpc/proto/cookie#challenge-length
         _obuf203642_)
        (std/net/bio/output#bio-write-bytes _challenge203645_ _obuf203642_)
        (std/net/bio/output#bio-force-output _obuf203642_)
        (let* ((_sz203647_ (std/net/bio/input#bio-read-u32 _ibuf203641_))
               (_g203675_
                (if (fx= _sz203647_
                         std/actor/rpc/proto/cookie#challenge-length)
                    '#!void
                    (std/actor/proto#raise-rpc-io-error
                     'rpc-proto-authen
                     '"challenge response size mismatch"
                     _sz203647_)))
               (_response203650_ (make-u8vector _sz203647_))
               (_g203676_
                (std/net/bio/input#bio-read-bytes
                 _response203650_
                 _ibuf203641_))
               (_secret203655_
                (let ((_digest203653_
                       (let ((__obj203673
                              (make-object std/crypto/digest#digest::t '2)))
                         (std/crypto/digest#digest:::init!
                          __obj203673
                          std/actor/rpc/proto/cookie#challenge-digest)
                         __obj203673)))
                  (std/crypto/digest#digest-update!__0
                   _digest203653_
                   _cookie203643_)
                  (std/crypto/digest#digest-update!__0
                   _digest203653_
                   _challenge203645_)
                  (std/crypto/digest#digest-final!__0 _digest203653_))))
          (if (equal? _response203650_ _secret203655_)
              (begin
                (std/net/bio/output#bio-write-u8
                 std/actor/rpc/proto/message#rpc-proto-connect-accept
                 _obuf203642_)
                (std/net/bio/output#bio-force-output _obuf203642_))
              (begin
                (std/net/bio/output#bio-write-u8
                 std/actor/rpc/proto/message#rpc-proto-connect-reject
                 _obuf203642_)
                (std/net/bio/output#bio-force-output _obuf203642_)
                (std/actor/proto#raise-rpc-io-error
                 'rpc-proto-authen
                 '"authentication failure"
                 _challenge203645_
                 _response203650_)))))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge-respond
    (lambda (_ibuf203624_ _obuf203625_ _cookie203626_)
      (let* ((_sz203628_ (std/net/bio/input#bio-read-u32 _ibuf203624_))
             (_g203677_
              (if (fx> _sz203628_ '1024)
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-authen
                   '"inordinately sized challenge"
                   _sz203628_)
                  '#!void))
             (_challenge203631_ (make-u8vector _sz203628_))
             (_g203678_
              (std/net/bio/input#bio-read-bytes
               _challenge203631_
               _ibuf203624_))
             (_digest203634_
              (let ((__obj203674 (make-object std/crypto/digest#digest::t '2)))
                (std/crypto/digest#digest:::init!
                 __obj203674
                 std/actor/rpc/proto/cookie#challenge-digest)
                __obj203674)))
        (std/crypto/digest#digest-update!__0 _digest203634_ _cookie203626_)
        (std/crypto/digest#digest-update!__0 _digest203634_ _challenge203631_)
        (let ((_response203637_
               (std/crypto/digest#digest-final!__0 _digest203634_)))
          (std/net/bio/output#bio-write-u32
           std/actor/rpc/proto/cookie#challenge-length
           _obuf203625_)
          (std/net/bio/output#bio-write-bytes _response203637_ _obuf203625_)
          (std/net/bio/output#bio-force-output _obuf203625_))
        (let ((_e203639_ (std/net/bio/input#bio-read-u8 _ibuf203624_)))
          (if (eq? _e203639_
                   std/actor/rpc/proto/message#rpc-proto-connect-accept)
              '#!void
              (if (eof-object? _e203639_)
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-authen
                   '"connection closed")
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-authen
                   '"authentication failure"
                   _e203639_)))))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto__%
    (lambda (_cookie-file203598_)
      (let ((_cookie203600_ (call-with-input-file _cookie-file203598_ read)))
        (if (u8vector? _cookie203600_)
            (##structure
             std/actor/rpc/base#!rpc-protocol::t
             (lambda (_g203601203604_ _g203602203606_)
               (std/actor/rpc/proto/cookie#rpc-cookie-proto-connect
                _g203601203604_
                _g203602203606_
                _cookie203600_))
             (lambda (_g203608203611_ _g203609203613_)
               (std/actor/rpc/proto/cookie#rpc-cookie-proto-accept
                _g203608203611_
                _g203609203613_
                _cookie203600_)))
            (error '"Invalid cookie; expected u8vector"
                   _cookie-file203598_
                   _cookie203600_)))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto__0
    (lambda ()
      (let ((_cookie-file203620_ '"~/.gerbil/cookie"))
        (std/actor/rpc/proto/cookie#rpc-cookie-proto__% _cookie-file203620_))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto
    (lambda _g203680_
      (let ((_g203679_ (length _g203680_)))
        (cond ((##fx= _g203679_ 0)
               (apply std/actor/rpc/proto/cookie#rpc-cookie-proto__0
                      _g203680_))
              ((##fx= _g203679_ 1)
               (apply std/actor/rpc/proto/cookie#rpc-cookie-proto__%
                      _g203680_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/proto/cookie#rpc-cookie-proto
                _g203680_))))))
  (define std/actor/rpc/proto/cookie#rpc-generate-cookie!__%
    (lambda (_cookie-file203581_)
      (let ((_cookie203583_
             (std/crypto/etc#random-bytes
              std/actor/rpc/proto/cookie#challenge-length)))
        (call-with-output-file
         _cookie-file203581_
         (lambda (_g203584203586_) (write _cookie203583_ _g203584203586_))))))
  (define std/actor/rpc/proto/cookie#rpc-generate-cookie!__0
    (lambda ()
      (let ((_cookie-file203593_ '"~/.gerbil/cookie"))
        (std/actor/rpc/proto/cookie#rpc-generate-cookie!__%
         _cookie-file203593_))))
  (define std/actor/rpc/proto/cookie#rpc-generate-cookie!
    (lambda _g203682_
      (let ((_g203681_ (length _g203682_)))
        (cond ((##fx= _g203681_ 0)
               (apply std/actor/rpc/proto/cookie#rpc-generate-cookie!__0
                      _g203682_))
              ((##fx= _g203681_ 1)
               (apply std/actor/rpc/proto/cookie#rpc-generate-cookie!__%
                      _g203682_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/proto/cookie#rpc-generate-cookie!
                _g203682_)))))))
