/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.text;

import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ReportContextImpl;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.SinglePassReportProcessor;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.PentahoFormulaContext;
import org.libreoffice.report.pentaho.output.text.TextRawReportTarget;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class TextRawReportProcessor
extends SinglePassReportProcessor {
    private final OutputRepository outputRepository;
    private final String targetName;
    private final InputRepository inputRepository;
    private final ImageService imageService;
    private final DataSourceFactory dataSourceFactory;

    public TextRawReportProcessor(InputRepository inputRepository, OutputRepository outputRepository, String string, ImageService imageService, DataSourceFactory dataSourceFactory) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (imageService == null) {
            throw new NullPointerException();
        }
        if (dataSourceFactory == null) {
            throw new NullPointerException();
        }
        this.targetName = string;
        this.inputRepository = inputRepository;
        this.outputRepository = outputRepository;
        this.imageService = imageService;
        this.dataSourceFactory = dataSourceFactory;
    }

    @Override
    protected ReportTarget createReportTarget(ReportJob reportJob) throws ReportProcessingException {
        ReportStructureRoot reportStructureRoot = reportJob.getReportStructureRoot();
        ResourceManager resourceManager = reportStructureRoot.getResourceManager();
        return new TextRawReportTarget(reportJob, resourceManager, reportStructureRoot.getBaseResource(), this.inputRepository, this.outputRepository, this.targetName, this.imageService, this.dataSourceFactory);
    }

    @Override
    protected ReportContext createReportContext(ReportJob reportJob, ReportTarget reportTarget) {
        ReportContext reportContext = super.createReportContext(reportJob, reportTarget);
        if (reportContext instanceof ReportContextImpl) {
            ReportContextImpl reportContextImpl = (ReportContextImpl)reportContext;
            reportContextImpl.setFormulaContext(new PentahoFormulaContext(reportContextImpl.getFormulaContext(), (Configuration)reportJob.getConfiguration()));
        }
        return reportContext;
    }
}

