<TeXmacs|1.99.11>

<style|<tuple|tmdoc|old-spacing|framed-session>>

<\body>
  <tmdoc-title|Example of <name|Graphviz> sessions>

  You may insert a <name|Graphviz> session using
  <menu|Insert|Session|Graph>viz.

  Type <verbatim|help>, you will get all the available graph backends.

  <\session|graphviz|default>
    <\output>
      dot - graphviz version 2.40.1 (20161225.0304)
    </output>

    <\unfolded-io>
      dot]\ 
    <|unfolded-io>
      help
    <|unfolded-io>
      [help, dot, neato, twopi, circo, fdp, sfdp, patchwork, osage]

      dot - graphviz version 2.40.1 (20161225.0304)
    </unfolded-io>

    <\unfolded-io>
      dot]\ 
    <|unfolded-io>
      neato
    <|unfolded-io>
      neato - graphviz version 2.40.1 (20161225.0304)
    </unfolded-io>

    <\unfolded-io>
      neato]\ 
    <|unfolded-io>
      twopi
    <|unfolded-io>
      twopi - graphviz version 2.40.1 (20161225.0304)
    </unfolded-io>

    <\input>
      twopi]\ 
    <|input>
      \;
    </input>
  </session>

  <section|The Magic Line><label|magicline>

  You may control the behavior of the graph generator via the magic line.

  <\session|graphviz|default>
    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 400

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|400px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 300

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|300px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %neato -width 400

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|400px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 300 -output png

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|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|png>|300px|||>
    </unfolded-io>

    <\input>
      twopi]\ 
    <|input>
      \;
    </input>
  </session>

  <\big-table|<block*|<tformat|<table|<row|<cell|Option>|<cell|Function>>|<row|<cell|-width>|<cell|control
  the width of the graph>>|<row|<cell|-height>|<cell|control the height of
  the graph>>|<row|<cell|-output>|<cell|control the internal output format of
  the graph>>>>>>
    Options on the magic line
  </big-table>

  Currently, only the <name|Graphviz> backend supports the switch of the
  output format. For some reason, the eps format does not always work fine
  for <name|Graphviz>. Don't worry, you may switch to png via the magic line.

  <section|Foldable>

  Sometimes, we do not care about how to generate the graph, but care about
  the graph itself. In this case we can just\ 

  <\with|par-columns|2>
    <\script-input|graph|default>
      %dot -height 400

      digraph G {

      \ v1 -\<gtr\> v2;

      \ v1 -\<gtr\> v3;

      \ v3 -\<gtr\> v2;

      \ v2 -\<gtr\> v4;

      \ v3 -\<gtr\> v4;

      \ v4 -\<gtr\> v5;

      \ v5 -\<gtr\> v4;

      \ v5 -\<gtr\> v3;

      \ v5 -\<gtr\> v6;

      \ v4 -\<gtr\> v6;

      \ v6 -\<gtr\> v7;

      }
    </script-input|<image|<tuple|<#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>|ps>||400px||>>

    <\script-output|graph|default>
      %dot -height 400

      digraph G {

      \ v1 -\<gtr\> v2;

      \ v1 -\<gtr\> v3;

      \ v3 -\<gtr\> v2;

      \ v2 -\<gtr\> v4;

      \ v3 -\<gtr\> v4;

      \ v4 -\<gtr\> v5;

      \ v5 -\<gtr\> v4;

      \ v5 -\<gtr\> v3;

      \ v5 -\<gtr\> v6;

      \ v4 -\<gtr\> v6;

      \ v6 -\<gtr\> v7;

      }
    </script-output|<image|<tuple|<#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>|ps>||400px||>>
  </with>

  <tmdoc-copyright|2019|Darcy Shen, Massimiliano Gubinelli>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|par-hyphen|normal>
    <associate|preamble|false>
  </collection>
</initial>