"use strict";

module.exports = function () {
  "use strict";
  /*
   * Generated by PEG.js 0.9.0.
   *
   * http://pegjs.org/
   */

  function peg$subclass(child, parent) {
    function ctor() {
      this.constructor = child;
    }

    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function peg$SyntaxError(message, expected, found, location) {
    this.message = message;
    this.expected = expected;
    this.found = found;
    this.location = location;
    this.name = "SyntaxError";

    if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }

  peg$subclass(peg$SyntaxError, Error);

  function peg$parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},
        parser = this,
        peg$FAILED = {},
        peg$startRuleFunctions = {
      start: peg$parsestart,
      Literal: peg$parseLiteral
    },
        peg$startRuleFunction = peg$parsestart,
        peg$c0 = function (query, trailing) {
      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      if (query !== null) return query;
      return nodeTypes.function.buildNode('is', '*', '*');
    },
        peg$c1 = function () {
      return errorOnLuceneSyntax;
    },
        peg$c2 = function (left, right) {
      const cursor = [left, right].find(node => node.type === 'cursor');
      if (cursor) return cursor;
      return buildFunctionNode('or', [left, right]);
    },
        peg$c3 = function (left, right) {
      const cursor = [left, right].find(node => node.type === 'cursor');
      if (cursor) return cursor;
      return buildFunctionNode('and', [left, right]);
    },
        peg$c4 = function (query) {
      if (query.type === 'cursor') return query;
      return buildFunctionNode('not', [query]);
    },
        peg$c5 = "(",
        peg$c6 = {
      type: "literal",
      value: "(",
      description: "\"(\""
    },
        peg$c7 = ")",
        peg$c8 = {
      type: "literal",
      value: ")",
      description: "\")\""
    },
        peg$c9 = function (query, trailing) {
      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      return query;
    },
        peg$c10 = ":",
        peg$c11 = {
      type: "literal",
      value: ":",
      description: "\":\""
    },
        peg$c12 = "{",
        peg$c13 = {
      type: "literal",
      value: "{",
      description: "\"{\""
    },
        peg$c14 = "}",
        peg$c15 = {
      type: "literal",
      value: "}",
      description: "\"}\""
    },
        peg$c16 = function (field, query, trailing) {
      if (query.type === 'cursor') {
        return { ...query,
          nestedPath: query.nestedPath ? `${field.value}.${query.nestedPath}` : field.value
        };
      }

      ;

      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      return buildFunctionNode('nested', [field, query]);
    },
        peg$c17 = {
      type: "other",
      description: "fieldName"
    },
        peg$c18 = function (field, operator, value) {
      if (value.type === 'cursor') {
        return { ...value,
          suggestionTypes: ['conjunction']
        };
      }

      const range = buildNamedArgNode(operator, value);
      return buildFunctionNode('range', [field, range]);
    },
        peg$c19 = function (field, partial) {
      if (partial.type === 'cursor') {
        return { ...partial,
          fieldName: field.value,
          suggestionTypes: ['value', 'conjunction']
        };
      }

      return partial(field);
    },
        peg$c20 = function (partial) {
      if (partial.type === 'cursor') {
        const fieldName = `${partial.prefix}${partial.suffix}`.trim();
        return { ...partial,
          fieldName,
          suggestionTypes: ['field', 'operator', 'conjunction']
        };
      }

      const field = buildLiteralNode(null);
      return partial(field);
    },
        peg$c21 = function (partial, trailing) {
      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      return partial;
    },
        peg$c22 = function (partialLeft, partialRight) {
      const cursor = [partialLeft, partialRight].find(node => node.type === 'cursor');

      if (cursor) {
        return { ...cursor,
          suggestionTypes: ['value']
        };
      }

      return field => buildFunctionNode('or', [partialLeft(field), partialRight(field)]);
    },
        peg$c23 = function (partialLeft, partialRight) {
      const cursor = [partialLeft, partialRight].find(node => node.type === 'cursor');

      if (cursor) {
        return { ...cursor,
          suggestionTypes: ['value']
        };
      }

      return field => buildFunctionNode('and', [partialLeft(field), partialRight(field)]);
    },
        peg$c24 = function (partial) {
      if (partial.type === 'cursor') {
        return { ...list,
          suggestionTypes: ['value']
        };
      }

      return field => buildFunctionNode('not', [partial(field)]);
    },
        peg$c25 = {
      type: "other",
      description: "value"
    },
        peg$c26 = function (value) {
      if (value.type === 'cursor') return value;
      const isPhrase = buildLiteralNode(true);
      return field => buildFunctionNode('is', [field, value, isPhrase]);
    },
        peg$c27 = function (value) {
      if (value.type === 'cursor') return value;

      if (!allowLeadingWildcards && value.type === 'wildcard' && nodeTypes.wildcard.hasLeadingWildcard(value)) {
        error('Leading wildcards are disabled. See query:allowLeadingWildcards in Advanced Settings.');
      }

      const isPhrase = buildLiteralNode(false);
      return field => buildFunctionNode('is', [field, value, isPhrase]);
    },
        peg$c28 = {
      type: "other",
      description: "OR"
    },
        peg$c29 = "or",
        peg$c30 = {
      type: "literal",
      value: "or",
      description: "\"or\""
    },
        peg$c31 = {
      type: "other",
      description: "AND"
    },
        peg$c32 = "and",
        peg$c33 = {
      type: "literal",
      value: "and",
      description: "\"and\""
    },
        peg$c34 = {
      type: "other",
      description: "NOT"
    },
        peg$c35 = "not",
        peg$c36 = {
      type: "literal",
      value: "not",
      description: "\"not\""
    },
        peg$c37 = {
      type: "other",
      description: "literal"
    },
        peg$c38 = "\"",
        peg$c39 = {
      type: "literal",
      value: "\"",
      description: "\"\\\"\""
    },
        peg$c40 = function (prefix, cursor, suffix) {
      const {
        start,
        end
      } = location();
      return {
        type: 'cursor',
        start: start.offset,
        end: end.offset - cursor.length,
        prefix: prefix.join(''),
        suffix: suffix.join(''),
        text: text().replace(cursor, '')
      };
    },
        peg$c41 = function (chars) {
      return buildLiteralNode(chars.join(''));
    },
        peg$c42 = "\\",
        peg$c43 = {
      type: "literal",
      value: "\\",
      description: "\"\\\\\""
    },
        peg$c44 = /^[\\"]/,
        peg$c45 = {
      type: "class",
      value: "[\\\\\"]",
      description: "[\\\\\"]"
    },
        peg$c46 = function (char) {
      return char;
    },
        peg$c47 = /^[^"]/,
        peg$c48 = {
      type: "class",
      value: "[^\"]",
      description: "[^\"]"
    },
        peg$c49 = function (chars) {
      const sequence = chars.join('').trim();
      if (sequence === 'null') return buildLiteralNode(null);
      if (sequence === 'true') return buildLiteralNode(true);
      if (sequence === 'false') return buildLiteralNode(false);
      if (chars.includes(wildcardSymbol)) return buildWildcardNode(sequence);
      const number = Number(sequence);
      const value = isNaN(number) ? sequence : number;
      return buildLiteralNode(value);
    },
        peg$c50 = {
      type: "any",
      description: "any character"
    },
        peg$c51 = "*",
        peg$c52 = {
      type: "literal",
      value: "*",
      description: "\"*\""
    },
        peg$c53 = function () {
      return wildcardSymbol;
    },
        peg$c54 = "\\t",
        peg$c55 = {
      type: "literal",
      value: "\\t",
      description: "\"\\\\t\""
    },
        peg$c56 = function () {
      return '\t';
    },
        peg$c57 = "\\r",
        peg$c58 = {
      type: "literal",
      value: "\\r",
      description: "\"\\\\r\""
    },
        peg$c59 = function () {
      return '\r';
    },
        peg$c60 = "\\n",
        peg$c61 = {
      type: "literal",
      value: "\\n",
      description: "\"\\\\n\""
    },
        peg$c62 = function () {
      return '\n';
    },
        peg$c63 = function (keyword) {
      return keyword;
    },
        peg$c64 = /^[\\():<>"*{}]/,
        peg$c65 = {
      type: "class",
      value: "[\\\\():<>\"*{}]",
      description: "[\\\\():<>\"*{}]"
    },
        peg$c66 = "<=",
        peg$c67 = {
      type: "literal",
      value: "<=",
      description: "\"<=\""
    },
        peg$c68 = function () {
      return 'lte';
    },
        peg$c69 = ">=",
        peg$c70 = {
      type: "literal",
      value: ">=",
      description: "\">=\""
    },
        peg$c71 = function () {
      return 'gte';
    },
        peg$c72 = "<",
        peg$c73 = {
      type: "literal",
      value: "<",
      description: "\"<\""
    },
        peg$c74 = function () {
      return 'lt';
    },
        peg$c75 = ">",
        peg$c76 = {
      type: "literal",
      value: ">",
      description: "\">\""
    },
        peg$c77 = function () {
      return 'gt';
    },
        peg$c78 = {
      type: "other",
      description: "whitespace"
    },
        peg$c79 = /^[ \t\r\n]/,
        peg$c80 = {
      type: "class",
      value: "[\\ \\t\\r\\n]",
      description: "[\\ \\t\\r\\n]"
    },
        peg$c81 = function () {
      return parseCursor;
    },
        peg$c82 = "@kuery-cursor@",
        peg$c83 = {
      type: "literal",
      value: "@kuery-cursor@",
      description: "\"@kuery-cursor@\""
    },
        peg$c84 = function () {
      return cursorSymbol;
    },
        peg$c85 = "||",
        peg$c86 = {
      type: "literal",
      value: "||",
      description: "\"||\""
    },
        peg$c87 = function () {
      error('LuceneOr');
    },
        peg$c88 = "&&",
        peg$c89 = {
      type: "literal",
      value: "&&",
      description: "\"&&\""
    },
        peg$c90 = function () {
      error('LuceneAnd');
    },
        peg$c91 = "+",
        peg$c92 = {
      type: "literal",
      value: "+",
      description: "\"+\""
    },
        peg$c93 = "-",
        peg$c94 = {
      type: "literal",
      value: "-",
      description: "\"-\""
    },
        peg$c95 = function () {
      error('LuceneNot');
    },
        peg$c96 = "!",
        peg$c97 = {
      type: "literal",
      value: "!",
      description: "\"!\""
    },
        peg$c98 = "_exists_",
        peg$c99 = {
      type: "literal",
      value: "_exists_",
      description: "\"_exists_\""
    },
        peg$c100 = function () {
      error('LuceneExists');
    },
        peg$c101 = function () {
      error('LuceneRange');
    },
        peg$c102 = "?",
        peg$c103 = {
      type: "literal",
      value: "?",
      description: "\"?\""
    },
        peg$c104 = function () {
      error('LuceneWildcard');
    },
        peg$c105 = "/",
        peg$c106 = {
      type: "literal",
      value: "/",
      description: "\"/\""
    },
        peg$c107 = /^[^\/]/,
        peg$c108 = {
      type: "class",
      value: "[^/]",
      description: "[^/]"
    },
        peg$c109 = function () {
      error('LuceneRegex');
    },
        peg$c110 = "~",
        peg$c111 = {
      type: "literal",
      value: "~",
      description: "\"~\""
    },
        peg$c112 = /^[0-9]/,
        peg$c113 = {
      type: "class",
      value: "[0-9]",
      description: "[0-9]"
    },
        peg$c114 = function () {
      error('LuceneFuzzy');
    },
        peg$c115 = function () {
      error('LuceneProximity');
    },
        peg$c116 = "^",
        peg$c117 = {
      type: "literal",
      value: "^",
      description: "\"^\""
    },
        peg$c118 = function () {
      error('LuceneBoost');
    },
        peg$c119 = function () {
      return char;
    },
        peg$c120 = "=",
        peg$c121 = {
      type: "literal",
      value: "=",
      description: "\"=\""
    },
        peg$c122 = "[",
        peg$c123 = {
      type: "literal",
      value: "[",
      description: "\"[\""
    },
        peg$c124 = "]",
        peg$c125 = {
      type: "literal",
      value: "]",
      description: "\"]\""
    },
        peg$c126 = "TO",
        peg$c127 = {
      type: "literal",
      value: "TO",
      description: "\"TO\""
    },
        peg$currPos = 0,
        peg$savedPos = 0,
        peg$posDetailsCache = [{
      line: 1,
      column: 1,
      seenCR: false
    }],
        peg$maxFailPos = 0,
        peg$maxFailExpected = [],
        peg$silentFails = 0,
        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }

    function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }

    function expected(description) {
      throw peg$buildException(null, [{
        type: "other",
        description: description
      }], input.substring(peg$savedPos, peg$currPos), peg$computeLocation(peg$savedPos, peg$currPos));
    }

    function error(message) {
      throw peg$buildException(message, null, input.substring(peg$savedPos, peg$currPos), peg$computeLocation(peg$savedPos, peg$currPos));
    }

    function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos],
          p,
          ch;

      if (details) {
        return details;
      } else {
        p = pos - 1;

        while (!peg$posDetailsCache[p]) {
          p--;
        }

        details = peg$posDetailsCache[p];
        details = {
          line: details.line,
          column: details.column,
          seenCR: details.seenCR
        };

        while (p < pos) {
          ch = input.charAt(p);

          if (ch === "\n") {
            if (!details.seenCR) {
              details.line++;
            }

            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }

          p++;
        }

        peg$posDetailsCache[pos] = details;
        return details;
      }
    }

    function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails = peg$computePosDetails(endPos);
      return {
        start: {
          offset: startPos,
          line: startPosDetails.line,
          column: startPosDetails.column
        },
        end: {
          offset: endPos,
          line: endPosDetails.line,
          column: endPosDetails.column
        }
      };
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) {
        return;
      }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, found, location) {
      function cleanupExpected(expected) {
        var i = 1;
        expected.sort(function (a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) {
            return ch.charCodeAt(0).toString(16).toUpperCase();
          }

          return s.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\x08/g, '\\b').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\f/g, '\\f').replace(/\r/g, '\\r').replace(/[\x00-\x07\x0B\x0E\x0F]/g, function (ch) {
            return '\\x0' + hex(ch);
          }).replace(/[\x10-\x1F\x80-\xFF]/g, function (ch) {
            return '\\x' + hex(ch);
          }).replace(/[\u0100-\u0FFF]/g, function (ch) {
            return '\\u0' + hex(ch);
          }).replace(/[\u1000-\uFFFF]/g, function (ch) {
            return '\\u' + hex(ch);
          });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc,
            foundDesc,
            i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1 ? expectedDescs.slice(0, -1).join(", ") + " or " + expectedDescs[expected.length - 1] : expectedDescs[0];
        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";
        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new peg$SyntaxError(message !== null ? message : buildMessage(expected, found), expected, found, location);
    }

    function peg$parsestart() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseOrQuery();

        if (s2 === peg$FAILED) {
          s2 = null;
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseOptionalSpace();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c0(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseOrQuery() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c1();

      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseLuceneQuery();

        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseAndQuery();

        if (s1 !== peg$FAILED) {
          s2 = peg$parseOr();

          if (s2 !== peg$FAILED) {
            s3 = peg$parseOrQuery();

            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c2(s1, s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }

        if (s0 === peg$FAILED) {
          s0 = peg$parseAndQuery();
        }
      }

      return s0;
    }

    function peg$parseAndQuery() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;
      s1 = peg$parseNotQuery();

      if (s1 !== peg$FAILED) {
        s2 = peg$parseAnd();

        if (s2 !== peg$FAILED) {
          s3 = peg$parseAndQuery();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c3(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseNotQuery();
      }

      return s0;
    }

    function peg$parseNotQuery() {
      var s0, s1, s2;
      s0 = peg$currPos;
      s1 = peg$parseNot();

      if (s1 !== peg$FAILED) {
        s2 = peg$parseSubQuery();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c4(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseSubQuery();
      }

      return s0;
    }

    function peg$parseSubQuery() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c5;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c6);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrQuery();

          if (s3 !== peg$FAILED) {
            s4 = peg$parseOptionalSpace();

            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c7;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c8);
                }
              }

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c9(s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseNestedQuery();
      }

      return s0;
    }

    function peg$parseNestedQuery() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;
      s0 = peg$currPos;
      s1 = peg$parseField();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c10;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c11);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 123) {
                s5 = peg$c12;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c13);
                }
              }

              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseSpace();

                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseSpace();
                }

                if (s6 !== peg$FAILED) {
                  s7 = peg$parseOrQuery();

                  if (s7 !== peg$FAILED) {
                    s8 = peg$parseOptionalSpace();

                    if (s8 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 125) {
                        s9 = peg$c14;
                        peg$currPos++;
                      } else {
                        s9 = peg$FAILED;

                        if (peg$silentFails === 0) {
                          peg$fail(peg$c15);
                        }
                      }

                      if (s9 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c16(s1, s7, s8);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseExpression();
      }

      return s0;
    }

    function peg$parseExpression() {
      var s0;
      s0 = peg$parseFieldRangeExpression();

      if (s0 === peg$FAILED) {
        s0 = peg$parseFieldValueExpression();

        if (s0 === peg$FAILED) {
          s0 = peg$parseValueExpression();
        }
      }

      return s0;
    }

    function peg$parseField() {
      var s0, s1;
      peg$silentFails++;
      s0 = peg$parseLiteral();
      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c17);
        }
      }

      return s0;
    }

    function peg$parseFieldRangeExpression() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;
      s1 = peg$parseField();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseRangeOperator();

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseLiteral();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c18(s1, s3, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseFieldValueExpression() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;
      s1 = peg$parseField();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c10;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c11);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseListOfValues();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c19(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseValueExpression() {
      var s0, s1;
      s0 = peg$currPos;
      s1 = peg$parseValue();

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c20(s1);
      }

      s0 = s1;
      return s0;
    }

    function peg$parseListOfValues() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c5;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c6);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrListOfValues();

          if (s3 !== peg$FAILED) {
            s4 = peg$parseOptionalSpace();

            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c7;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c8);
                }
              }

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c21(s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseValue();
      }

      return s0;
    }

    function peg$parseOrListOfValues() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;
      s1 = peg$parseAndListOfValues();

      if (s1 !== peg$FAILED) {
        s2 = peg$parseOr();

        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrListOfValues();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c22(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseAndListOfValues();
      }

      return s0;
    }

    function peg$parseAndListOfValues() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;
      s1 = peg$parseNotListOfValues();

      if (s1 !== peg$FAILED) {
        s2 = peg$parseAnd();

        if (s2 !== peg$FAILED) {
          s3 = peg$parseAndListOfValues();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c23(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseNotListOfValues();
      }

      return s0;
    }

    function peg$parseNotListOfValues() {
      var s0, s1, s2;
      s0 = peg$currPos;
      s1 = peg$parseNot();

      if (s1 !== peg$FAILED) {
        s2 = peg$parseListOfValues();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c24(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseListOfValues();
      }

      return s0;
    }

    function peg$parseValue() {
      var s0, s1;
      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseQuotedString();

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c26(s1);
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseUnquotedLiteral();

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c27(s1);
        }

        s0 = s1;
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c25);
        }
      }

      return s0;
    }

    function peg$parseOr() {
      var s0, s1, s2, s3, s4;
      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c29) {
          s2 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c30);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }

          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        peg$savedPos = peg$currPos;
        s1 = peg$c1();

        if (s1) {
          s1 = void 0;
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          s2 = peg$parseLuceneOr();

          if (s2 !== peg$FAILED) {
            s1 = [s1, s2];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c28);
        }
      }

      return s0;
    }

    function peg$parseAnd() {
      var s0, s1, s2, s3, s4;
      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c32) {
          s2 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c33);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }

          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        peg$savedPos = peg$currPos;
        s1 = peg$c1();

        if (s1) {
          s1 = void 0;
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          s2 = peg$parseLuceneAnd();

          if (s2 !== peg$FAILED) {
            s1 = [s1, s2];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c31);
        }
      }

      return s0;
    }

    function peg$parseNot() {
      var s0, s1, s2, s3;
      peg$silentFails++;
      s0 = peg$currPos;

      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c35) {
        s1 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c36);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseSpace();
          }
        } else {
          s2 = peg$FAILED;
        }

        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        peg$savedPos = peg$currPos;
        s1 = peg$c1();

        if (s1) {
          s1 = void 0;
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          s2 = peg$parseLuceneNot();

          if (s2 !== peg$FAILED) {
            s1 = [s1, s2];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c34);
        }
      }

      return s0;
    }

    function peg$parseLiteral() {
      var s0, s1;
      peg$silentFails++;
      s0 = peg$parseQuotedString();

      if (s0 === peg$FAILED) {
        s0 = peg$parseUnquotedLiteral();
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c37);
        }
      }

      return s0;
    }

    function peg$parseQuotedString() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 34) {
        s1 = peg$c38;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c39);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseQuotedCharacter();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseQuotedCharacter();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseCursor();

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseQuotedCharacter();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseQuotedCharacter();
            }

            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 34) {
                s5 = peg$c38;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c39);
                }
              }

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c40(s2, s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 34) {
          s1 = peg$c38;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c39);
          }
        }

        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseQuotedCharacter();

          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseQuotedCharacter();
          }

          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 34) {
              s3 = peg$c38;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c39);
              }
            }

            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c41(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      return s0;
    }

    function peg$parseQuotedCharacter() {
      var s0, s1, s2;
      s0 = peg$parseEscapedWhitespace();

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 92) {
          s1 = peg$c42;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c43);
          }
        }

        if (s1 !== peg$FAILED) {
          if (peg$c44.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c45);
            }
          }

          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c46(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$currPos;
          peg$silentFails++;
          s2 = peg$parseCursor();
          peg$silentFails--;

          if (s2 === peg$FAILED) {
            s1 = void 0;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }

          if (s1 !== peg$FAILED) {
            if (peg$c47.test(input.charAt(peg$currPos))) {
              s2 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s2 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c48);
              }
            }

            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c46(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }

      return s0;
    }

    function peg$parseUnquotedLiteral() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseUnquotedCharacter();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseUnquotedCharacter();
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseCursor();

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseUnquotedCharacter();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseUnquotedCharacter();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c40(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseUnquotedCharacter();

        if (s2 !== peg$FAILED) {
          while (s2 !== peg$FAILED) {
            s1.push(s2);
            s2 = peg$parseUnquotedCharacter();
          }
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c49(s1);
        }

        s0 = s1;
      }

      return s0;
    }

    function peg$parseUnquotedCharacter() {
      var s0, s1, s2, s3, s4;
      s0 = peg$parseEscapedWhitespace();

      if (s0 === peg$FAILED) {
        s0 = peg$parseEscapedSpecialCharacter();

        if (s0 === peg$FAILED) {
          s0 = peg$parseEscapedKeyword();

          if (s0 === peg$FAILED) {
            s0 = peg$parseWildcard();

            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$currPos;
              peg$silentFails++;
              s2 = peg$parseSpecialCharacter();
              peg$silentFails--;

              if (s2 === peg$FAILED) {
                s1 = void 0;
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }

              if (s1 !== peg$FAILED) {
                s2 = peg$currPos;
                peg$silentFails++;
                s3 = peg$parseKeyword();
                peg$silentFails--;

                if (s3 === peg$FAILED) {
                  s2 = void 0;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }

                if (s2 !== peg$FAILED) {
                  s3 = peg$currPos;
                  peg$silentFails++;
                  s4 = peg$parseCursor();
                  peg$silentFails--;

                  if (s4 === peg$FAILED) {
                    s3 = void 0;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }

                  if (s3 !== peg$FAILED) {
                    if (input.length > peg$currPos) {
                      s4 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s4 = peg$FAILED;

                      if (peg$silentFails === 0) {
                        peg$fail(peg$c50);
                      }
                    }

                    if (s4 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c46(s4);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parseWildcard() {
      var s0, s1;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 42) {
        s1 = peg$c51;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c52);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c53();
      }

      s0 = s1;
      return s0;
    }

    function peg$parseOptionalSpace() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseCursor();

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c40(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = [];
        s1 = peg$parseSpace();

        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$parseSpace();
        }
      }

      return s0;
    }

    function peg$parseEscapedWhitespace() {
      var s0, s1;
      s0 = peg$currPos;

      if (input.substr(peg$currPos, 2) === peg$c54) {
        s1 = peg$c54;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c55);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c56();
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.substr(peg$currPos, 2) === peg$c57) {
          s1 = peg$c57;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c58);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c59();
        }

        s0 = s1;

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;

          if (input.substr(peg$currPos, 2) === peg$c60) {
            s1 = peg$c60;
            peg$currPos += 2;
          } else {
            s1 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c61);
            }
          }

          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c62();
          }

          s0 = s1;
        }
      }

      return s0;
    }

    function peg$parseEscapedSpecialCharacter() {
      var s0, s1, s2;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c42;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c43);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseSpecialCharacter();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c46(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseEscapedKeyword() {
      var s0, s1, s2;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c42;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c43);
        }
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c29) {
          s2 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c30);
          }
        }

        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c32) {
            s2 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c33);
            }
          }

          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c35) {
              s2 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s2 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c36);
              }
            }
          }
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c63(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseKeyword() {
      var s0;
      s0 = peg$parseOr();

      if (s0 === peg$FAILED) {
        s0 = peg$parseAnd();

        if (s0 === peg$FAILED) {
          s0 = peg$parseNot();
        }
      }

      return s0;
    }

    function peg$parseSpecialCharacter() {
      var s0;

      if (peg$c64.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c65);
        }
      }

      return s0;
    }

    function peg$parseRangeOperator() {
      var s0, s1;
      s0 = peg$currPos;

      if (input.substr(peg$currPos, 2) === peg$c66) {
        s1 = peg$c66;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c67);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c68();
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.substr(peg$currPos, 2) === peg$c69) {
          s1 = peg$c69;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c70);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c71();
        }

        s0 = s1;

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;

          if (input.charCodeAt(peg$currPos) === 60) {
            s1 = peg$c72;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c73);
            }
          }

          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c74();
          }

          s0 = s1;

          if (s0 === peg$FAILED) {
            s0 = peg$currPos;

            if (input.charCodeAt(peg$currPos) === 62) {
              s1 = peg$c75;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c76);
              }
            }

            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c77();
            }

            s0 = s1;
          }
        }
      }

      return s0;
    }

    function peg$parseSpace() {
      var s0, s1;
      peg$silentFails++;

      if (peg$c79.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c80);
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c78);
        }
      }

      return s0;
    }

    function peg$parseCursor() {
      var s0, s1, s2;
      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c81();

      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 14) === peg$c82) {
          s2 = peg$c82;
          peg$currPos += 14;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c83);
          }
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c84();
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneOr() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c85) {
          s2 = peg$c85;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c86);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c87();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneAnd() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c88) {
          s2 = peg$c88;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c89);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c90();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 43) {
          s1 = peg$c91;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c92);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c90();
        }

        s0 = s1;
      }

      return s0;
    }

    function peg$parseLuceneNot() {
      var s0, s1;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 45) {
        s1 = peg$c93;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c94);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c95();
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 33) {
          s1 = peg$c96;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c97);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c95();
        }

        s0 = s1;
      }

      return s0;
    }

    function peg$parseLuceneQuery() {
      var s0;
      s0 = peg$parseLuceneFieldQuery();

      if (s0 === peg$FAILED) {
        s0 = peg$parseLuceneValue();

        if (s0 === peg$FAILED) {
          s0 = peg$parseLuceneExists();
        }
      }

      return s0;
    }

    function peg$parseLuceneFieldQuery() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;
      s1 = peg$parseLuceneLiteral();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c10;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c11);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseLuceneValue();

              if (s5 !== peg$FAILED) {
                s1 = [s1, s2, s3, s4, s5];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneValue() {
      var s0;
      s0 = peg$parseLuceneRange();

      if (s0 === peg$FAILED) {
        s0 = peg$parseLuceneWildcard();

        if (s0 === peg$FAILED) {
          s0 = peg$parseLuceneRegex();

          if (s0 === peg$FAILED) {
            s0 = peg$parseLuceneFuzzy();

            if (s0 === peg$FAILED) {
              s0 = peg$parseLuceneProximity();

              if (s0 === peg$FAILED) {
                s0 = peg$parseLuceneBoost();
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parseLuceneExists() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;

      if (input.substr(peg$currPos, 8) === peg$c98) {
        s1 = peg$c98;
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c99);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c10;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c11);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseLuceneLiteral();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c100();
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneRange() {
      var s0, s1, s2, s3, s4, s5, s6;
      s0 = peg$currPos;
      s1 = peg$parseRangeOperator();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseLuceneLiteral();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c101();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseLuceneRangeStart();

        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseSpace();

          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseSpace();
          }

          if (s2 !== peg$FAILED) {
            s3 = peg$parseLuceneLiteral();

            if (s3 !== peg$FAILED) {
              s4 = peg$parseLuceneTo();

              if (s4 !== peg$FAILED) {
                s5 = peg$parseLuceneLiteral();

                if (s5 !== peg$FAILED) {
                  s6 = peg$parseLuceneRangeEnd();

                  if (s6 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c101();
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      return s0;
    }

    function peg$parseLuceneWildcard() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseLuceneUnquotedCharacter();

      if (s2 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 42) {
          s2 = peg$c51;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c52);
          }
        }
      }

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseLuceneUnquotedCharacter();

        if (s2 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 42) {
            s2 = peg$c51;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c52);
            }
          }
        }
      }

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 63) {
          s2 = peg$c102;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c103);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseLuceneWildcard();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseLuceneWildcard();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c104();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneRegex() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 47) {
        s1 = peg$c105;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c106);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];

        if (peg$c107.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c108);
          }
        }

        while (s3 !== peg$FAILED) {
          s2.push(s3);

          if (peg$c107.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c108);
            }
          }
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 47) {
            s3 = peg$c105;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c106);
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c109();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneFuzzy() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = peg$parseLuceneUnquotedLiteral();

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 126) {
          s2 = peg$c110;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c111);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];

          if (peg$c112.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c113);
            }
          }

          while (s4 !== peg$FAILED) {
            s3.push(s4);

            if (peg$c112.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c113);
              }
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c114();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneProximity() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = peg$parseQuotedString();

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 126) {
          s2 = peg$c110;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c111);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];

          if (peg$c112.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c113);
            }
          }

          while (s4 !== peg$FAILED) {
            s3.push(s4);

            if (peg$c112.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c113);
              }
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c115();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneBoost() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = peg$parseLuceneLiteral();

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 94) {
          s2 = peg$c116;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c117);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];

          if (peg$c112.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c113);
            }
          }

          while (s4 !== peg$FAILED) {
            s3.push(s4);

            if (peg$c112.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c113);
              }
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c118();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneLiteral() {
      var s0;
      s0 = peg$parseQuotedString();

      if (s0 === peg$FAILED) {
        s0 = peg$parseLuceneUnquotedLiteral();
      }

      return s0;
    }

    function peg$parseLuceneUnquotedLiteral() {
      var s0, s1;
      s0 = [];
      s1 = peg$parseLuceneUnquotedCharacter();

      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$parseLuceneUnquotedCharacter();
        }
      } else {
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneUnquotedCharacter() {
      var s0, s1, s2, s3;
      s0 = peg$parseEscapedWhitespace();

      if (s0 === peg$FAILED) {
        s0 = peg$parseEscapedLuceneSpecialCharacter();

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$currPos;
          peg$silentFails++;
          s2 = peg$parseLuceneSpecialCharacter();
          peg$silentFails--;

          if (s2 === peg$FAILED) {
            s1 = void 0;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }

          if (s1 !== peg$FAILED) {
            s2 = peg$currPos;
            peg$silentFails++;
            s3 = peg$parseLuceneKeyword();
            peg$silentFails--;

            if (s3 === peg$FAILED) {
              s2 = void 0;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }

            if (s2 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c50);
                }
              }

              if (s3 !== peg$FAILED) {
                s1 = [s1, s2, s3];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }

      return s0;
    }

    function peg$parseLuceneKeyword() {
      var s0;
      s0 = peg$parseOr();

      if (s0 === peg$FAILED) {
        s0 = peg$parseAnd();

        if (s0 === peg$FAILED) {
          s0 = peg$parseLuceneOr();

          if (s0 === peg$FAILED) {
            s0 = peg$parseLuceneAnd();

            if (s0 === peg$FAILED) {
              s0 = peg$parseLuceneNot();

              if (s0 === peg$FAILED) {
                s0 = peg$parseLuceneTo();
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parseEscapedLuceneSpecialCharacter() {
      var s0, s1, s2;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c42;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c43);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseLuceneSpecialCharacter();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c119();
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneSpecialCharacter() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 43) {
        s0 = peg$c91;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c92);
        }
      }

      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s0 = peg$c93;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c94);
          }
        }

        if (s0 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 61) {
            s0 = peg$c120;
            peg$currPos++;
          } else {
            s0 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c121);
            }
          }

          if (s0 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 62) {
              s0 = peg$c75;
              peg$currPos++;
            } else {
              s0 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c76);
              }
            }

            if (s0 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 60) {
                s0 = peg$c72;
                peg$currPos++;
              } else {
                s0 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c73);
                }
              }

              if (s0 === peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 33) {
                  s0 = peg$c96;
                  peg$currPos++;
                } else {
                  s0 = peg$FAILED;

                  if (peg$silentFails === 0) {
                    peg$fail(peg$c97);
                  }
                }

                if (s0 === peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 40) {
                    s0 = peg$c5;
                    peg$currPos++;
                  } else {
                    s0 = peg$FAILED;

                    if (peg$silentFails === 0) {
                      peg$fail(peg$c6);
                    }
                  }

                  if (s0 === peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                      s0 = peg$c7;
                      peg$currPos++;
                    } else {
                      s0 = peg$FAILED;

                      if (peg$silentFails === 0) {
                        peg$fail(peg$c8);
                      }
                    }

                    if (s0 === peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 123) {
                        s0 = peg$c12;
                        peg$currPos++;
                      } else {
                        s0 = peg$FAILED;

                        if (peg$silentFails === 0) {
                          peg$fail(peg$c13);
                        }
                      }

                      if (s0 === peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 125) {
                          s0 = peg$c14;
                          peg$currPos++;
                        } else {
                          s0 = peg$FAILED;

                          if (peg$silentFails === 0) {
                            peg$fail(peg$c15);
                          }
                        }

                        if (s0 === peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 91) {
                            s0 = peg$c122;
                            peg$currPos++;
                          } else {
                            s0 = peg$FAILED;

                            if (peg$silentFails === 0) {
                              peg$fail(peg$c123);
                            }
                          }

                          if (s0 === peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 93) {
                              s0 = peg$c124;
                              peg$currPos++;
                            } else {
                              s0 = peg$FAILED;

                              if (peg$silentFails === 0) {
                                peg$fail(peg$c125);
                              }
                            }

                            if (s0 === peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 94) {
                                s0 = peg$c116;
                                peg$currPos++;
                              } else {
                                s0 = peg$FAILED;

                                if (peg$silentFails === 0) {
                                  peg$fail(peg$c117);
                                }
                              }

                              if (s0 === peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 34) {
                                  s0 = peg$c38;
                                  peg$currPos++;
                                } else {
                                  s0 = peg$FAILED;

                                  if (peg$silentFails === 0) {
                                    peg$fail(peg$c39);
                                  }
                                }

                                if (s0 === peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 126) {
                                    s0 = peg$c110;
                                    peg$currPos++;
                                  } else {
                                    s0 = peg$FAILED;

                                    if (peg$silentFails === 0) {
                                      peg$fail(peg$c111);
                                    }
                                  }

                                  if (s0 === peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 42) {
                                      s0 = peg$c51;
                                      peg$currPos++;
                                    } else {
                                      s0 = peg$FAILED;

                                      if (peg$silentFails === 0) {
                                        peg$fail(peg$c52);
                                      }
                                    }

                                    if (s0 === peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 63) {
                                        s0 = peg$c102;
                                        peg$currPos++;
                                      } else {
                                        s0 = peg$FAILED;

                                        if (peg$silentFails === 0) {
                                          peg$fail(peg$c103);
                                        }
                                      }

                                      if (s0 === peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 58) {
                                          s0 = peg$c10;
                                          peg$currPos++;
                                        } else {
                                          s0 = peg$FAILED;

                                          if (peg$silentFails === 0) {
                                            peg$fail(peg$c11);
                                          }
                                        }

                                        if (s0 === peg$FAILED) {
                                          if (input.charCodeAt(peg$currPos) === 92) {
                                            s0 = peg$c42;
                                            peg$currPos++;
                                          } else {
                                            s0 = peg$FAILED;

                                            if (peg$silentFails === 0) {
                                              peg$fail(peg$c43);
                                            }
                                          }

                                          if (s0 === peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 47) {
                                              s0 = peg$c105;
                                              peg$currPos++;
                                            } else {
                                              s0 = peg$FAILED;

                                              if (peg$silentFails === 0) {
                                                peg$fail(peg$c106);
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parseLuceneTo() {
      var s0, s1, s2, s3, s4;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c126) {
          s2 = peg$c126;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c127);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }

          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLuceneRangeStart() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 91) {
        s0 = peg$c122;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c123);
        }
      }

      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 123) {
          s0 = peg$c12;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c13);
          }
        }
      }

      return s0;
    }

    function peg$parseLuceneRangeEnd() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 93) {
        s0 = peg$c124;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c125);
        }
      }

      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 125) {
          s0 = peg$c14;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c15);
          }
        }
      }

      return s0;
    }

    const {
      errorOnLuceneSyntax,
      parseCursor,
      cursorSymbol,
      allowLeadingWildcards = true,
      helpers: {
        nodeTypes
      }
    } = options;
    const buildFunctionNode = nodeTypes.function.buildNodeWithArgumentNodes;
    const buildLiteralNode = nodeTypes.literal.buildNode;
    const buildWildcardNode = nodeTypes.wildcard.buildNode;
    const buildNamedArgNode = nodeTypes.namedArg.buildNode;
    const {
      wildcardSymbol
    } = nodeTypes.wildcard;
    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({
          type: "end",
          description: "end of input"
        });
      }

      throw peg$buildException(null, peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1) : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
  }

  return {
    SyntaxError: peg$SyntaxError,
    parse: peg$parse
  };
}();