"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var geometry_1 = require("../../../utils/geometry");
var accessor_1 = require("../../../utils/accessor");
var series_1 = require("../utils/series");
exports.Y0_ACCESSOR_POSTFIX = ' - lower';
exports.Y1_ACCESSOR_POSTFIX = ' - upper';
function getSeriesTooltipValues(tooltipValues, defaultValue) {
    // map from seriesKey to TooltipLegendValue
    var seriesTooltipValues = new Map();
    // First TooltipLegendValue is the header
    if (tooltipValues.length <= 1) {
        return seriesTooltipValues;
    }
    tooltipValues.slice(1).forEach(function (_a) {
        var _b;
        var seriesKey = _a.seriesKey, value = _a.value, yAccessor = _a.yAccessor;
        var seriesValue = defaultValue ? defaultValue : value;
        var current = seriesTooltipValues.get(seriesKey) || {};
        seriesTooltipValues.set(seriesKey, __assign(__assign({ y0: defaultValue, y1: defaultValue }, current), (_b = {}, _b[yAccessor] = seriesValue, _b)));
    });
    return seriesTooltipValues;
}
exports.getSeriesTooltipValues = getSeriesTooltipValues;
function formatTooltip(_a, spec, isXValue, isHighlighted, hasSingleSeries, axisSpec) {
    var color = _a.color, _b = _a.value, x = _b.x, y = _b.y, accessor = _b.accessor, seriesIdentifier = _a.seriesIdentifier;
    var seriesKey = series_1.getSeriesKey(seriesIdentifier);
    var displayName = series_1.getSeriesLabel(seriesIdentifier, hasSingleSeries, true, spec);
    if (specs_1.isBandedSpec(spec.y0Accessors) && (specs_1.isAreaSeriesSpec(spec) || specs_1.isBarSeriesSpec(spec))) {
        var _c = spec.y0AccessorFormat, y0AccessorFormat = _c === void 0 ? exports.Y0_ACCESSOR_POSTFIX : _c, _d = spec.y1AccessorFormat, y1AccessorFormat = _d === void 0 ? exports.Y1_ACCESSOR_POSTFIX : _d;
        var formatter = accessor === geometry_1.BandedAccessorType.Y0 ? y0AccessorFormat : y1AccessorFormat;
        displayName = accessor_1.getAccessorFormatLabel(formatter, displayName);
    }
    var isFiltered = spec.filterSeriesInTooltip !== undefined ? spec.filterSeriesInTooltip(seriesIdentifier) : true;
    var isVisible = displayName === '' ? false : isFiltered;
    var value = isXValue ? x : y;
    var tickFormatOptions = spec.timeZone ? { timeZone: spec.timeZone } : undefined;
    return {
        seriesKey: seriesKey,
        name: displayName,
        value: axisSpec ? axisSpec.tickFormat(value, tickFormatOptions) : emptyFormatter(value),
        color: color,
        isHighlighted: isXValue ? false : isHighlighted,
        isXValue: isXValue,
        yAccessor: accessor,
        isVisible: isVisible,
    };
}
exports.formatTooltip = formatTooltip;
function emptyFormatter(value) {
    return value;
}
//# sourceMappingURL=tooltip.js.map